/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.httptohttpsstrategyimpl;

import com.yy.base.dynamicswitch.DynamicSwitchFactory;
import com.yy.base.imageloader.httptohttpsstrategyimpl.TransformHttpsStrategyStat;
import com.yy.base.imageloader.strategy.IStrategySelector;
import com.yy.base.imageloader.strategy.StrategyStatus;
import com.yy.base.imageloader.strategy.StrategyType;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpsSchemeTransformStrategy
implements IStrategySelector<String, Integer, StrategyStatus, StrategyType> {
    private static final String TAG = "httpsscheme";
    private static final long TIMEOUT = 120000L;
    private static final long DELAY = 125000L;
    private final int mMaxHttpToHttpsSuccessTimes = SettingFlags.getIntValue("image_max_http_err_times", 3);
    private final ConcurrentHashMap<Integer, Long> mConcurrentHashMap = new ConcurrentHashMap();
    private int mHttpToHttpsSucessTimes = 0;
    private volatile boolean mEnableHttps = false;
    private volatile boolean mIsRunningTimeout = false;
    private Runnable mTimeoutRunnable = () -> {
        Iterator<Map.Entry<Integer, Long>> it = this.mConcurrentHashMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Long> item = it.next();
            Integer key = item.getKey();
            long time = item.getValue();
            if (System.currentTimeMillis() - time < 120000L) continue;
            it.remove();
            MLog.debug(TAG, "timeout remove size " + this.mConcurrentHashMap.size() + " add id " + key, new Object[0]);
        }
        this.mIsRunningTimeout = false;
        if (this.mConcurrentHashMap.size() > 0) {
            this.clearTimeoutId();
        }
    };

    private void notifyResultSucess(Integer id2) {
        if (!this.enableHttps() && this.mConcurrentHashMap.containsKey(id2)) {
            ++this.mHttpToHttpsSucessTimes;
            if (this.mHttpToHttpsSucessTimes >= this.mMaxHttpToHttpsSuccessTimes) {
                this.mEnableHttps = true;
                TransformHttpsStrategyStat.statTransformHttpsStrategy();
                MLog.error((Object)TAG, "notifyResultSucess switch https", new Object[0]);
            }
            this.mConcurrentHashMap.remove(id2);
            MLog.debug(TAG, "notifyResultSucess strategySelector size " + this.mConcurrentHashMap.size() + " remove id " + id2, new Object[0]);
        }
    }

    private boolean enableHttps() {
        return this.mEnableHttps;
    }

    private void notifyResultError(Integer id2) {
        if (!this.enableHttps() && this.mConcurrentHashMap.containsKey(id2)) {
            this.mConcurrentHashMap.remove(id2);
            MLog.debug(TAG, "notifyResultError strategySelector size " + this.mConcurrentHashMap.size() + " remove id " + id2, new Object[0]);
        }
    }

    private String tryTransformHttpsToHttp(String url) {
        if (DynamicSwitchFactory.getIDynamicSwitch().useHttp() && URLUtils.isHttpsScheme(url) && !this.enableHttps()) {
            url = URLUtils.replaceHttpsToHttp(url);
        }
        return url;
    }

    @Override
    public String strategySelectorResult(StrategyStatus strategy, String url) {
        if (strategy == StrategyStatus.FINAL) {
            url = StringUtils.isNotEmpty(url) && URLUtils.isHttpScheme(url) && this.enableHttps() ? URLUtils.replaceHttpToHttps(url) : this.tryTransformHttpsToHttp(url);
            return url;
        }
        if (strategy == StrategyStatus.START) {
            if (StringUtils.isNotEmpty(url) && URLUtils.isHttpScheme(url)) {
                url = URLUtils.replaceHttpToHttps(url);
            }
            return url;
        }
        return url;
    }

    private void strategySelectorStart(Integer id2) {
        if (!this.enableHttps() && !this.mConcurrentHashMap.containsKey(id2)) {
            this.mConcurrentHashMap.put(id2, System.currentTimeMillis());
            this.clearTimeoutId();
            MLog.debug(TAG, "strategySelector size " + this.mConcurrentHashMap.size() + " add id " + id2, new Object[0]);
        }
    }

    @Override
    public void strategySelectorStatus(StrategyStatus strategy, Integer id2) {
        if (strategy == StrategyStatus.SUCESS) {
            this.notifyResultSucess(id2);
        } else if (strategy == StrategyStatus.FAIL) {
            this.notifyResultError(id2);
        } else if (StrategyStatus.START == strategy) {
            this.strategySelectorStart(id2);
        }
    }

    @Override
    public StrategyType strategySelectorType() {
        return this.enableHttps() ? StrategyType.HTTPS : StrategyType.HTTP;
    }

    private void clearTimeoutId() {
        if (!this.mIsRunningTimeout) {
            this.mIsRunningTimeout = true;
            YYTaskExecutor.removeTask(this.mTimeoutRunnable);
            YYTaskExecutor.execute(this.mTimeoutRunnable, 125000L);
        }
    }
}

