/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.webkit.MimeTypeMap;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.utils.BasicFileUtils;
import com.yy.base.utils.BlankUtil;
import com.yy.base.utils.DigestUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.ImageUriComp;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.filestorage.MimeUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class YYFileUtils
extends BasicFileUtils {
    public static final String TEMP_DIR = "temp";
    private static final String ACT_RECOMMAND_FILE = "temp_act_recomm.txt";
    private static final String RECORD_EXT_HIGH_CPU = ".aac";
    private static final String RECORD_EXT_LOW_CPU = ".wav";
    private static final String RECORD_PUBLISH_EXT = ".m4a";
    private static final int MIN_LEN_OF_VALID_WAV = 131072;
    private static final int MIN_LEN_OF_VALID_AAC = 8192;
    public static final byte SUCCESS = 0;
    public static final byte NULL_FILE = 1;
    public static final byte ALREADY_FILE = 2;
    public static final byte MKDIR_ERROR = 3;
    public static final byte NO_SPACE = 4;
    public static final byte UNKONW_ERROR = 5;
    public static final byte NOT_ALL = 6;
    public static final byte FAILED = 7;
    private static final AtomicInteger mUnzipTmpIndex = new AtomicInteger(0);
    static final String[] AUDIO_EXTS = new String[]{".aac", ".wav", ".m4a", ".rec", ".mp4", ".rec2"};
    private FileOutputStream mFileOutputStream;
    private BufferedOutputStream mBufferedOutputStream;
    private File mFile;
    private static OnMonitorFileOperate mOnMonitorFileOperate = new OnMonitorFileOperate(){

        @Override
        public void onFileExist(String filePath) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onFileExist(filePath);
            }
            PerfActionLog.add("File_onFileExist:%s", filePath);
        }

        @Override
        public void onNewFile(String filePath) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onNewFile(filePath);
            }
            PerfActionLog.add("File_onNewFile:%s", filePath);
        }

        @Override
        public void onCopyFile(String originFilePath, String desFilePath) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onCopyFile(originFilePath, desFilePath);
            }
            PerfActionLog.add("File_onCopyFile:%s,%s", originFilePath, desFilePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeleteFile(String filePath) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onDeleteFile(filePath);
            }
            ArrayList arrayList = dirExistList;
            synchronized (arrayList) {
                dirExistList.remove(filePath);
            }
            arrayList = fileExistAndNotEmptyList;
            synchronized (arrayList) {
                fileExistAndNotEmptyList.remove(filePath);
            }
            PerfActionLog.add("File_onDeleteFile:%s", filePath);
        }

        @Override
        public void onReadContentFromFile(String filePath, int size) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onReadContentFromFile(filePath, size);
            }
            PerfActionLog.add("File_onReadContentFromFile:%s", filePath);
        }

        @Override
        public void onWriteContentToFile(String filePath, int size) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onWriteContentToFile(filePath, size);
            }
            PerfActionLog.add("File_onWriteContentToFile:%s", filePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRenameFile(String filePath, String originName, String resultName) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onRenameFile(filePath, originName, resultName);
            }
            ArrayList arrayList = dirExistList;
            synchronized (arrayList) {
                dirExistList.remove(filePath + "/" + originName);
            }
            arrayList = fileExistAndNotEmptyList;
            synchronized (arrayList) {
                fileExistAndNotEmptyList.remove(filePath + "/" + originName);
            }
            PerfActionLog.add("File_onRenameFile:%s", filePath);
        }

        @Override
        public void onMd5ForFile(String filePath) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onMd5ForFile(filePath);
            }
            PerfActionLog.add("File_onMd5ForFile:%s", filePath);
        }

        @Override
        public void onUnZip(String filePath, String descDir) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onUnZip(filePath, descDir);
            }
            PerfActionLog.add("File_onUnZip:%s", filePath);
        }

        @Override
        public void onCreateDir(String path) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onCreateDir(path);
            }
            PerfActionLog.add("File_onCreateDir:%s", path);
        }

        @Override
        public void onOpenFile(String path) {
            if (mOnMonitorFileOperateCallback != null) {
                mOnMonitorFileOperateCallback.onOpenFile(path);
            }
            PerfActionLog.add("File_onOpenFile:%s", path);
        }
    };
    private static OnMonitorFileOperate mOnMonitorFileOperateCallback;
    private static IFileOperateOpt sOpt;
    private static final ArrayList<String> fileExistAndNotEmptyList;
    private static final ArrayList<String> dirExistList;
    private static final String BARCODE_FILE_EXT = ".png";
    private static final String YY_BARCODE_DIR = "YYBarcode";
    private static final String TAG = "YYFileUtils";
    private static final int MAX_FILENAME_LENGTH = 24;
    private static final Pattern NOT_ALPHANUMERIC;
    private static final int MAX_BUFF_SIZE = 0x100000;
    private static final int MIN_BUFF_SIZE = 4096;
    private static long space;
    private static long G;

    public static void setOnMonitorFileOperate(OnMonitorFileOperate onMonitorFileOperate) {
        mOnMonitorFileOperateCallback = onMonitorFileOperate;
    }

    public static void setFileOperateOpt(IFileOperateOpt opt) {
        sOpt = opt;
    }

    public static AssetFileDescriptor getAssetFileDescriptor(Context context, String path) {
        try {
            AssetManager assetManager = context.getAssets();
            return assetManager.openFd(path);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "getAssetFileDescriptor fail, try another way", ex, new Object[0]);
            try {
                File cacheFile = new File(context.getCacheDir(), path);
                File parentFile = cacheFile.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (!cacheFile.exists()) {
                    cacheFile.createNewFile();
                }
                MLog.debug(TAG, "getAssetFileDescriptor cacheFile length: " + cacheFile.length(), new Object[0]);
                if (cacheFile.length() <= 0L) {
                    try (InputStream inputStream = context.getAssets().open(path);
                         FileOutputStream outputStream = new FileOutputStream(cacheFile, false);){
                        YYFileUtils.copyStream(inputStream, outputStream);
                    }
                }
                return new AssetFileDescriptor(ParcelFileDescriptor.open((File)cacheFile, (int)0x10000000), 0L, -1L);
            }
            catch (Exception e2) {
                MLog.error((Object)TAG, "getAssetFileDescriptor error", e2, new Object[0]);
                return null;
            }
        }
    }

    public static boolean isValidAudioFile(String path) {
        String ext;
        if (!BlankUtil.isBlank(path) && !BlankUtil.isBlank(ext = YYFileUtils.getFileExtension(path))) {
            for (String extItem : AUDIO_EXTS) {
                if (!ext.equalsIgnoreCase(extItem)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTxtFileContent(Context context, String fileName) {
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        String path = fileName;
        String content = "";
        if (BlankUtil.isBlank(fileName)) {
            return content;
        }
        File file = new File(path);
        if (file.isFile()) {
            InputStream instream = null;
            try {
                instream = fileName.startsWith(FileStorageUtils.getInstance().getInternalFileRootDir()) ? context.openFileInput(YYFileUtils.getFileName(fileName)) : new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    StringBuffer contentBuffer = new StringBuffer();
                    while ((line = buffreader.readLine()) != null) {
                        contentBuffer.append(line).append("\n");
                    }
                    content = contentBuffer.toString();
                    buffreader.close();
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, "getTxtFileContent error! " + e, new Object[0]);
                if (mOnMonitorFileOperate != null) {
                    mOnMonitorFileOperate.onReadContentFromFile(path, 0);
                }
            }
            finally {
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Empty Catch on getTxtFileContent", (Throwable)e);
                    }
                }
            }
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onReadContentFromFile(path, content != null ? content.length() : 0);
        }
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        SwordHelper.onFileOperate(2, fileName, content.length(), SystemClock.elapsedRealtime() - optStartTime);
        return content;
    }

    @Nullable
    public static String getFileExtension(String filePath) {
        String fileName = YYFileUtils.getFileName(filePath);
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        if (filePath != null) {
            String slash = File.separator;
            int pos = filePath.lastIndexOf(slash) + 1;
            return filePath.substring(pos);
        }
        return null;
    }

    public static String dropExt(String fname) {
        int pos;
        if (!FP.empty(fname) && (pos = fname.lastIndexOf(".")) != -1) {
            return FP.take(pos, fname);
        }
        return fname;
    }

    private static boolean isFileExisted(File file) {
        if (file == null) {
            return false;
        }
        try {
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExisted(String filePath) {
        boolean useCache;
        if (BlankUtil.isBlank(filePath)) {
            return false;
        }
        boolean bl = useCache = sOpt != null && sOpt.judgeFileExistShouldUseCache(filePath);
        if (useCache) {
            ArrayList<String> arrayList = fileExistAndNotEmptyList;
            synchronized (arrayList) {
                if (fileExistAndNotEmptyList.contains(filePath)) {
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info(TAG, "judge file exist use cache:%s", filePath);
                    }
                    return true;
                }
            }
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onFileExist(filePath);
        }
        try {
            boolean result;
            File file = new File(filePath);
            boolean bl2 = result = YYFileUtils.isFileExisted(file) && file.length() > 0L;
            if (result && useCache) {
                ArrayList<String> arrayList = fileExistAndNotEmptyList;
                synchronized (arrayList) {
                    if (!fileExistAndNotEmptyList.contains(filePath)) {
                        fileExistAndNotEmptyList.add(filePath);
                    }
                }
            }
            if (!result) {
                ArrayList<String> arrayList = fileExistAndNotEmptyList;
                synchronized (arrayList) {
                    fileExistAndNotEmptyList.remove(filePath);
                }
            }
            return result;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = fileExistAndNotEmptyList;
            synchronized (arrayList) {
                fileExistAndNotEmptyList.remove(filePath);
            }
            return false;
        }
    }

    public static boolean isDirExisted(String filePath) {
        if (BlankUtil.isBlank(filePath)) {
            return false;
        }
        try {
            File file = new File(filePath);
            return YYFileUtils.isDirExisted(file);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDirExisted(File dir) {
        boolean useCache;
        if (dir == null) {
            return false;
        }
        String path = dir.getAbsolutePath();
        boolean bl = useCache = sOpt != null && sOpt.judgeDirectoryShouldUseCache(path);
        if (useCache) {
            ArrayList<String> arrayList = dirExistList;
            synchronized (arrayList) {
                if (dirExistList.contains(path)) {
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info(TAG, "judge dir exist use cache:%s", path);
                    }
                    return true;
                }
            }
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onFileExist(path);
        }
        try {
            boolean result;
            boolean bl2 = result = YYFileUtils.isFileExisted(dir) && YYFileUtils.isDirectory(dir);
            if (result && useCache) {
                ArrayList<String> arrayList = dirExistList;
                synchronized (arrayList) {
                    if (!dirExistList.contains(path)) {
                        dirExistList.add(path);
                    }
                }
            }
            if (!result) {
                ArrayList<String> arrayList = dirExistList;
                synchronized (arrayList) {
                    dirExistList.remove(path);
                }
            }
            return result;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = dirExistList;
            synchronized (arrayList) {
                dirExistList.remove(path);
            }
            return false;
        }
    }

    public static byte deleteFile(File item) {
        File[] filelist;
        if (item == null || !item.exists()) {
            return 7;
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onDeleteFile(item.getPath());
        }
        int ret = 0;
        int subret = 0;
        if (item.isDirectory() && (filelist = item.listFiles()) != null) {
            for (File subitem : filelist) {
                subret = subret == YYFileUtils.deleteFile(subitem) ? subret : 6;
            }
        }
        ret = item.delete() ? 0 : 7;
        return (byte)(ret == subret ? ret : 6);
    }

    public static void renameFile(String oldFile, String newFile) {
        try {
            File file = new File(oldFile);
            String filePath = file.getPath();
            String originName = file.getName();
            file.renameTo(new File(newFile));
            if (mOnMonitorFileOperate != null) {
                mOnMonitorFileOperate.onRenameFile(filePath, originName, file.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeFiles(List<Pair<Integer, String>> fileNames) {
        for (Pair<Integer, String> p : fileNames) {
            if (p.second == null) continue;
            YYFileUtils.removeFile((String)p.second);
        }
    }

    public static void removeFile(String filename) {
        if (!BlankUtil.isBlank(filename)) {
            try {
                File file = new File(filename);
                if (mOnMonitorFileOperate != null) {
                    mOnMonitorFileOperate.onDeleteFile(file.getPath());
                }
                file.delete();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on removeFile", (Throwable)e);
            }
        }
    }

    public static void removeFile(File file) {
        if (file == null) {
            return;
        }
        try {
            if (mOnMonitorFileOperate != null) {
                mOnMonitorFileOperate.onDeleteFile(file.getPath());
            }
            file.delete();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Empty Catch on removeFile", (Throwable)e);
        }
    }

    public static void removeDir(String dirPath) {
        File dir = new File(dirPath);
        YYFileUtils.removeDir(dir);
    }

    public static void removeDir(File dir) {
        File[] fileList;
        if (dir == null) {
            return;
        }
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                if (mOnMonitorFileOperate != null) {
                    mOnMonitorFileOperate.onDeleteFile(file.getPath());
                }
                file.delete();
            }
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onDeleteFile(dir.getPath());
        }
        dir.delete();
    }

    public static void removeFilesInDir(String dirPath) {
        File dir = new File(dirPath);
        YYFileUtils.removeFilesInDir(dir);
    }

    public static void removeFilesInDir(File dir) {
        File[] fileList;
        if (dir == null) {
            return;
        }
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                if (mOnMonitorFileOperate != null) {
                    mOnMonitorFileOperate.onDeleteFile(file.getPath());
                }
                file.delete();
            }
        }
    }

    private static boolean isDirectory(File file) {
        if (file == null) {
            return false;
        }
        try {
            return file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void removeDirFiles(String dirPath, String ... excludePath) {
        File[] fileList;
        File dir = new File(dirPath);
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                String path = file.getAbsolutePath();
                boolean isExclude = false;
                for (String p : excludePath) {
                    if (p.endsWith(File.separator)) {
                        p = p.substring(0, p.length() - 1);
                    }
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, p.length() - 1);
                    }
                    if (!path.equals(p)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) continue;
                if (mOnMonitorFileOperate != null) {
                    mOnMonitorFileOperate.onDeleteFile(file.getPath());
                }
                YYFileUtils.delete(file);
            }
        }
    }

    public static void rm(String fname) {
        YYFileUtils.rm(new File(fname));
    }

    public static void rm(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File i : FP.ref(f.listFiles())) {
                    YYFileUtils.rm(i);
                }
            } else {
                if (mOnMonitorFileOperate != null && f != null) {
                    mOnMonitorFileOperate.onDeleteFile(f.getPath());
                }
                f.delete();
            }
        }
    }

    public static File getFileFromURL(String base, String url) {
        if (BlankUtil.isBlank(url)) {
            return null;
        }
        int idx = url.lastIndexOf(File.separatorChar);
        return new File(base, url.substring(idx + 1));
    }

    public static String getFilePathFromUri(Context context, Uri uri) {
        String path = YYFileUtils.getPath(context, uri);
        return StringUtils.isEmpty(path) ? ImageUriComp.getPath(context, uri) : path;
    }

    private static String getPath(Context context, Uri uri) {
        File file;
        if (uri == null) {
            return null;
        }
        String pathName = uri.getPath();
        if (!StringUtils.isEmpty(pathName) && (file = new File(pathName)).isFile()) {
            return file.getPath();
        }
        if ("file".equals(uri.getScheme())) {
            String ret = uri.toString().substring(7);
            ret = YYFileUtils.decodeUri(ret);
            return ret;
        }
        if ("content".equals(uri.getScheme())) {
            return null;
        }
        return null;
    }

    public static String decodeUri(String uri) {
        if (BlankUtil.isBlank(uri)) {
            return uri;
        }
        int index = uri.indexOf(37);
        if (index != -1) {
            uri = Uri.decode((String)uri);
        }
        return uri;
    }

    public static boolean checkFileValidation(String filepath, String md5) throws IOException {
        String fileMd5 = MD5Utils.getFileMd5String(filepath);
        if (fileMd5 == null) {
            return false;
        }
        return fileMd5.equals(md5);
    }

    public static File getTempFile(Context context, String uniqueName) {
        String tempPath = YYFileUtils.getYYTempDir();
        File tmpFile = new File(tempPath);
        if (!tmpFile.exists()) {
            tmpFile.mkdirs();
            File nomediafile = new File(tmpFile.getAbsolutePath() + "/.nomedia");
            try {
                nomediafile.createNewFile();
            }
            catch (IOException e) {
                MLog.error((Object)"saved", "Empty Catch on createDir", e, new Object[0]);
            }
        }
        return new File(tmpFile.getAbsolutePath() + File.separator + uniqueName);
    }

    @Deprecated
    public static void saveBitmapToPNG(Bitmap bitmap, String filePath) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, Bitmap.CompressFormat.PNG);
    }

    @Deprecated
    public static void saveBitmapToJPG(Bitmap bitmap, String filePath) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, Bitmap.CompressFormat.JPEG);
    }

    public static void saveBitmapToJPGComplete(Bitmap bitmap, String filePath) throws Exception {
        if (bitmap == null) {
            return;
        }
        File barcodeFile = new File(filePath + "_tmp");
        if (!barcodeFile.exists()) {
            barcodeFile.createNewFile();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(barcodeFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            barcodeFile.renameTo(new File(filePath));
        }
        catch (Exception fnfe) {
            MLog.error((Object)TAG, "Couldn't access file %s due to %s", barcodeFile, fnfe);
            throw fnfe;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Deprecated
    public static void saveBitmap(Bitmap bitmap, String filePath, Bitmap.CompressFormat format) throws Exception {
        YYFileUtils.saveBitmap(bitmap, filePath, format, 100);
    }

    @Deprecated
    public static void saveBitmap(Bitmap bitmap, String filePath, Bitmap.CompressFormat format, int quality) throws Exception {
        File barcodeFile;
        if (bitmap == null) {
            return;
        }
        if (format == null) {
            format = Bitmap.CompressFormat.PNG;
        }
        if (!(barcodeFile = new File(filePath)).exists()) {
            barcodeFile.createNewFile();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(barcodeFile);
            bitmap.compress(format, quality, (OutputStream)fos);
        }
        catch (Exception fnfe) {
            MLog.error((Object)TAG, "Couldn't access file %s due to %s", barcodeFile, fnfe);
            throw fnfe;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String dropPrefix(String s, String prefix) {
        return s.startsWith(prefix) ? FP.drop(FP.length(prefix), s) : s;
    }

    public static String concatPath(String p1, String p2) {
        return p1.endsWith(File.separator) ? p1 + YYFileUtils.dropPrefix(p2, File.separator) : p1 + File.separator + YYFileUtils.dropPrefix(p2, File.separator);
    }

    public static String concatPaths(String ... ss) {
        String path = "";
        for (String s : ss) {
            path = YYFileUtils.concatPath(path, s);
        }
        return path;
    }

    public static String getYYActRecommFilename(Context context) {
        File file = context.getFileStreamPath(ACT_RECOMMAND_FILE);
        return file.getPath();
    }

    public static YYFileUtils createFile(String path) throws Exception {
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onNewFile(path);
        }
        String dir = YYFileUtils.getDirOfFilePath(path);
        String name = YYFileUtils.getFileName(path);
        File f = BasicFileUtils.createFileOnSD(dir, name);
        return new YYFileUtils(f, null);
    }

    public static void createDir(String dirPath) {
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onNewFile(dirPath);
        }
        BasicFileUtils.createDir(dirPath, true);
    }

    private YYFileUtils(File file, FileOutputStream fileos) throws Exception {
        this(file, fileos, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YYFileUtils(File file, FileOutputStream fileos, boolean isCloseStream) throws Exception {
        block10: {
            this.mFileOutputStream = null;
            this.mBufferedOutputStream = null;
            try {
                this.mFile = file;
                this.mFileOutputStream = fileos;
                if (this.mFile != null) {
                    if (this.mFileOutputStream == null) {
                        this.mFileOutputStream = new FileOutputStream(this.mFile);
                    }
                    this.mBufferedOutputStream = new BufferedOutputStream(this.mFileOutputStream);
                    break block10;
                }
                throw new Exception("YYFileOutput, can not create file output stream");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (isCloseStream) {
                    if (this.mBufferedOutputStream != null) {
                        this.mBufferedOutputStream.close();
                    }
                    if (this.mFileOutputStream != null) {
                        this.mFileOutputStream.close();
                    }
                }
            }
        }
    }

    public static YYFileUtils openFile(String filePath) throws Exception {
        return YYFileUtils.openFile(filePath, true);
    }

    public static YYFileUtils openFile(String filePath, boolean isCloseStream) throws Exception {
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onOpenFile(filePath);
        }
        String dirPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
        BasicFileUtils.createDir(dirPath, true);
        File file = new File(filePath);
        if (!file.exists() && !file.createNewFile()) {
            file = null;
        }
        return new YYFileUtils(file, null, isCloseStream);
    }

    public static boolean ensureFileDirExists(String filePath) {
        String dir = YYFileUtils.getDirOfFilePath(filePath);
        if (BlankUtil.isBlank(dir)) {
            return false;
        }
        BasicFileUtils.ensureDirExists(dir);
        return true;
    }

    public static String getDirOfFilePath(String filePath) {
        if (BlankUtil.isBlank(filePath)) {
            return null;
        }
        int sepPos = filePath.lastIndexOf(File.separatorChar);
        if (sepPos == -1) {
            return null;
        }
        return filePath.substring(0, sepPos);
    }

    public boolean write(Bitmap bitmap) {
        return this.write(bitmap, 80);
    }

    public boolean write(Bitmap bitmap, int compressRate) {
        return bitmap.compress(Bitmap.CompressFormat.JPEG, compressRate, (OutputStream)this.mBufferedOutputStream);
    }

    public void writeYCbCr420SP(byte[] data, int width, int height) {
        YuvImage image = new YuvImage(data, 17, width, height, null);
        image.compressToJpeg(new Rect(0, 0, width, height - 1), 100, (OutputStream)this.mBufferedOutputStream);
    }

    public int write(InputStream is) {
        int bytesSum = 0;
        int bytes = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((bytes = is.read(buffer)) != -1) {
                this.mBufferedOutputStream.write(buffer, 0, bytes);
                bytesSum += bytes;
            }
            if (mOnMonitorFileOperate != null && is != null) {
                mOnMonitorFileOperate.onWriteContentToFile("InputStream", bytesSum);
            }
        }
        catch (IOException e) {
            MLog.error(this, e);
        }
        return bytesSum;
    }

    public void write(String fileName) {
        try {
            long optStartTime = 0L;
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            optStartTime = SystemClock.elapsedRealtime();
            FileInputStream fis = new FileInputStream(fileName);
            int size = this.write(fis);
            fis.close();
            if (mOnMonitorFileOperate != null) {
                mOnMonitorFileOperate.onWriteContentToFile(fileName, size);
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(2, fileName, size, SystemClock.elapsedRealtime() - optStartTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(byte[] buffer) {
        try {
            this.mBufferedOutputStream.write(buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(byte[] buffer, int offset, int length) {
        try {
            this.mBufferedOutputStream.write(buffer, offset, length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.mBufferedOutputStream != null) {
                this.mBufferedOutputStream.flush();
                this.mBufferedOutputStream.close();
            }
            if (this.mFileOutputStream != null) {
                this.mFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.mFile;
    }

    public static long getFileLength(String file) {
        File tmp = new File(file);
        return tmp.length();
    }

    public static String fallbackFile(String file) {
        String ext = BasicFileUtils.getFileExt(file);
        int i = file.lastIndexOf(".");
        return i == -1 ? "" : file.substring(0, i + 1) + "bak" + ext;
    }

    public static boolean isValidRecordFile(String filePath) {
        if (!YYFileUtils.isFileExisted(filePath)) {
            return false;
        }
        String ext = YYFileUtils.getFileExtension(filePath);
        if (ext == null) {
            return false;
        }
        boolean aac = false;
        aac = ext.equalsIgnoreCase(RECORD_EXT_HIGH_CPU);
        if (!aac && !ext.equalsIgnoreCase(RECORD_EXT_LOW_CPU)) {
            return false;
        }
        long len = YYFileUtils.getFileLength(filePath);
        long minLen = aac ? 8192L : 131072L;
        boolean ret = len >= minLen;
        return ret;
    }

    public static long getSubFileNum(File file) throws Exception {
        long size = 0L;
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += YYFileUtils.getSubFileNum(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        return size;
    }

    public static String getHumanReadableFileSize(long bytes) {
        if (bytes < 1024L) {
            return YYFileUtils.getFileSizeInBytes(bytes);
        }
        return bytes >> 20 == 0L ? YYFileUtils.getFileSizeInKBytes(bytes) : YYFileUtils.getFileSizeInMBytes(bytes);
    }

    public static String getFileSizeInBytes(long bytes) {
        return StringUtils.formatWitUSLocal("%dB", bytes);
    }

    public static String getFileSizeInKBytes(long bytes) {
        long kbs = bytes >> 10;
        return StringUtils.formatWitUSLocal("%dK", kbs);
    }

    public static String getFileSizeInMBytes(long bytes) {
        float kbs = (float)bytes / 1024.0f;
        float mbs = kbs / 1024.0f;
        DecimalFormat df = new DecimalFormat("0.00M");
        String ret = df.format(mbs);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveBitmapToPublicDir(Bitmap bitmap, String fileName) {
        if (bitmap == null) {
            return;
        }
        File barcodesRoot = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), YY_BARCODE_DIR);
        if (!barcodesRoot.exists() && !barcodesRoot.mkdirs()) {
            return;
        }
        File barcodeFile = new File(barcodesRoot, YYFileUtils.makeFileName(fileName) + BARCODE_FILE_EXT);
        barcodeFile.delete();
        FileOutputStream fos = null;
        fos = new FileOutputStream(barcodeFile);
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fos);
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        catch (FileNotFoundException fnfe) {
            if (fos == null) return;
            try {
                fos.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String makeFileName(CharSequence contents) {
        String fileName = NOT_ALPHANUMERIC.matcher(contents).replaceAll("_");
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 24);
        }
        return fileName;
    }

    public static byte[] fileToByteArray(File file) {
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            return YYFileUtils.streamToBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream inputStream) {
        byte[] content = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = bis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            content = baos.toByteArray();
            if (content.length == 0) {
                content = null;
            }
            baos.close();
            bis.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }

    public static void copyFile(File src, File des) throws IOException {
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (src == null || des == null) {
            return;
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onCopyFile(src.getPath(), des.getPath());
        }
        if (des.exists()) {
            des.delete();
        }
        des.createNewFile();
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(des);
        YYFileUtils.copyStream(in, out);
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        SwordHelper.onFileOperate(1, src.getPath(), src.length(), SystemClock.elapsedRealtime() - optStartTime);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int length = in.available();
        if (length == 0) {
            length = 4096;
        } else if (length >= 0x100000) {
            length = 0x100000;
        }
        byte[] buffer = new byte[length];
        while (true) {
            int ins;
            if ((ins = in.read(buffer)) == -1) {
                in.close();
                out.flush();
                out.close();
                return;
            }
            out.write(buffer, 0, ins);
        }
    }

    public static boolean copyFile(String inFileName, String outFileName) {
        try {
            if (SdkVersionUtils.hasScopedStorage() && YYFileUtils.isContentUri(inFileName)) {
                YYFileUtils.copyFileFromUri(Uri.parse((String)inFileName), outFileName);
            } else {
                YYFileUtils.copyFile(new File(inFileName), new File(outFileName));
            }
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "lcy copy file failed: %s", e, new Object[0]);
            return false;
        }
    }

    public static boolean copyFileFromUri(Uri uri, String outFileName) {
        try {
            InputStream inputStream = RuntimeContext.sApplicationContext.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                FileOutputStream out = new FileOutputStream(new File(outFileName));
                YYFileUtils.copyStream(inputStream, out);
            }
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "lcy copy file failed: %s", e, new Object[0]);
            return false;
        }
    }

    public static String getImagePathFromURL(String basePath, String url) {
        if (BlankUtil.isBlank(url)) {
            return null;
        }
        int idx = url.lastIndexOf(File.separatorChar);
        String path = url.substring(idx + 1);
        return basePath + File.separator + path;
    }

    public static void deleteOldFiles(String dirPath, final String postfix, long downloadTime) {
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.toLowerCase().indexOf(postfix) != -1;
                }
            };
            ArrayList portraitList = new ArrayList();
            File[] fileList = dir.listFiles(filter);
            if (fileList != null && fileList.length > 0) {
                long current = System.currentTimeMillis();
                for (File file : fileList) {
                    if (portraitList.contains(file.getPath()) || current - file.lastModified() <= downloadTime) continue;
                    if (mOnMonitorFileOperate != null && file != null) {
                        mOnMonitorFileOperate.onDeleteFile(file.getPath());
                    }
                    file.delete();
                }
            }
        }
    }

    public static void deleteFiles(String dirPath, String suffixExtension) {
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            FilenameFilter filter = (dir1, filename) -> ("" + MimeTypeMap.getFileExtensionFromUrl((String)filename)).equalsIgnoreCase(suffixExtension);
            ArrayList portraitList = new ArrayList();
            File[] fileList = dir.listFiles(filter);
            if (fileList != null && fileList.length > 0) {
                for (File file : fileList) {
                    if (portraitList.contains(file.getPath())) continue;
                    if (mOnMonitorFileOperate != null) {
                        mOnMonitorFileOperate.onDeleteFile(file.getPath());
                    }
                    file.delete();
                }
            }
        }
    }

    public static boolean isSameFile(String path1, String path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        return new File(path1).equals(new File(path2));
    }

    @Deprecated
    public static String getRootDir() {
        return FileStorageUtils.getInstance().getDir(false, "tmp").getAbsolutePath();
    }

    @Deprecated
    public static String getYYTempDir() {
        return YYFileUtils.getRootDir() + File.separator + TEMP_DIR;
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getBytes error!" + e, new Object[0]);
        }
        return buffer;
    }

    public static String getSavedFileDir() {
        File dir = FileStorageUtils.getInstance().getDir(false, "saved");
        if (dir != null) {
            if (!dir.exists()) {
                dir.mkdirs();
                File nomediafile = new File(dir.getAbsolutePath() + "/.nomedia");
                try {
                    nomediafile.createNewFile();
                }
                catch (IOException e) {
                    MLog.error((Object)"saved", "Empty Catch on createDir", e, new Object[0]);
                }
            }
            return dir.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "saveFile error!", e, new Object[0]);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "saveFile error!", e, new Object[0]);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "saveFile error!" + e, new Object[0]);
                }
            }
        }
    }

    public static boolean saveToFile(String str, String path) {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        try {
            FileOutputStream os = new FileOutputStream(YYFileUtils.createNewFile(path, false));
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            stream.close();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "saveToPath error!" + e, new Object[0]);
            return false;
        }
        return true;
    }

    public static void saveJsonData(String jsonString, String fileName) {
        try {
            File file = YYFileUtils.createNewFile(fileName, false);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(jsonString);
            fileWriter.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
        }
    }

    public static String readJsonData(String fileName) {
        try {
            long optStartTime = 0L;
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            optStartTime = SystemClock.elapsedRealtime();
            FileInputStream is = new FileInputStream(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            String str = new String(buffer);
            if (mOnMonitorFileOperate != null) {
                mOnMonitorFileOperate.onReadContentFromFile(fileName, str.length());
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(2, fileName, str.length(), SystemClock.elapsedRealtime() - optStartTime);
            return str;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
            return null;
        }
    }

    public static List<File> getSuffixFile(String filePath, String suffere) {
        ArrayList<File> files = new ArrayList<File>();
        return YYFileUtils.getSuffixFile(files, filePath, suffere);
    }

    public static List<File> getSuffixFile(List<File> files, String filePath, String suffere) {
        File[] subFiles;
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        for (File subFile : subFiles = f.listFiles()) {
            if (subFile.isFile() && subFile.getName().endsWith(suffere)) {
                files.add(subFile);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            YYFileUtils.getSuffixFile(files, subFile.getAbsolutePath(), suffere);
        }
        return files;
    }

    public static File getConfigDir() {
        return FileStorageUtils.getInstance().getInternalFileDir("config");
    }

    public static File getConfigDir(String type) {
        File config = YYFileUtils.getConfigDir();
        if (TextUtils.isEmpty((CharSequence)type)) {
            return config;
        }
        File file = new File(config, type);
        if (!file.exists() && !file.mkdirs()) {
            MLog.warn(TAG, "getConfigDir", new Object[0]);
            return config;
        }
        return file;
    }

    public static void copyDirectoryContents(File directory, String targetDirName, boolean update) throws IOException {
        if (targetDirName == null || targetDirName.length() == 0) {
            return;
        }
        YYFileUtils.copyDirectoryContents(directory, new File(targetDirName), update);
    }

    public static void copyDirectoryContents(File directory, File targetDir, boolean update) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Cannot copy contents of the file [" + directory.getAbsolutePath() + "]: specify a directory instead.");
        }
        String[] fileNames = directory.list();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            File file = new File(directory.getAbsolutePath(), fileName);
            if (file.isDirectory()) {
                YYFileUtils.copyDirectoryContents(file, targetDir.getAbsolutePath() + File.separatorChar + fileName, update);
                continue;
            }
            File targetFile = new File(targetDir, fileName);
            if (update) {
                if (targetFile.exists() && file.lastModified() <= targetFile.lastModified()) continue;
                YYFileUtils.copy(file, targetFile);
                continue;
            }
            YYFileUtils.copy(file, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            int read;
            byte[] buffer = new byte[4096];
            inputStream = new FileInputStream(file);
            outputStream = new ByteArrayOutputStream();
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            byte[] byteArray = null;
            byte[] byArray = byteArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void writeBytesToFile(File file, byte[] data, boolean append) throws IOException {
        YYFileUtils.writeBytesToFile(file, data, append, false);
    }

    public static boolean writeBytesToFileForCrashWays(File file, byte[] data, boolean append, boolean forceFlush) throws IOException {
        return YYFileUtils.writeBytes(file, data, append, forceFlush, false);
    }

    public static boolean writeBytesToFile(File file, byte[] data, boolean append, boolean forceFlush) throws IOException {
        return YYFileUtils.writeBytes(file, data, append, forceFlush, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeBytes(File file, byte[] data, boolean append, boolean forceFlush, boolean needMonitor) throws IOException {
        boolean bl;
        if (data == null || file == null) {
            return false;
        }
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null && needMonitor) {
            mOnMonitorFileOperate.onWriteContentToFile(file.getPath(), data != null ? data.length : 0);
        }
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                Log.e((String)"FileUtil", (String)"Empty Catch on createNewFile", (Throwable)e);
            }
        }
        FileOutputStream fileOutput = null;
        try {
            FileDescriptor fd;
            fileOutput = new FileOutputStream(file, append);
            fileOutput.write(data, 0, data.length);
            fileOutput.flush();
            if (forceFlush && (fd = fileOutput.getFD()) != null) {
                fd.sync();
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(3, file.getPath(), data != null ? (long)data.length : 0L, SystemClock.elapsedRealtime() - optStartTime);
            bl = true;
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(fileOutput);
            throw throwable;
        }
        IOUtils.safeClose(fileOutput);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeBytes(File file, byte[] headData, byte[] bodyData, int bodyOffset, int bodyLen, boolean forceFlush) {
        boolean fd2332;
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null && file != null) {
            mOnMonitorFileOperate.onWriteContentToFile(file.getPath(), bodyData != null ? bodyData.length : 0);
        }
        FileOutputStream fileOutput = null;
        try {
            FileDescriptor fd2332;
            fileOutput = new FileOutputStream(file);
            if (headData != null) {
                fileOutput.write(headData);
            }
            fileOutput.write(bodyData, bodyOffset, bodyLen);
            fileOutput.flush();
            if (forceFlush && (fd2332 = fileOutput.getFD()) != null) {
                fd2332.sync();
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(3, file.getPath(), bodyData != null ? (long)bodyData.length : 0L, SystemClock.elapsedRealtime() - optStartTime);
            fd2332 = true;
        }
        catch (Exception e) {
            block9: {
                try {
                    if (MLog.isLogLevelAboveDebug()) break block9;
                    MLog.debug(TAG, "Some errors", e);
                }
                catch (Throwable throwable) {
                    IOUtils.safeClose(fileOutput);
                    fileOutput = null;
                    throw throwable;
                }
            }
            IOUtils.safeClose(fileOutput);
            return false;
        }
        IOUtils.safeClose(fileOutput);
        return fd2332;
    }

    public static File createNewFile(String path, boolean append) {
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onNewFile(path);
        }
        File newFile = new File(path);
        if (!append && newFile.exists()) {
            newFile.delete();
        }
        if (!newFile.exists()) {
            try {
                File parent = newFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                newFile.createNewFile();
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
        }
        return newFile;
    }

    public static long getFolderSize(File file) {
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            if (FP.empty(fileList)) {
                return 0L;
            }
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += YYFileUtils.getFolderSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return size;
    }

    public static boolean isPathExist(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static long getSDCardTotalSize() {
        try {
            StatFs sf = new StatFs(FileStorageUtils.getInstance().getExternalFileRootDir());
            long blockSize = Build.VERSION.SDK_INT >= 18 ? sf.getBlockSizeLong() : (long)sf.getBlockSize();
            long totalBlocks = Build.VERSION.SDK_INT >= 18 ? sf.getBlockCountLong() : (long)sf.getBlockCount();
            return totalBlocks * blockSize;
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    public static long getSDCardAvailableSize() {
        if (space > G) {
            MLog.debug(TAG, "getSDCardAvailableSize greater than 1G return %d", space);
            return space;
        }
        try {
            StatFs stat = new StatFs(FileStorageUtils.getInstance().getExternalCacheRootDir());
            space = stat.getBlockSizeLong() * stat.getAvailableBlocksLong();
            MLog.debug(TAG, "getSDCardAvailableSize %d", space);
            return space;
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return -1L;
        }
    }

    public static long getSystemTotalSize() {
        long blockSize = 0L;
        long totalBlocks = 0L;
        try {
            StatFs sf = new StatFs(FileStorageUtils.getInstance().getExternalFileRootDir());
            blockSize = Build.VERSION.SDK_INT >= 18 ? sf.getBlockSizeLong() : (long)sf.getBlockSize();
            totalBlocks = Build.VERSION.SDK_INT >= 18 ? sf.getBlockCountLong() : (long)sf.getBlockCount();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getSystemTotalSize", e, new Object[0]);
        }
        return blockSize * totalBlocks;
    }

    public static long getSystemAvailable() {
        long ailSize = 0L;
        try {
            StatFs sf = new StatFs(FileStorageUtils.getInstance().getExternalFileRootDir());
            long blockSize = Build.VERSION.SDK_INT >= 18 ? sf.getBlockSizeLong() : (long)sf.getBlockSize();
            long availableBlocks = Build.VERSION.SDK_INT >= 18 ? sf.getAvailableBlocksLong() : (long)sf.getAvailableBlocks();
            return availableBlocks * blockSize;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "get available internal storge size failed", new Object[0]);
            return ailSize;
        }
    }

    public static boolean writeBytes(File file, byte[] data, int offset, int len) {
        return YYFileUtils.writeBytes(file, null, data, offset, len, false);
    }

    public static List<File> listFiles(File dir, FileFilter filter, boolean recursive) {
        ArrayList<File> result = new ArrayList<File>();
        if (!dir.exists() || dir.isFile()) {
            return result;
        }
        File[] fArray = dir.listFiles(filter);
        if (fArray == null) {
            return result;
        }
        List<File> fList = Arrays.asList(fArray);
        if (!recursive) {
            return fList;
        }
        LinkedList<File> linkedList = new LinkedList<File>(fList);
        while (!linkedList.isEmpty()) {
            File[] array;
            File f = linkedList.removeFirst();
            result.add(f);
            if (!f.isDirectory() || (array = f.listFiles(filter)) == null) continue;
            for (int i = 0; i < array.length; ++i) {
                linkedList.addLast(array[i]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file) {
        String[] children;
        if (file.isDirectory() && (children = file.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = YYFileUtils.delete(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        String path = file.getAbsolutePath();
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onDeleteFile(path);
        }
        ArrayList<String> arrayList = dirExistList;
        synchronized (arrayList) {
            dirExistList.remove(path);
        }
        arrayList = fileExistAndNotEmptyList;
        synchronized (arrayList) {
            fileExistAndNotEmptyList.remove(path);
        }
        return file.delete();
    }

    public static String getFileMD5String(File file, long millisecondTimeout) throws IOException {
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onMd5ForFile(file.getPath());
        }
        long startTime = System.currentTimeMillis();
        MessageDigest messagedigest = null;
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            MLog.processSilentException(nsaex);
            return "";
        }
        BufferedInputStream bis = null;
        bis = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[16384];
        int numRead = 0;
        while ((numRead = bis.read(buffer)) > 0) {
            long currentTime = System.currentTimeMillis();
            if (millisecondTimeout > 0L && currentTime - startTime > millisecondTimeout) {
                bis.close();
                messagedigest.reset();
                return "";
            }
            messagedigest.update(buffer, 0, numRead);
        }
        bis.close();
        byte[] s = messagedigest.digest();
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        SwordHelper.onFileOperate(4, file.getPath(), file.length(), SystemClock.elapsedRealtime() - optStartTime);
        return DigestUtils.bufferToHex(s);
    }

    public static boolean checkFileMd5(File file, String md5, long millisecondTimeout) {
        if (file == null || !file.exists() || !file.isFile() || StringUtils.isEmpty(md5)) {
            return false;
        }
        String fileMd5 = "";
        try {
            fileMd5 = YYFileUtils.getFileMD5String(file, millisecondTimeout);
            if (StringUtils.isEmpty(fileMd5)) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return md5.trim().toLowerCase(Locale.ENGLISH).equals(fileMd5.trim().toLowerCase(Locale.ENGLISH));
    }

    public static boolean unZip(String zipFilePath, String descDir) {
        return YYFileUtils.unZip(zipFilePath, descDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZip(String zipFilePath, String descDir, boolean deleteZip) {
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onUnZip(zipFilePath, descDir);
        }
        File zipFile = new File(zipFilePath);
        ZipFile zip = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File descFile = new File(descDir);
            if (descFile.exists()) {
                YYFileUtils.delete(descFile);
            }
            descFile.mkdirs();
            String tmpPath = "-tmp" + mUnzipTmpIndex.addAndGet(1);
            String descDirTmp = descFile.getAbsolutePath() + tmpPath;
            File pathFile = new File(descDirTmp);
            if (pathFile.exists()) {
                YYFileUtils.delete(pathFile);
            }
            pathFile.mkdirs();
            MLog.info(TAG, "unZip zipPath: %s, descDirTmp: %s, descDir: %s", zipFilePath, descDirTmp, descDir);
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                bis = new BufferedInputStream(zip.getInputStream(entry));
                String outPath = (descDirTmp + "/" + zipEntryName).replaceAll("\\*", "/");
                File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(outPath);
                bos = new BufferedOutputStream(out);
                byte[] buf1 = new byte[8192];
                while ((len = bis.read(buf1)) > 0) {
                    ((BufferedOutputStream)bos).write(buf1, 0, len);
                }
                bis.close();
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
            boolean result = pathFile.renameTo(descFile);
            if (!result) {
                MLog.error((Object)TAG, "unZip rename failed pathFile: %s, descFile: %s", pathFile.getAbsolutePath(), descFile.getAbsolutePath());
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(5, zipFilePath, zipFile.length(), SystemClock.elapsedRealtime() - optStartTime);
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e1) {
                    MLog.error((Object)TAG, "unZip zipFilePath: " + zipFilePath, e, new Object[0]);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    MLog.error((Object)TAG, "unZip zipFilePath: " + zipFilePath, e, new Object[0]);
                }
            }
            MLog.error((Object)TAG, "unZip zipFilePath: " + zipFilePath, e, new Object[0]);
        }
        finally {
            if (null != zip) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (deleteZip && zipFile != null) {
                zipFile.delete();
            }
        }
        return false;
    }

    public static File[] unZip(String zip, String dest, String passwd) throws IOException {
        File zipFile = new File(zip);
        return YYFileUtils.unzip(zipFile, dest, passwd);
    }

    public static File[] unzip(File zipFile, String dest, String passwd) throws IOException {
        ZipEntry zipEntry;
        File destDir;
        if (FP.empty(dest)) {
            throw new IOException();
        }
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null && zipFile != null) {
            mOnMonitorFileOperate.onUnZip(zipFile.getPath(), dest);
        }
        if (!dest.endsWith(File.separator)) {
            dest = dest + File.separator;
        }
        if (!(destDir = new File(dest)).isDirectory() || !destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFile.getPath()));
        String szName = "";
        ArrayList<File> extractedFileList = new ArrayList<File>();
        File parent = null;
        File file = null;
        while ((zipEntry = inZip.getNextEntry()) != null) {
            int len;
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(destDir + File.separator + szName);
                folder.mkdirs();
                continue;
            }
            file = new File(destDir + File.separator + szName);
            parent = file.getParentFile();
            if (!parent.exists() || !parent.isDirectory()) {
                parent.mkdirs();
            }
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = inZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                out.flush();
            }
            out.close();
            extractedFileList.add(file);
        }
        inZip.close();
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        SwordHelper.onFileOperate(5, zipFile.getPath(), zipFile.length(), SystemClock.elapsedRealtime() - optStartTime);
        return extractedFiles;
    }

    public static byte[] readBytes(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return null;
        }
        return YYFileUtils.readBytes(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) {
        block10: {
            long optStartTime = 0L;
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            optStartTime = SystemClock.elapsedRealtime();
            FileInputStream fileInput = null;
            try {
                if (file.exists()) {
                    fileInput = new FileInputStream(file);
                    byte[] result = IOUtils.readFullBytes(fileInput);
                    if (mOnMonitorFileOperate != null && file != null) {
                        mOnMonitorFileOperate.onReadContentFromFile(file.getPath(), result != null ? result.length : 0);
                    }
                    if (!RuntimeContext.sIsDebuggable) {
                        // empty if block
                    }
                    SwordHelper.onFileOperate(2, file.getPath(), result != null ? (long)result.length : 0L, SystemClock.elapsedRealtime() - optStartTime);
                    byte[] byArray = result;
                    IOUtils.safeClose(fileInput);
                    fileInput = null;
                    return byArray;
                }
                IOUtils.safeClose(fileInput);
            }
            catch (Exception e) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "Some errors", e);
                }
                break block10;
            }
            finally {
                IOUtils.safeClose(fileInput);
                fileInput = null;
            }
            fileInput = null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static byte[] readFromAssets(String path) {
        byte[] byArray;
        InputStream is = null;
        try {
            is = RuntimeContext.sApplicationContext.getAssets().open(path);
            byArray = IOUtils.readFullBytes(is);
        }
        catch (Exception e) {
            try {
                MLog.error(TAG, e);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(is);
                throw throwable;
            }
            IOUtils.safeClose(is);
            return null;
        }
        IOUtils.safeClose(is);
        return byArray;
    }

    public static void copy(File source, File target) throws FileNotFoundException, IOException {
        YYFileUtils.copy(source, target, new byte[65536]);
    }

    private static void copy(File source, File target, byte[] buffer) throws FileNotFoundException, IOException {
        long optStartTime = 0L;
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        optStartTime = SystemClock.elapsedRealtime();
        if (mOnMonitorFileOperate != null && source != null && target != null) {
            mOnMonitorFileOperate.onCopyFile(source.getPath(), target.getPath());
        }
        FileInputStream in = new FileInputStream(source);
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (target.isDirectory()) {
            target = new File(target, source.getName());
        }
        FileOutputStream out = new FileOutputStream(target);
        try {
            int read;
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            if (!RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            SwordHelper.onFileOperate(1, source.getPath(), source.length(), SystemClock.elapsedRealtime() - optStartTime);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static long getFileSize(File file) {
        long size = 0L;
        try {
            if (file.isDirectory()) {
                return YYFileUtils.getFolderSize(file);
            }
            return file.length();
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return size;
        }
    }

    public static byte makeDirs(String path) {
        File file;
        if (StringUtils.isEmpty(path)) {
            return 1;
        }
        if (mOnMonitorFileOperate != null) {
            mOnMonitorFileOperate.onCreateDir(path);
        }
        if ((file = new File(path)).exists()) {
            return 2;
        }
        if (file.mkdirs()) {
            return 0;
        }
        return 5;
    }

    public static long getAvailableInternalStorgeSize() {
        long ailSize = -1L;
        try {
            ailSize = YYFileUtils.getSystemAvailable() / 1024L;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "get available internal storge size failed", new Object[0]);
        }
        return ailSize;
    }

    public static String getSystemAlbumDir() {
        String sdcardPath = Environment.getExternalStorageDirectory().getPath() + File.separator;
        String brand = Build.BRAND;
        if (TextUtils.isEmpty((CharSequence)brand)) {
            return sdcardPath + "DCIM" + File.separator + "Camera";
        }
        if ((brand = brand.toLowerCase()).contains("vivo")) {
            return sdcardPath + "\u76f8\u673a";
        }
        if (brand.contains("meizu")) {
            return sdcardPath + "DCIM" + File.separator + "Video";
        }
        return sdcardPath + "DCIM" + File.separator + "Camera";
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (!TextUtils.isEmpty((CharSequence)filename) && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyAssetsAndUnZip(Context context, String assetsFile, String destPath, String unZip) {
        boolean success = false;
        YYFileUtils.createDir(destPath);
        AssetManager assetManager = context.getAssets();
        String[] files = null;
        try {
            files = assetManager.list("");
        }
        catch (IOException e) {
            MLog.error((Object)TAG, "Failed to texture asset file list.", e, new Object[0]);
        }
        InputStream in = null;
        OutputStream out = null;
        if (files != null) {
            try {
                in = assetManager.open(assetsFile);
                File outFile = new File(destPath, assetsFile);
                out = new FileOutputStream(outFile);
                YYFileUtils.copyLarge(in, out, new byte[4096]);
                YYFileUtils.unZip(outFile.getPath(), unZip);
                success = true;
            }
            catch (IOException e) {
                MLog.error((Object)"FileUtil", "Failed to copy asset file: " + assetsFile, e, new Object[0]);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return success;
    }

    public static boolean isSelfScopeFile(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return false;
        }
        return filePath.startsWith(FileStorageUtils.getInstance().getExternalCacheRootDir()) || filePath.startsWith(FileStorageUtils.getInstance().getExternalFileRootDir()) || filePath.startsWith(FileStorageUtils.getInstance().getInternalCacheRootDir()) || filePath.startsWith(FileStorageUtils.getInstance().getInternalFileRootDir());
    }

    public static boolean isSelfScopeFile(File file) {
        if (file == null || file.exists()) {
            return false;
        }
        String filePath = file.getAbsolutePath();
        if (StringUtils.isEmpty(filePath)) {
            return false;
        }
        return YYFileUtils.isSelfScopeFile(filePath);
    }

    public static boolean isContentUri(String imagePath) {
        if (StringUtils.isEmpty(imagePath)) {
            return false;
        }
        return imagePath.startsWith("content://");
    }

    public static String getExtension(String fileName) throws IllegalArgumentException {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static String getRealValidPath(String filePath) {
        String realPath = filePath;
        if (YYFileUtils.isContentUri(filePath) || SdkVersionUtils.hasScopedStorage() && !YYFileUtils.isSelfScopeFile(filePath)) {
            String suffix = MimeUtils.guessExtensionFromMimeType(filePath);
            File tempFile = YYFileUtils.getTempFile(RuntimeContext.sApplicationContext, UUID.randomUUID().toString() + "_" + System.currentTimeMillis() + (StringUtils.isNotEmpty(suffix) ? suffix : ".jpg"));
            YYFileUtils.copyFileFromUri(Uri.parse((String)filePath), tempFile.getAbsolutePath());
            realPath = tempFile.getAbsolutePath();
        }
        return realPath;
    }

    public static String getRealValidPath(Uri fileUri) {
        String realPath;
        if (YYFileUtils.isContentUri(fileUri.toString()) || SdkVersionUtils.hasScopedStorage() && !YYFileUtils.isSelfScopeFile(fileUri.toString())) {
            String suffix = MimeUtils.guessExtensionFromMimeType(fileUri);
            File tempFile = YYFileUtils.getTempFile(RuntimeContext.sApplicationContext, UUID.randomUUID().toString() + "_" + System.currentTimeMillis() + (StringUtils.isNotEmpty(suffix) ? suffix : ".jpg"));
            YYFileUtils.copyFileFromUri(fileUri, tempFile.getAbsolutePath());
            realPath = tempFile.getAbsolutePath();
        } else {
            realPath = YYFileUtils.getFilePathFromUri(RuntimeContext.sApplicationContext, fileUri);
        }
        return realPath;
    }

    static {
        fileExistAndNotEmptyList = new ArrayList();
        dirExistList = new ArrayList();
        NOT_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
        space = 0L;
        G = 0x40000000L;
    }

    public static class IO {
        public static void mkdir(String path) {
            BasicFileUtils.ensureDirExists(path);
        }

        public static String concat(String p1, String p2) {
            return YYFileUtils.concatPath(p1, p2);
        }

        public static String concats(String ... ps) {
            return YYFileUtils.concatPaths(ps);
        }

        public static boolean exist(String f) {
            if (!FP.empty(f)) {
                try {
                    return new File(f).exists();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on exist", (Throwable)e);
                }
            }
            return false;
        }

        public static boolean touch(String f) {
            if (IO.exist(f)) {
                return false;
            }
            if (YYFileUtils.ensureFileDirExists(f)) {
                try {
                    new File(f).createNewFile();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on touch", (Throwable)e);
                }
            }
            return true;
        }
    }

    public static interface IFileOperateOpt {
        public boolean judgeFileExistShouldUseCache(String var1);

        public boolean judgeDirectoryShouldUseCache(String var1);
    }

    public static interface OnMonitorFileOperate {
        public void onFileExist(String var1);

        public void onNewFile(String var1);

        public void onCopyFile(String var1, String var2);

        public void onDeleteFile(String var1);

        public void onReadContentFromFile(String var1, int var2);

        public void onWriteContentToFile(String var1, int var2);

        public void onRenameFile(String var1, String var2, String var3);

        public void onMd5ForFile(String var1);

        public void onUnZip(String var1, String var2);

        public void onCreateDir(String var1);

        public void onOpenFile(String var1);
    }
}

