/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.widget.Toast;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;

public class SingleToastUtil {
    private static String oldMsg;
    protected static Toast toast;
    private static long oneTime;
    private static long twoTime;
    private static final long DEFAULT_INTERVAL = 3000L;

    public static void showToast(Context context, String s) {
        SingleToastUtil.showToast(context, s, 3000L);
    }

    public static void showToast(Context context, String s, long timeIntervals) {
        if (!StringUtils.equal(s, oldMsg) || System.currentTimeMillis() - oneTime > timeIntervals) {
            oneTime = System.currentTimeMillis();
            oldMsg = s;
            ToastUtils.showToast(context, s, 0);
        }
    }

    public static void onAppDestroy() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    if (toast != null) {
                        toast.cancel();
                    }
                }
                catch (Exception e) {
                    MLog.error("SingleToastUtil", e);
                }
                toast = null;
                oldMsg = null;
                oneTime = 0L;
                twoTime = 0L;
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread(command);
        }
    }

    static {
        toast = null;
        oneTime = 0L;
        twoTime = 0L;
    }
}

