/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.os.SystemClock;
import android.text.format.Time;
import android.util.Log;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.Locale;

public class TimeUtils {
    private static long mServiceTime = 0L;
    private static long mClientRealTime = 0L;
    private static long mHeartBeatGapTs = 0L;
    public static final long MONTHS_OF_YEAR = 12L;
    public static final long DAYS_OF_YEAR = 365L;
    public static final long DAYS_OF_MONTH = 30L;
    public static final long HOURS_OF_DAY = 24L;
    public static final long MINUTES_OF_HOUR = 60L;
    public static final long SECONDS_OF_MINUTE = 60L;
    public static final long MILLIS_OF_SECOND = 1000L;

    public static boolean isSameYear(long millis1, long millis2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(millis1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1);
    }

    public static boolean isCurrentInTimeScope() {
        boolean result = false;
        long aDayInMillis = 86400000L;
        long currentTimeMillis = System.currentTimeMillis();
        Time now = new Time();
        now.set(currentTimeMillis);
        Time startTime = new Time();
        startTime.set(currentTimeMillis);
        startTime.hour = 21;
        startTime.minute = 0;
        Time endTime = new Time();
        endTime.set(currentTimeMillis);
        endTime.hour = 4;
        endTime.minute = 0;
        if (!startTime.before(endTime)) {
            startTime.set(startTime.toMillis(true) - 86400000L);
            result = !now.before(startTime) && !now.after(endTime);
            Time startTimeInThisDay = new Time();
            startTimeInThisDay.set(startTime.toMillis(true) + 86400000L);
            if (!now.before(startTimeInThisDay)) {
                result = true;
            }
        } else {
            result = !now.before(startTime) && !now.after(endTime);
        }
        return result;
    }

    public static boolean isSameDay(long millis1, long millis2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(millis1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static boolean isSameWeek(long millis1, long millis2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(millis1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(3) == c2.get(3);
    }

    public static int getYear(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(1);
    }

    public static int getMonth(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(2) + 1;
    }

    public static int getDayOfMonth(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(5);
    }

    public static int getDayOfWeek(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(7);
    }

    public static int getHourOf12HClock(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(10);
    }

    public static int getHourOf24HClock(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(11);
    }

    public static int getMinute(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(12);
    }

    public static int getSecond(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(13);
    }

    public static long getExpireDeadTime(long millisToExpire) {
        return System.currentTimeMillis() + millisToExpire;
    }

    public static String getTimeStringFromMillis(long timeMillis) {
        String format = "%04d-%02d-%02d %02d:%02d:%2d";
        return TimeUtils.getTimeStringFromMillis(timeMillis, format);
    }

    public static String getTimeStringFromMillis(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            timeString = StringUtils.formatWitUSLocal(format, year, month, day, hour, min, sec);
        }
        catch (IllegalFormatException e) {
            Log.e((String)"TimeUtils", (String)"printStackTrace", (Throwable)e);
        }
        return timeString;
    }

    public static String getFormatTimeString(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            timeString = format.replaceAll("year", String.valueOf(year)).replaceAll("mon", month < 10 ? "0" + month : "" + month).replaceAll("day", day < 10 ? "0" + day : "" + day).replaceAll("hour", hour < 10 ? "0" + hour : "" + hour).replaceAll("min", min < 10 ? "0" + min : "" + min).replaceAll("sec", sec < 10 ? "0" + sec : "" + sec);
        }
        catch (Exception e) {
            MLog.error((Object)"TimeUtils", "getFormatTimeString error! " + e.toString(), new Object[0]);
        }
        return timeString;
    }

    public static String getFormatTime(long time) {
        int minute;
        int hour;
        if (time <= 0L) {
            return "0s";
        }
        StringBuilder builder = new StringBuilder();
        int day = (int)time / 86400;
        if (day > 0) {
            builder.append(day).append("d");
            time -= (long)(day * 24 * 60 * 60);
        }
        if ((hour = (int)time / 3600) > 0) {
            builder.append(hour).append("h");
            time -= (long)(hour * 60 * 60);
        }
        if ((minute = (int)time / 60) > 0) {
            builder.append(minute).append("min");
            time -= (long)(minute * 60);
        }
        if (time > 0L) {
            builder.append(time).append("s");
        }
        return builder.toString();
    }

    public static String getFormatTime2(long millis) {
        int hour;
        if (millis <= 0L) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        StringBuilder builder = new StringBuilder();
        int day = (int)(millis / DAYS.toMillis(1L));
        if (day > 0) {
            builder.append(day);
            if (day > 1) {
                builder.append("days ");
            } else {
                builder.append("day ");
            }
            millis -= DAYS.toMillis(day);
        }
        if ((hour = (int)(millis / HOURS.toMillis(1L))) > 0) {
            builder.append(df.format(hour)).append(":");
            millis -= HOURS.toMillis(hour);
        } else {
            builder.append(df.format(0L)).append(":");
        }
        int minute = (int)(millis / MINUTES.toMillis(1L));
        if (minute > 0) {
            builder.append(df.format(minute)).append(":");
            millis -= MINUTES.toMillis(minute);
        } else {
            builder.append(df.format(0L)).append(":");
        }
        int seconds = (int)(millis / SECONDS.toMillis(1L));
        if (seconds > 0) {
            builder.append(df.format(seconds));
        } else {
            builder.append(df.format(0L));
        }
        return builder.toString();
    }

    private static long checkOverflow(long t, long scale) {
        if (t > Long.MAX_VALUE / scale) {
            return Long.MAX_VALUE;
        }
        if (t < Long.MIN_VALUE / scale) {
            return Long.MIN_VALUE;
        }
        return t * scale;
    }

    public static long convertTimeToLong(String time) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(time);
            return date.getTime();
        }
        catch (Exception e) {
            MLog.error("TimeUtils", e);
            return 0L;
        }
    }

    public static int curSec() {
        long l = System.currentTimeMillis();
        return (int)(l / 1000L);
    }

    public static void setServiceTime(long serviceTime) {
        mServiceTime = serviceTime;
    }

    public static void setClientRealTime(long clientRealTime) {
        mClientRealTime = clientRealTime;
    }

    public static long getServiceRealTime() {
        if (mServiceTime == 0L) {
            return 0L;
        }
        long dis = SystemClock.elapsedRealtime() - mClientRealTime;
        return mServiceTime + dis;
    }

    public static long getHeartBeatGapTs() {
        return mHeartBeatGapTs;
    }

    public static void setHeartBeatGapTs(long ts) {
        mHeartBeatGapTs = ts;
    }

    public static long getStartTimeOfDay() {
        Calendar calendar = Calendar.getInstance(Calendar.getInstance().getTimeZone());
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static boolean isSecondDay(Calendar calendar, long preTime) {
        if (calendar == null) {
            return false;
        }
        Calendar preCalendar = Calendar.getInstance(Calendar.getInstance().getTimeZone());
        preCalendar.setTimeInMillis(preTime);
        preCalendar.add(5, 1);
        return TimeUtils.isSameDay(calendar, preCalendar);
    }

    public static boolean isThirdDay(Calendar calendar, long preTime) {
        if (calendar == null) {
            return false;
        }
        Calendar preCalendar = Calendar.getInstance(Calendar.getInstance().getTimeZone());
        preCalendar.setTimeInMillis(preTime);
        preCalendar.add(5, 2);
        return TimeUtils.isSameDay(calendar, preCalendar);
    }

    private static boolean isSameDay(Calendar current, Calendar compare) {
        if (current.get(1) != compare.get(1)) {
            return false;
        }
        if (current.get(2) != compare.get(2)) {
            return false;
        }
        return current.get(5) == compare.get(5);
    }

    public static String formatCountDownTime(long length) {
        if (length < 1L) {
            return "00:00";
        }
        long hours = length / 3600L;
        long rem = length % 3600L;
        long minutes = rem / 60L;
        long seconds = rem % 60L;
        return hours <= 0L ? String.format("%02d:%02d", minutes, seconds) : String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static class MILLIS {
        public static long toSeconds(long millis) {
            return millis / 1000L;
        }

        public static long toMinutes(long millis) {
            return MILLIS.toSeconds(millis) / 60L;
        }

        public static long toHours(long millis) {
            return MILLIS.toMinutes(millis) / 60L;
        }

        public static long toDays(long millis) {
            return MILLIS.toHours(millis) / 24L;
        }

        public static long toMonths(long millis) {
            return MILLIS.toDays(millis) / 30L;
        }

        public static long toYears(long millis) {
            return MILLIS.toDays(millis) / 365L;
        }
    }

    public static class SECONDS {
        public static long toMillis(long seconds) {
            return TimeUtils.checkOverflow(seconds, 1000L);
        }

        public static long toMinutes(long seconds) {
            return seconds / 60L;
        }

        public static long toHours(long seconds) {
            return SECONDS.toMinutes(seconds) / 60L;
        }

        public static long toDays(long seconds) {
            return SECONDS.toHours(seconds) / 24L;
        }

        public static long toMonths(long seconds) {
            return SECONDS.toDays(seconds) / 30L;
        }

        public static long toYears(long seconds) {
            return SECONDS.toDays(seconds) / 365L;
        }
    }

    public static class MINUTES {
        public static long toMillis(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60000L);
        }

        public static long toSeconds(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60L);
        }

        public static long toHours(long minutes) {
            return minutes / 60L;
        }

        public static long toDays(long minutes) {
            return MINUTES.toHours(minutes) / 24L;
        }

        public static long toMonths(long minutes) {
            return MINUTES.toDays(minutes) / 30L;
        }

        public static long toYears(long minutes) {
            return MINUTES.toDays(minutes) / 365L;
        }

        public static long toCeilHours(long minutes) {
            return (long)Math.ceil((double)minutes / 60.0);
        }
    }

    public static class HOURS {
        public static long toMillis(long hours) {
            return TimeUtils.checkOverflow(hours, 3600000L);
        }

        public static long toSeconds(long hours) {
            return TimeUtils.checkOverflow(hours, 3600L);
        }

        public static long toMinutes(long hours) {
            return TimeUtils.checkOverflow(hours, 60L);
        }

        public static long toDays(long hours) {
            return hours / 24L;
        }

        public static long toMonths(long hours) {
            return HOURS.toDays(hours) / 30L;
        }

        public static long toYears(long hours) {
            return HOURS.toDays(hours) / 365L;
        }
    }

    public static class DAYS {
        public static long toMillis(long days) {
            return TimeUtils.checkOverflow(days, 86400000L);
        }

        public static long toSeconds(long days) {
            return TimeUtils.checkOverflow(days, 86400L);
        }

        public static long toMinutes(long days) {
            return TimeUtils.checkOverflow(days, 1440L);
        }

        public static long toHours(long days) {
            return TimeUtils.checkOverflow(days, 24L);
        }

        public static long toMonths(long days) {
            return days / 30L;
        }

        public static long toYears(long days) {
            return days / 365L;
        }
    }

    public static class MONTHS {
        public static long toMillis(long months) {
            return TimeUtils.checkOverflow(months, 2592000000L);
        }

        public static long toSeconds(long months) {
            return TimeUtils.checkOverflow(months, 2592000L);
        }

        public static long toMinutes(long months) {
            return TimeUtils.checkOverflow(months, 43200L);
        }

        public static long toHours(long months) {
            return TimeUtils.checkOverflow(months, 720L);
        }

        public static long toDays(long months) {
            return TimeUtils.checkOverflow(months, 30L);
        }

        public static long toYears(long months) {
            return months / 12L;
        }
    }

    public static class YEARS {
        public static long toMillis(long years) {
            return TimeUtils.checkOverflow(years, 31536000000L);
        }

        public static long toSeconds(long years) {
            return TimeUtils.checkOverflow(years, 31536000L);
        }

        public static long toMinutes(long years) {
            return TimeUtils.checkOverflow(years, 525600L);
        }

        public static long toHours(long years) {
            return TimeUtils.checkOverflow(years, 8760L);
        }

        public static long toDays(long years) {
            return TimeUtils.checkOverflow(years, 365L);
        }

        public static long toMonths(long years) {
            return TimeUtils.checkOverflow(years, 12L);
        }
    }
}

