/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.StringUtils;

public class VersionUtil {
    private static final String SNAPSHOT = "-SNAPSHOT";
    private static final String DOT = ".";
    static int[] sLocalVer = null;
    static String sLocalName = null;
    private static int sVerCode = -1;

    public static Ver getVerFromStr(String version) {
        String normalVer = version;
        if (version != null && version.contains(SNAPSHOT)) {
            normalVer = version.substring(0, version.indexOf(SNAPSHOT));
        }
        if (normalVer != null && normalVer.matches("\\d{1,}.\\d{1,}.\\d{1,}\\D*")) {
            Ver ver = new Ver();
            int dotPos = normalVer.indexOf(DOT);
            int prevPos = 0;
            ver.mMajor = Integer.valueOf(normalVer.substring(prevPos, dotPos));
            prevPos = dotPos + 1;
            dotPos = normalVer.indexOf(DOT, prevPos);
            ver.mMinor = Integer.valueOf(normalVer.substring(prevPos, dotPos));
            prevPos = dotPos + 1;
            ver.mBuild = Integer.valueOf(normalVer.substring(prevPos).replaceAll("\\D*", ""));
            ver.isSnapshot = version.contains(SNAPSHOT);
            return ver;
        }
        return null;
    }

    public static Ver getLocalVer(Context c) {
        Ver v = new Ver();
        int[] ver = VersionUtil.getLocal(c);
        if (ver != null && ver.length > 0) {
            v.mMajor = ver[0];
            if (ver.length > 1) {
                v.mMinor = ver[1];
                if (ver.length > 2) {
                    v.mBuild = ver[2];
                    if (ver.length > 3) {
                        v.isSnapshot = ver[3] == 1;
                    }
                }
            }
        }
        return v;
    }

    public static String getLocalPushVer(Context c) {
        Ver v = new Ver();
        int[] ver = VersionUtil.getLocal(c);
        if (ver != null && ver.length > 0) {
            v.mMajor = ver[0];
            if (ver.length > 1) {
                v.mMinor = ver[1];
                if (ver.length > 2) {
                    v.mBuild = ver[2];
                }
            }
            return v.toString();
        }
        return "";
    }

    public static String getLocalName(Context c) {
        if (sLocalName != null) {
            return sLocalName;
        }
        try {
            VersionUtil.loadLoaclVer(c);
        }
        catch (Exception e) {
            sLocalVer = new int[4];
            VersionUtil.sLocalVer[0] = 0;
            VersionUtil.sLocalVer[1] = 0;
            VersionUtil.sLocalVer[2] = 0;
            VersionUtil.sLocalVer[3] = 0;
        }
        return sLocalName;
    }

    public static int[] getLocal(Context c) {
        if (sLocalVer != null) {
            return (int[])sLocalVer.clone();
        }
        try {
            VersionUtil.loadLoaclVer(c);
        }
        catch (Exception e) {
            sLocalVer = new int[4];
            VersionUtil.sLocalVer[0] = 0;
            VersionUtil.sLocalVer[1] = 0;
            VersionUtil.sLocalVer[2] = 0;
            VersionUtil.sLocalVer[3] = 0;
        }
        return (int[])sLocalVer.clone();
    }

    public static String getVersionWithoutSnpashot(Context context) {
        return VersionUtil.getLocalVer(context).getVersionNameWithoutSnapshot();
    }

    public static int getVersionCode(Context c) {
        int verCode = 0;
        try {
            if (sVerCode != -1) {
                return sVerCode;
            }
            sVerCode = verCode = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"VersionUtil", (String)"Empty Catch on getVersionCode", (Throwable)e);
        }
        return verCode;
    }

    static void loadLoaclVer(Context c) {
        try {
            sLocalName = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Local Ver Package Error");
        }
        if (sLocalName == null) {
            throw new RuntimeException("Local Ver VersionName Not Exist");
        }
        Ver ver = VersionUtil.getVerFromStr(sLocalName);
        sLocalVer = ver.toVerCode();
    }

    public static boolean isLocalDevBuild() {
        return false;
    }

    public static int getAppVersion() {
        int curVer = 0;
        int[] ver = VersionUtil.getLocal(RuntimeContext.sApplicationContext);
        if (ver != null && ver.length >= 3) {
            String ver0 = StringUtils.formatWitUSLocal(ver[0] > 9 ? "%d" : "0%d", ver[0]);
            String ver1 = StringUtils.formatWitUSLocal(ver[1] > 9 ? "%d" : "0%d", ver[1]);
            String ver2 = StringUtils.formatWitUSLocal(ver[2] > 9 ? "%d" : "0%d", ver[2]);
            String verStr = ver0 + ver1 + ver2;
            if (!TextUtils.isEmpty((CharSequence)verStr)) {
                curVer = StringUtils.parseInt(verStr);
            }
        }
        return curVer;
    }

    public static class Ver {
        public int mMajor;
        public int mMinor;
        public int mBuild;
        public boolean isSnapshot;

        public boolean bigThan(Ver v) {
            return this.mMajor > v.mMajor || this.mMajor == v.mMajor && this.mMinor > v.mMinor || this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild > v.mBuild;
        }

        public boolean smallThan(Ver v) {
            return this.mMajor < v.mMajor || this.mMajor == v.mMajor && this.mMinor < v.mMinor || this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild < v.mBuild;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Ver v = (Ver)o;
            return this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild == v.mBuild;
        }

        public String toString() {
            if (this.isSnapshot) {
                return StringUtils.formatWitUSLocal("%d.%d.%d(SNAPSHOT, Build %s)", this.mMajor, this.mMinor, this.mBuild, VersionUtil.getVersionCode(RuntimeContext.sApplicationContext));
            }
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public int[] toVerCode() {
            int[] ver = new int[]{this.mMajor, this.mMinor, this.mBuild, this.isSnapshot ? 1 : 0};
            return ver;
        }

        public String getVersionName(Context c) {
            if (this.isSnapshot) {
                return StringUtils.formatWitUSLocal("%d.%d.%d", 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c));
            }
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String aboutDisplayName(Context c) {
            if (this.isSnapshot) {
                return StringUtils.formatWitUSLocal("%d.%d.%d-%s(%d.%d.%d)%s", this.mMajor, this.mMinor, this.mBuild, "\u5185\u6d4b\u7248", 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c), RuntimeContext.sIsDebuggable ? "D" : "");
            }
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String getVersionNameWithoutSnapshot() {
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String getVersionNameWithoutSnapshotAndBuild() {
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, 0);
        }

        public String getVersionCodeWithoutSnapshot() {
            return StringUtils.formatWitUSLocal("%d%02d%02d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String feedbackVersionName(Context c) {
            if (this.isSnapshot) {
                return StringUtils.formatWitUSLocal("%d.%d.%d-dev(%d.%d.%d)%s", this.mMajor, this.mMinor, this.mBuild, 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c), RuntimeContext.sIsDebuggable ? "D" : "");
            }
            return StringUtils.formatWitUSLocal("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String getVersionNameFor3GReq() {
            String versionName = this.getVersionNameWithoutSnapshot();
            if (this.isSnapshot || RuntimeContext.sIsDebuggable) {
                versionName = versionName + "_beta";
            }
            return versionName;
        }

        public String getOriginalVersion() {
            return sLocalName;
        }
    }
}

