/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import android.text.TextUtils;
import com.yy.base.okhttp.request.OkHttpRequest;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class OtherRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain;charset=utf-8");
    private RequestBody requestBody;
    private String method;
    private String content;

    public OtherRequest(OkHttpClient executor, RequestBody requestBody, String content, String method, String url, Object tag, Map<String, String> params, Map<String, String> headers, int id2) {
        super(executor, url, tag, params, headers, id2);
        this.requestBody = requestBody;
        this.method = method;
        this.content = content;
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.requestBody == null && TextUtils.isEmpty((CharSequence)this.content) && HttpMethod.requiresRequestBody((String)this.method)) {
            throw new IllegalArgumentException("requestBody and content can not be null in method:" + this.method);
        }
        if (this.requestBody == null && !TextUtils.isEmpty((CharSequence)this.content)) {
            this.requestBody = RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)this.content);
        }
        return this.requestBody;
    }

    @Override
    protected Request.Builder buildRequest(RequestBody requestBody) {
        if (this.method.equals("PUT")) {
            this.builder.put(requestBody);
        } else if (this.method.equals("DELETE")) {
            if (requestBody == null) {
                this.builder.delete();
            } else {
                this.builder.delete(requestBody);
            }
        } else if (this.method.equals("HEAD")) {
            this.builder.head();
        } else if (this.method.equals("PATCH")) {
            this.builder.patch(requestBody);
        }
        return this.builder;
    }
}

