/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.list;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.logger.MLog;
import java.util.Collection;
import java.util.List;

public class KvoPageList<T>
extends KvoSource {
    private static final String TAG = "KvoPageList";
    private static final int SNAPSHOT_CHANGE_STRATEGY = 0;
    public static final String kvo_datas = "datas";
    @KvoFieldAnnotation(name="datas")
    @NonNull
    public final KvoList<T> datas = new KvoList(this, "datas");
    public static final String kvo_hasMore = "hasMore";
    @KvoFieldAnnotation(name="hasMore")
    public boolean hasMore = false;
    public static final String kvo_offset = "offset";
    @KvoFieldAnnotation(name="offset")
    public long offset = 0L;
    public static final String kvo_limit = "limit";
    @KvoFieldAnnotation(name="limit")
    public long limit = 0L;
    public static final String kvo_snapshot = "snapshot";
    @KvoFieldAnnotation(name="snapshot")
    public long snapshot = 0L;
    public static final String kvo_total = "total";
    @KvoFieldAnnotation(name="total")
    public long total = 0L;

    @MainThread
    public void reset() {
        this.datas.clear();
        this.setValue(kvo_hasMore, false);
        this.setValue(kvo_limit, 0L);
        this.setValue(kvo_offset, 0L);
        this.setValue(kvo_total, 0L);
        this.setValue(kvo_snapshot, 0L);
    }

    @MainThread
    public void combineList(List<T> list, long snapshot, long limit, long total, long startOffset, long newOffset) {
        MLog.debug(TAG, "current list size: " + this.datas.size() + ", snapshot: " + this.snapshot + ", offset: " + this.offset + ", limit: " + this.limit + ", total: " + this.total, new Object[0]);
        MLog.debug(TAG, "new list size: " + list.size() + ", snapshot: " + snapshot + ", startOffset: " + startOffset + ", newOffset: " + newOffset + ", limit: " + limit + ", total: " + total, new Object[0]);
        if (startOffset == 0L) {
            this.datas.set(list);
            this.setValue(kvo_snapshot, snapshot);
            this.setValue(kvo_limit, limit);
            this.setValue(kvo_total, total);
            this.setValue(kvo_offset, newOffset);
            this.setValue(kvo_hasMore, total > newOffset);
            return;
        }
        if (this.snapshot == snapshot) {
            if (this.offset + limit == newOffset || newOffset == total) {
                this.datas.addAll((Collection<T>)list);
                this.setValue(kvo_limit, limit);
                this.setValue(kvo_total, total);
                this.setValue(kvo_offset, newOffset);
                this.setValue(kvo_hasMore, total > newOffset);
            } else {
                MLog.error((Object)TAG, "no continue datas in page list", new Object[0]);
            }
            return;
        }
        MLog.error((Object)TAG, "old snapshot is expired", new Object[0]);
        this.datas.set(list);
        this.setValue(kvo_snapshot, snapshot);
        this.setValue(kvo_limit, limit);
        this.setValue(kvo_total, total);
        this.setValue(kvo_offset, newOffset);
        this.setValue(kvo_hasMore, total > newOffset);
    }
}

