/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.featurelog;

import android.os.Build;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BDA {

    public static class BDABuilder {
        private String mTag;
        private String mRoomId;
        private String mRoomName;
        private String mGameId;
        private String mGameVersion;
        private String mScenesName;
        private String mScenesResult;
        private int mStatus = -1;

        public static BDABuilder instance() {
            return new BDABuilder();
        }

        public BDABuilder tag(String tag) {
            this.mTag = tag;
            return this;
        }

        public BDABuilder room(String id2, String name) {
            this.mRoomId = id2;
            this.mRoomName = name;
            return this;
        }

        public BDABuilder game(String id2, String version) {
            this.mGameId = id2;
            this.mGameVersion = version;
            return this;
        }

        public BDABuilder scenes(String name, String result) {
            this.mScenesName = name;
            this.mScenesResult = result;
            return this;
        }

        public BDABuilder scenesStatus(int status) {
            this.mStatus = status;
            return this;
        }

        public void build() {
            if (RuntimeContext.sIsDebuggable) {
                if (StringUtils.isEmpty(this.mTag)) {
                    throw new RuntimeException("please invoke tag()");
                }
                if (StringUtils.isEmpty(this.mScenesName) || StringUtils.isEmpty(this.mScenesResult)) {
                    throw new RuntimeException("\u5927\u6570\u636e\u65e5\u5fd7\u573a\u666f\u540d\u79f0 \u548c \u7ed3\u679c \u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01\uff01");
                }
            }
            Model model = new Model();
            model.tag = this.mTag;
            model.roomId = this.mRoomId;
            model.roomName = this.mRoomName;
            model.gameId = this.mGameId;
            model.gameVersion = this.mGameVersion;
            model.scenesName = this.mScenesName;
            model.scenesResult = this.mScenesResult;
            model.status = this.mStatus;
            String info = model.toString();
            MLog.info(this.mTag, info, new Object[0]);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScenesStatus {
            public static final int def = -1;
            public static final int sucess = 1;
            public static final int fail = 0;
        }
    }

    private static class Model {
        private String tag;
        private String lang = SystemUtils.getLangAndCountry();
        private String ver = "1.0.0";
        private String os = Build.VERSION.RELEASE;
        private String phoneType = Build.MODEL;
        private String roomId;
        private String roomName;
        private String gameId;
        private String gameVersion;
        private String scenesName;
        private String scenesResult;
        private int status = -1;

        private Model() {
        }

        public String toString() {
            return "{\"tag\":\"" + this.tag + "\"," + this.formatJsonMiddle(this.appJson()) + this.formatJsonMiddle(this.roomJson()) + this.formatJsonMiddle(this.gameJson()) + this.formatJsonEnd(this.scenesJson()) + "}";
        }

        private String formatJsonMiddle(String json) {
            return StringUtils.isEmpty(json) ? "" : json + ",";
        }

        private String formatJsonEnd(String json) {
            return StringUtils.isEmpty(json) ? "" : json;
        }

        private String appJson() {
            return "\"ctx-app\":{\"ver\":\"" + this.ver + "\",\"os\":\"" + this.os + "\",\"lang\":\"" + this.lang + "\",\"phoneType\":\"" + this.phoneType + "\"}";
        }

        private String roomJson() {
            return StringUtils.isEmpty(this.roomId) || StringUtils.isEmpty(this.roomName) ? "" : "\"ctx-room\":{\"id\":\"" + this.roomId + "\",\"name\":\"" + this.roomName + "\"}";
        }

        private String gameJson() {
            return StringUtils.isEmpty(this.gameId) || StringUtils.isEmpty(this.gameVersion) ? "" : "\"ctx-game\":{\"id\":\"" + this.gameId + "\",\"ver\":\"" + this.gameVersion + "\"}";
        }

        private String scenesJson() {
            return StringUtils.isEmpty(this.scenesName) || StringUtils.isEmpty(this.scenesResult) ? "" : "\"ctx-scenes\":{\"name\":\"" + this.scenesName + "\",\"result\":\"" + this.scenesResult + "\",\"status\":\"" + this.status + "\"}";
        }
    }
}

