/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp;

import android.net.NetworkInfo;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.okhttp.TrustManagerUtils;
import com.yy.base.okhttp.builder.GetBuilder;
import com.yy.base.okhttp.builder.HeadBuilder;
import com.yy.base.okhttp.builder.OtherRequestBuilder;
import com.yy.base.okhttp.builder.PostByteBuilder;
import com.yy.base.okhttp.builder.PostFileBuilder;
import com.yy.base.okhttp.builder.PostFormBuilder;
import com.yy.base.okhttp.builder.PostStringBuilder;
import com.yy.base.okhttp.listener.OkHttpStat;
import com.yy.base.taskexecutor.NewYYTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkChangeListener;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.RequestInterceptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class OkHttpUtils {
    private static final String TAG = "OkHttpUtils";
    public static final long DEFAULT_MILLISECONDS = 15000L;
    private static volatile OkHttpUtils mDefaultInstance;
    private OkHttpClient mOkHttpClient;
    private static volatile IOkHttpClientInitCallBack sInitCallBack;
    private long mTimeoutValue = 15000L;
    private boolean mUseConnectionPool = true;
    private boolean mClearConnectionPoolByError = true;

    public OkHttpUtils(Dns dns) {
        this.mOkHttpClient = this.createDefaultClient(dns);
    }

    public static void setInitCallBack(IOkHttpClientInitCallBack initCallBack) {
        sInitCallBack = initCallBack;
        GraceUtil.setInitCallBack(sInitCallBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils getDefault() {
        if (mDefaultInstance != null) return mDefaultInstance;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (mDefaultInstance != null) return mDefaultInstance;
            if (sInitCallBack != null) {
                mDefaultInstance = new OkHttpUtils(sInitCallBack.getDns());
                mDefaultInstance.addInterceptor(sInitCallBack.getCommonInterceptor());
            } else {
                mDefaultInstance = new OkHttpUtils(null);
            }
            mDefaultInstance.initTimeoutValue();
            mDefaultInstance.initNetworkChangeMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDefaultInstance;
        }
    }

    private void initTimeoutValue() {
        if (!SettingFlags.hasInited() || !SettingFlags.getBoolean("httptimeoutswitch", true)) {
            return;
        }
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                long value = OkHttpUtils.this.getTimeoutValue();
                if (value != OkHttpUtils.this.mTimeoutValue) {
                    OkHttpUtils.this.mTimeoutValue = value;
                    if (OkHttpUtils.this.mOkHttpClient != null) {
                        OkHttpUtils.this.mOkHttpClient = OkHttpUtils.this.mOkHttpClient.newBuilder().connectTimeout(OkHttpUtils.this.mTimeoutValue, TimeUnit.MILLISECONDS).writeTimeout(OkHttpUtils.this.mTimeoutValue, TimeUnit.MILLISECONDS).readTimeout(OkHttpUtils.this.mTimeoutValue, TimeUnit.MILLISECONDS).build();
                    }
                    MLog.info(OkHttpUtils.TAG, "TimeoutValue:%d", OkHttpUtils.this.mTimeoutValue);
                }
            }
        };
        command.run();
        NetworkUtils.addNetworkChangeListener(new NetworkChangeListener(){

            @Override
            public void onChange(int networkTyp, NetworkInfo info) {
                command.run();
            }
        });
    }

    private void initNetworkChangeMonitor() {
        NetworkUtils.addNetworkChangeListener(new NetworkChangeListener(){

            @Override
            public void onChange(int networkTyp, NetworkInfo info) {
                if ((sInitCallBack == null || OkHttpUtils.enableCloseConnection()) && info != null && info.isConnectedOrConnecting()) {
                    YYTaskExecutor.execute(() -> {
                        MLog.debug(OkHttpUtils.TAG, "network change type: " + networkTyp + ", evictAll idle connection", new Object[0]);
                        OkHttpUtils.this.evictConnectionPoolAll();
                    });
                }
            }
        });
    }

    public long getTimeoutValue() {
        if (NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext)) {
            int netType = NetworkUtils.getNetworkType(RuntimeContext.sApplicationContext);
            long configValue = this.getConfigValue(netType);
            if (configValue > 0L) {
                return configValue;
            }
            if (netType == 1) {
                return 7000L;
            }
            if (netType == 4) {
                return 9000L;
            }
            if (netType == 3) {
                return 12000L;
            }
            return 15000L;
        }
        return this.mTimeoutValue;
    }

    private long getConfigValue(int netType) {
        String valuesConfig = SettingFlags.getStringValue("httptimeoutvalue");
        String[] values = null;
        if (StringUtils.isNotEmpty(valuesConfig)) {
            try {
                values = valuesConfig.split("_");
            }
            catch (Throwable e) {
                MLog.error(TAG, e);
            }
        }
        if (values == null || values.length < 3) {
            return -1L;
        }
        int minValue = 5000;
        int maxValue = 60000;
        int valueInt = -1;
        valueInt = netType == 1 ? StringUtils.parseInt(values[0]) : (netType == 4 ? StringUtils.parseInt(values[1]) : StringUtils.parseInt(values[2]));
        if (valueInt > 5000 && valueInt < 60000) {
            return valueInt;
        }
        return -1L;
    }

    private boolean useConnectionPool() {
        int percent = 50;
        if (!RuntimeContext.sIsDebuggable) {
            percent = SettingFlags.getIntValue("useconnectpollpercent", 100);
        }
        if (percent >= 100 || percent < 0) {
            return true;
        }
        if (percent == 0) {
            return false;
        }
        int selectValue = new Random().nextInt(100);
        if (selectValue < 0 || selectValue > 100) {
            return false;
        }
        return selectValue <= percent;
    }

    public boolean isUseConnectionPool() {
        return this.mUseConnectionPool;
    }

    private boolean shouldClearConnectionPoolByErrorInner() {
        int percent = 50;
        if (!RuntimeContext.sIsDebuggable) {
            percent = SettingFlags.getIntValue("clearconnectpollwhenerror", 100);
        }
        if (percent > 100 || percent < 0) {
            return false;
        }
        if (percent == 0) {
            return false;
        }
        int selectValue = new Random().nextInt(100);
        if (selectValue < 0 || selectValue > 100) {
            return false;
        }
        return selectValue <= percent;
    }

    public boolean shouldClearConnectionPoolByError() {
        return this.mClearConnectionPoolByError;
    }

    private synchronized OkHttpClient createDefaultClient(Dns dns) {
        this.mUseConnectionPool = this.useConnectionPool();
        this.mClearConnectionPoolByError = this.shouldClearConnectionPoolByErrorInner();
        int http2Type = TargetBuildConstant.enableHttp2;
        MLog.info(TAG, "UseConnectionPool %s ClearConnectionPoolByError %s, http2Type:%d", String.valueOf(this.mUseConnectionPool), String.valueOf(this.mClearConnectionPoolByError), http2Type);
        OkHttpClient.Builder build = new OkHttpClient.Builder().connectTimeout(this.mTimeoutValue, TimeUnit.MILLISECONDS).writeTimeout(this.mTimeoutValue, TimeUnit.MILLISECONDS).readTimeout(this.mTimeoutValue, TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(this.mUseConnectionPool ? 5 : 0, 5L, TimeUnit.MINUTES));
        if (PageResponse.isNewTaskExecuteEnable()) {
            build.dispatcher(new Dispatcher(NewYYTaskExecutor.getCachePool()));
        } else {
            build.dispatcher(new Dispatcher((ExecutorService)YYTaskExecutor.getThreadPool()));
        }
        if (SettingFlags.getBoolean("httpconnectionretry", true)) {
            build.retryOnConnectionFailure(true);
        }
        if (http2Type == 2) {
            build.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        TrustManagerUtils.trustManager(build);
        build.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
        if (dns != null) {
            build.dns(dns);
        }
        MLog.info(TAG, "sInitCallBack " + sInitCallBack, new Object[0]);
        build.eventListenerFactory(call -> new OkHttpStat(call, OkHttpUtils.enableCloseConnection()));
        if (this.enableH2PingInterval()) {
            build.pingInterval(15000L, TimeUnit.MILLISECONDS);
        }
        return build.build();
    }

    public static boolean enableCloseConnection() {
        return sInitCallBack != null && (sInitCallBack.closeConnectionTestType() == 1 || sInitCallBack.closeConnectionTestType() == 2);
    }

    private boolean enableH2PingInterval() {
        return sInitCallBack != null && sInitCallBack.closeConnectionTestType() == 2;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public OkHttpClient getExculdeCommonInterceptorOkHttpClient() {
        OkHttpClient.Builder builder = this.getOkHttpClient().newBuilder();
        builder.interceptors().clear();
        if (RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, "origin interceptor " + this.getOkHttpClient().interceptors(), new Object[0]);
            MLog.error((Object)TAG, "newBuilder interceptor " + builder.interceptors() + " size " + builder.interceptors().size(), new Object[0]);
        }
        return builder.build();
    }

    public void evictConnectionPoolAll() {
        if (this.mOkHttpClient == null) {
            return;
        }
        ConnectionPool connectionPool = this.mOkHttpClient.connectionPool();
        if (connectionPool != null) {
            try {
                connectionPool.evictAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GetBuilder get() {
        return new GetBuilder(this.getOkHttpClient());
    }

    public static GetBuilder get(OkHttpClient client) {
        return new GetBuilder(client);
    }

    public PostStringBuilder postString() {
        return new PostStringBuilder(this.getOkHttpClient());
    }

    public PostByteBuilder postByte() {
        return new PostByteBuilder(this.getOkHttpClient());
    }

    public PostFileBuilder postFile() {
        return new PostFileBuilder(this.getOkHttpClient());
    }

    public PostFormBuilder post() {
        return new PostFormBuilder(this.getOkHttpClient());
    }

    public static PostFormBuilder post(OkHttpClient client) {
        return new PostFormBuilder(client);
    }

    public OtherRequestBuilder put() {
        return new OtherRequestBuilder(this.getOkHttpClient(), "PUT");
    }

    public HeadBuilder head() {
        return new HeadBuilder(this.getOkHttpClient());
    }

    public OtherRequestBuilder delete() {
        return new OtherRequestBuilder(this.getOkHttpClient(), "DELETE");
    }

    public OtherRequestBuilder patch() {
        return new OtherRequestBuilder(this.getOkHttpClient(), "PATCH");
    }

    public void cancelTag(Object tag) {
        for (Call call : this.mOkHttpClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.mOkHttpClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        this.mOkHttpClient = this.mOkHttpClient.newBuilder().addInterceptor(interceptor).build();
    }

    public static interface IOkHttpClientInitCallBack {
        public static final int DEFAULT_TEST = 0;
        public static final int SOCKETIMEOUT_CLEAR_CONNECTION_TEST = 1;
        public static final int H2_PING_TEST = 2;

        public Dns getDns();

        public Interceptor getCommonInterceptor();

        public int closeConnectionTestType();

        public RequestInterceptor getRequestInterceptor();
    }

    public static class METHOD {
        public static final String HEAD = "HEAD";
        public static final String DELETE = "DELETE";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
    }
}

