/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.webpanim.decoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.Log;
import android.util.LruCache;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.yy.base.imageloader.webpanim.WebPFrame;
import com.yy.base.imageloader.webpanim.WebPImage;
import com.yy.base.imageloader.webpanim.WebpFrameInfo;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class WebpDecoder
implements GifDecoder {
    private static final String TAG = "WebpDecoder";
    private static final int MAX_FRAME_BITMAP_CACHE_SIZE = 5;
    private ByteBuffer rawData;
    private WebPImage mWebPImage;
    private final GifDecoder.BitmapProvider mBitmapProvider;
    private int mFramePointer = -1;
    private final int[] mFrameDurations;
    private final WebpFrameInfo[] mFrameInfos;
    private int sampleSize;
    private int downsampledHeight;
    private int downsampledWidth;
    private final Paint mTransparentFillPaint;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    private final LruCache<Integer, Bitmap> mFrameBitmapCache;

    public WebpDecoder(GifDecoder.BitmapProvider provider, WebPImage webPImage, ByteBuffer rawData, int sampleSize) {
        this.mBitmapProvider = provider;
        this.mWebPImage = webPImage;
        this.mFrameDurations = webPImage.getFrameDurations();
        this.mFrameInfos = new WebpFrameInfo[webPImage.getFrameCount()];
        for (int i = 0; i < this.mWebPImage.getFrameCount(); ++i) {
            this.mFrameInfos[i] = WebpFrameInfo.toWebpFrameInfo((WebPFrame)this.mWebPImage.getFrame(i), (int)this.mWebPImage.getFrameInfo((int)i).frameNumber);
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            Log.d((String)TAG, (String)("mFrameInfos: " + this.mFrameInfos[i].toString()));
        }
        this.mTransparentFillPaint = new Paint();
        this.mTransparentFillPaint.setColor(0);
        this.mTransparentFillPaint.setStyle(Paint.Style.FILL);
        this.mTransparentFillPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        this.mFrameBitmapCache = new LruCache<Integer, Bitmap>(5){

            protected void entryRemoved(boolean evicted, Integer key, Bitmap oldValue, Bitmap newValue) {
                if (oldValue != null) {
                    WebpDecoder.this.mBitmapProvider.release(oldValue);
                }
            }
        };
        this.setData(new GifHeader(), rawData, sampleSize);
    }

    @Override
    public int getWidth() {
        return this.mWebPImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mWebPImage.getHeight();
    }

    @Override
    public ByteBuffer getData() {
        return this.rawData;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void advance() {
        this.mFramePointer = (this.mFramePointer + 1) % this.mWebPImage.getFrameCount();
    }

    @Override
    public int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.mFrameDurations.length) {
            delay = this.mFrameDurations[n];
        }
        return delay;
    }

    @Override
    public int getNextDelay() {
        if (this.mFrameDurations.length == 0 || this.mFramePointer < 0) {
            return 0;
        }
        return this.getDelay(this.mFramePointer);
    }

    @Override
    public int getFrameCount() {
        return this.mWebPImage.getFrameCount();
    }

    @Override
    public int getCurrentFrameIndex() {
        return this.mFramePointer;
    }

    @Override
    public void resetFrameIndex() {
        this.mFramePointer = -1;
    }

    @Override
    public int getLoopCount() {
        return this.mWebPImage.getLoopCount();
    }

    @Override
    public int getNetscapeLoopCount() {
        return this.mWebPImage.getLoopCount();
    }

    @Override
    public int getTotalIterationCount() {
        if (this.mWebPImage.getLoopCount() == 0) {
            return 0;
        }
        return this.mWebPImage.getFrameCount() + 1;
    }

    @Override
    public int getByteSize() {
        return this.mWebPImage.getSizeInBytes();
    }

    @Override
    public void setDefaultBitmapConfig(Bitmap.Config config) {
        if (config != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Unsupported format: " + config + ", must be one of " + Bitmap.Config.ARGB_8888);
        }
        this.mBitmapConfig = config;
    }

    @Override
    public Bitmap getNextFrame() {
        int frameNumber = this.getCurrentFrameIndex();
        Bitmap bitmap = this.mBitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0, PorterDuff.Mode.SRC);
        int nextIndex = !this.isKeyFrame(frameNumber) ? this.prepareCanvasWithBlending(frameNumber - 1, canvas) : frameNumber;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("frameNumber=" + frameNumber + ", nextIndex=" + nextIndex));
        }
        for (int index = nextIndex; index < frameNumber; ++index) {
            WebpFrameInfo frameInfo = this.mFrameInfos[index];
            if (!frameInfo.blendPreviousFrame) {
                this.disposeToBackground(canvas, frameInfo);
            }
            this.renderFrame(index, canvas);
            if (!frameInfo.disposeBackgroundColor) continue;
            this.disposeToBackground(canvas, frameInfo);
        }
        WebpFrameInfo frameInfo = this.mFrameInfos[frameNumber];
        if (!frameInfo.blendPreviousFrame) {
            this.disposeToBackground(canvas, frameInfo);
        }
        this.renderFrame(frameNumber, canvas);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("renderFrame, index=" + frameNumber + ", blend=" + frameInfo.blendPreviousFrame + ", dispose=" + frameInfo.disposeBackgroundColor));
        }
        this.cacheFrameBitmap(frameNumber, bitmap);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrame(int frameNumber, Canvas canvas) {
        WebpFrameInfo frameInfo = this.mFrameInfos[frameNumber];
        int frameWidth = frameInfo.width / this.sampleSize;
        int frameHeight = frameInfo.height / this.sampleSize;
        int xOffset = frameInfo.xOffset / this.sampleSize;
        int yOffset = frameInfo.yOffset / this.sampleSize;
        WebPFrame webpFrame = this.mWebPImage.getFrame(frameNumber);
        try {
            Bitmap frameBitmap = this.mBitmapProvider.obtain(frameWidth, frameHeight, this.mBitmapConfig);
            frameBitmap.eraseColor(0);
            webpFrame.renderFrame(frameWidth, frameHeight, frameBitmap);
            canvas.drawBitmap(frameBitmap, (float)xOffset, (float)yOffset, null);
            this.mBitmapProvider.release(frameBitmap);
        }
        finally {
            webpFrame.dispose();
        }
    }

    private void cacheFrameBitmap(int frameNumber, Bitmap bitmap) {
        this.mFrameBitmapCache.remove((Object)frameNumber);
        Bitmap cache = this.mBitmapProvider.obtain(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
        cache.eraseColor(0);
        Canvas canvas = new Canvas(cache);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.mFrameBitmapCache.put((Object)frameNumber, (Object)cache);
    }

    @Override
    public int read(InputStream inputStream, int i) {
        return 0;
    }

    @Override
    public void clear() {
        this.mWebPImage.dispose();
        this.mWebPImage = null;
        this.mFrameBitmapCache.evictAll();
        this.rawData = null;
    }

    @Override
    public void setData(GifHeader header, byte[] data) {
        this.setData(header, ByteBuffer.wrap(data));
    }

    @Override
    public void setData(GifHeader header, ByteBuffer buffer) {
        this.setData(header, buffer, 1);
    }

    @Override
    public void setData(GifHeader header, ByteBuffer buffer, int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.rawData = buffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.sampleSize = sampleSize;
        this.downsampledWidth = this.mWebPImage.getWidth() / sampleSize;
        this.downsampledHeight = this.mWebPImage.getHeight() / sampleSize;
    }

    @Override
    public int read(byte[] bytes) {
        return 0;
    }

    private int prepareCanvasWithBlending(int previousFrameNumber, Canvas canvas) {
        for (int index = previousFrameNumber; index >= 0; --index) {
            WebpFrameInfo frameInfo = this.mFrameInfos[index];
            if (!frameInfo.disposeBackgroundColor || !this.isFullFrame(frameInfo)) {
                Bitmap bitmap = (Bitmap)this.mFrameBitmapCache.get((Object)index);
                if (bitmap != null && !bitmap.isRecycled()) {
                    canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    if (frameInfo.disposeBackgroundColor) {
                        this.disposeToBackground(canvas, frameInfo);
                    }
                    return index + 1;
                }
                if (!this.isKeyFrame(index)) continue;
                return index;
            }
            return index + 1;
        }
        return 0;
    }

    private void disposeToBackground(Canvas canvas, WebpFrameInfo frameInfo) {
        float left = frameInfo.xOffset / this.sampleSize;
        float top = frameInfo.yOffset / this.sampleSize;
        float right = (frameInfo.xOffset + frameInfo.width) / this.sampleSize;
        float bottom = (frameInfo.yOffset + frameInfo.height) / this.sampleSize;
        canvas.drawRect(left, top, right, bottom, this.mTransparentFillPaint);
    }

    private boolean isKeyFrame(int index) {
        if (index == 0) {
            return true;
        }
        WebpFrameInfo curFrameInfo = this.mFrameInfos[index];
        WebpFrameInfo prevFrameInfo = this.mFrameInfos[index - 1];
        if (!curFrameInfo.blendPreviousFrame && this.isFullFrame(curFrameInfo)) {
            return true;
        }
        return prevFrameInfo.disposeBackgroundColor && this.isFullFrame(prevFrameInfo);
    }

    private boolean isFullFrame(WebpFrameInfo frameInfo) {
        return frameInfo.xOffset == 0 && frameInfo.yOffset == 0 && frameInfo.width == this.mWebPImage.getWidth() && frameInfo.height == this.mWebPImage.getHeight();
    }
}

