/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import com.yy.base.okhttp.request.OkHttpRequest;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostByteRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_PB = MediaType.parse((String)"application/proto");
    private byte[] content;
    private MediaType mediaType;

    public PostByteRequest(OkHttpClient executor, String url, Object tag, Map<String, String> headers, byte[] content, MediaType mediaType, int id2) {
        super(executor, url, tag, null, headers, id2);
        this.content = content;
        this.mediaType = mediaType;
        if (this.content == null) {
            throw new IllegalArgumentException("the content can not be null !");
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_PB;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (byte[])this.content);
    }

    @Override
    protected Request.Builder buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody);
    }
}

