/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final Map<T, Y> cache = new LinkedHashMap<T, Y>(100, 0.75f, true);
    private final long initialMaxSize;
    private long maxSize;
    private long currentSize;

    public LruCache(long size) {
        this.initialMaxSize = size;
        this.maxSize = size;
    }

    public synchronized void setSizeMultiplier(float multiplier) {
        if (multiplier < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * multiplier);
        this.evict();
    }

    protected int getSize(@Nullable Y item) {
        return 1;
    }

    protected synchronized int getCount() {
        return this.cache.size();
    }

    protected void onItemEvicted(@NonNull T key, @Nullable Y item) {
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized long getCurrentSize() {
        return this.currentSize;
    }

    public synchronized boolean contains(@NonNull T key) {
        return this.cache.containsKey(key);
    }

    @Nullable
    public synchronized Y get(@NonNull T key) {
        return this.cache.get(key);
    }

    @Nullable
    public synchronized Y put(@NonNull T key, @Nullable Y item) {
        Y old;
        int itemSize = this.getSize(item);
        if ((long)itemSize >= this.maxSize) {
            this.onItemEvicted(key, item);
            return null;
        }
        if (item != null) {
            this.currentSize += (long)itemSize;
        }
        if ((old = this.cache.put(key, item)) != null) {
            this.currentSize -= (long)this.getSize(old);
            if (!old.equals(item)) {
                this.onItemEvicted(key, old);
            }
        }
        this.evict();
        return old;
    }

    @Nullable
    public synchronized Y remove(@NonNull T key) {
        Y value = this.cache.remove(key);
        if (value != null) {
            this.currentSize -= (long)this.getSize(value);
        }
        return value;
    }

    public void clearMemory() {
        this.trimToSize(0L);
    }

    protected synchronized void trimToSize(long size) {
        while (this.currentSize > size) {
            Iterator<Map.Entry<T, Y>> cacheIterator = this.cache.entrySet().iterator();
            Map.Entry<T, Y> last = cacheIterator.next();
            Y toRemove = last.getValue();
            this.currentSize -= (long)this.getSize(toRemove);
            T key = last.getKey();
            cacheIterator.remove();
            this.onItemEvicted(key, toRemove);
        }
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }
}

