/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import androidx.annotation.Nullable;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GroupedLinkedMap<K extends Poolable, V> {
    private final LinkedEntry<K, V> head = new LinkedEntry();
    private final Map<K, LinkedEntry<K, V>> keyToEntry = new HashMap<K, LinkedEntry<K, V>>();

    GroupedLinkedMap() {
    }

    public void put(K key, V value) {
        LinkedEntry<K, V> entry = this.keyToEntry.get(key);
        if (entry == null) {
            entry = new LinkedEntry(key);
            this.makeTail(entry);
            this.keyToEntry.put(key, entry);
        } else {
            key.offer();
        }
        entry.add(value);
    }

    @Nullable
    public V get(K key) {
        LinkedEntry<K, V> entry = this.keyToEntry.get(key);
        if (entry == null) {
            entry = new LinkedEntry(key);
            this.keyToEntry.put(key, entry);
        } else {
            key.offer();
        }
        this.makeHead(entry);
        return entry.removeLast();
    }

    @Nullable
    public V removeLast() {
        LinkedEntry last = this.head.prev;
        while (!last.equals(this.head)) {
            Object removed = last.removeLast();
            if (removed != null) {
                return removed;
            }
            GroupedLinkedMap.removeEntry(last);
            this.keyToEntry.remove(last.key);
            ((Poolable)last.key).offer();
            last = last.prev;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GroupedLinkedMap( ");
        LinkedEntry current = this.head.next;
        boolean hadAtLeastOneItem = false;
        while (!current.equals(this.head)) {
            hadAtLeastOneItem = true;
            sb.append('{').append(current.key).append(':').append(current.size()).append("}, ");
            current = current.next;
        }
        if (hadAtLeastOneItem) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.append(" )").toString();
    }

    private void makeHead(LinkedEntry<K, V> entry) {
        GroupedLinkedMap.removeEntry(entry);
        entry.prev = this.head;
        entry.next = this.head.next;
        GroupedLinkedMap.updateEntry(entry);
    }

    private void makeTail(LinkedEntry<K, V> entry) {
        GroupedLinkedMap.removeEntry(entry);
        entry.prev = this.head.prev;
        entry.next = this.head;
        GroupedLinkedMap.updateEntry(entry);
    }

    private static <K, V> void updateEntry(LinkedEntry<K, V> entry) {
        entry.next.prev = entry;
        entry.prev.next = entry;
    }

    private static <K, V> void removeEntry(LinkedEntry<K, V> entry) {
        entry.prev.next = entry.next;
        entry.next.prev = entry.prev;
    }

    private static class LinkedEntry<K, V> {
        final K key;
        private List<V> values;
        LinkedEntry<K, V> next;
        LinkedEntry<K, V> prev;

        LinkedEntry() {
            this(null);
        }

        LinkedEntry(K key) {
            this.next = this.prev = this;
            this.key = key;
        }

        @Nullable
        public V removeLast() {
            int valueSize = this.size();
            return valueSize > 0 ? (V)this.values.remove(valueSize - 1) : null;
        }

        public int size() {
            return this.values != null ? this.values.size() : 0;
        }

        public void add(V value) {
            if (this.values == null) {
                this.values = new ArrayList<V>();
            }
            this.values.add(value);
        }
    }
}

