/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import androidx.annotation.NonNull;
import com.yy.base.logger.LogRunnable;
import com.yy.hago.xlog.IFlushCallback;
import com.yy.hago.xlog.KLogUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LogHandlerThread {
    private static final String TAG = "LogHandlerThread";
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();

    private LogHandlerThread() {
    }

    public static LogHandlerThread getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void postLogRunnable(LogRunnable logRunnable) {
        if (logRunnable == null) {
            return;
        }
        this.mExecutorService.execute(logRunnable);
    }

    public void flush(@NonNull IFlushCallback callback) {
        KLogUtils.info("KLogUtils", "LogHandlerThread start flush to KLog!!!", new Object[0]);
        Runnable flushRunnable = () -> callback.onFlush(true);
        this.mExecutorService.execute(flushRunnable);
    }

    private static class SingleHolder {
        private static final LogHandlerThread INSTANCE = new LogHandlerThread();

        private SingleHolder() {
        }
    }
}

