/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validation {
    private static final String EXPRESSION_GREATER_EQUAL = ">=";
    private static final String EXPRESSION_EQUAL = "=";
    private static final String EXPRESSION_GREATER = ">";
    private static final String EXPRESSION_LESSER_EQUAL = "<=";
    private static final String EXPRESSION_LESSER = "<";

    public static void checkNull(String dataName, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException(dataName + " cannot be null");
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value != null) continue;
            throw new IllegalArgumentException(dataName + " cannot be null at " + dataName + "[" + i + "]");
        }
    }

    public static <T> void checkEquals(String dataName, T expected, T value) {
        if (value == null || !expected.equals(value)) {
            if (dataName == null) {
                throw new IllegalArgumentException(value + " is expected to be equal to " + expected);
            }
            throw new IllegalArgumentException(dataName + " is expected to be equal to " + value + " but in fact is " + expected);
        }
    }

    public static <T> void checkEquals(T expected, T value) {
        Validation.checkEquals(null, expected, value);
    }

    public static <T> void checkGreater(String dataName, Comparable<T> value, T expected) {
        if (value == null || value.compareTo(expected) <= 0) {
            if (dataName == null) {
                throw new IllegalArgumentException(value + " is expected to be greater than " + expected);
            }
            throw new IllegalArgumentException(dataName + " is expected to be greater than " + expected + " but in fact is " + value);
        }
    }

    public static <T> void checkGreater(Comparable<T> value, T expected) {
        Validation.checkGreater(null, value, expected);
    }

    public static <T> void checkGreaterEquals(String dataName, Comparable<T> value, T expected) {
        if (value == null || value.compareTo(expected) < 0) {
            if (dataName == null) {
                throw new IllegalArgumentException(value + " is expected to be greater equal than " + expected);
            }
            throw new IllegalArgumentException(dataName + " is expected to be greater equal than " + expected + " but in fact is " + value);
        }
    }

    public static <T> void checkGreaterEquals(Comparable<T> value, T expected) {
        Validation.checkGreaterEquals(null, value, expected);
    }

    public static <T> void checkLesser(String dataName, Comparable<T> value, T expected) {
        if (value == null || value.compareTo(expected) >= 0) {
            if (dataName == null) {
                throw new IllegalArgumentException(value + " is expected to be lesser than " + expected);
            }
            throw new IllegalArgumentException(dataName + " is expected to be lesser than " + expected + " but in fact is " + value);
        }
    }

    public static <T> void checkLesser(Comparable<T> value, T expected) {
        Validation.checkLesser(null, value, expected);
    }

    public static <T> void checkLesserEquals(String dataName, Comparable<T> value, T expected) {
        if (value == null || value.compareTo(expected) > 0) {
            if (dataName == null) {
                throw new IllegalArgumentException(value + " is expected to be lesser equal than " + expected);
            }
            throw new IllegalArgumentException(dataName + " is expected to be lesser equal than " + expected + " but in fact is " + value);
        }
    }

    public static <T> void checkLesserEquals(Comparable<T> value, T expected) {
        Validation.checkLesserEquals(null, value, expected);
    }

    public static void checkNumeric(String dataName, Object ... values) {
        Validation.checkNull(dataName, values);
        for (Object value : values) {
            Validation.checkNull(dataName, value);
            Validation.checkRegex(dataName, "[-+]?[0-9]+", value.toString());
        }
    }

    public static <T> void check(String expression, Comparable<T> ... values) {
        String[] exps = expression.split(",");
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("check failed cause by values is not a pair : " + values.length);
        }
        int i = 0;
        while (i < values.length) {
            for (String exp : exps) {
                if (StringUtils.isEmpty(exp)) {
                    throw new IllegalArgumentException("check failed cause by expression : " + expression);
                }
                Comparable<T> value1 = values[i++];
                Comparable<T> value2 = values[i++];
                if (EXPRESSION_EQUAL.equals(exp)) {
                    Validation.checkEquals(value1, value2);
                    continue;
                }
                if (EXPRESSION_GREATER.equals(exp)) {
                    Validation.checkGreater(value1, value2);
                    continue;
                }
                if (EXPRESSION_GREATER_EQUAL.equals(exp)) {
                    Validation.checkGreaterEquals(value1, value2);
                    continue;
                }
                if (EXPRESSION_LESSER.equals(exp)) {
                    Validation.checkLesser(value1, value2);
                    continue;
                }
                if (!EXPRESSION_LESSER_EQUAL.equals(exp)) continue;
                Validation.checkLesserEquals(value1, value2);
            }
        }
    }

    public static void checkRegex(String dataName, String regex, String value) {
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(value);
        if (!isNum.matches()) {
            throw new IllegalArgumentException("check failed cause by " + dataName + " is not number : " + value);
        }
    }

    public static void checkBean(Validateable bean) {
        bean.validate();
    }

    public static interface Validateable {
        public boolean validate();
    }
}

