/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.os.Build;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SystemUtils;
import java.util.Locale;

public class LanguageUtils {
    private static final String LANGUAGE_INDONESIAN = "in";
    private static final String LANGUAGE_HINDI = "hi";
    private static final String LANGUAGE_RUSSIAN = "ru";
    private static final String LANGUAGE_PORTUGUESE = "pt";
    private static final String LANGUAGE_MALAY = "ms";
    private static final String LANGUAGE_ARAB = "ar";
    private static final String LANGUAGE_CHINESE = "zh";
    private static final String LANGUAGE_VIETNAM = "vi";
    private static final String LANGUAGE_THAI = "th";
    private static final String LANGUAGE_MEXICAN = "mx";
    private static final String LANGUAGE_JAPANESE = "ja";
    private static final String LANGUAGE_KOREA = "ko";
    private static Boolean isLtr = null;

    public static boolean isEnglish() {
        return Locale.ENGLISH.getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isIndonesian() {
        return new Locale(LANGUAGE_INDONESIAN).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isHindi() {
        return new Locale(LANGUAGE_HINDI).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isRussian() {
        return new Locale(LANGUAGE_RUSSIAN).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isPortuguese() {
        return new Locale(LANGUAGE_PORTUGUESE).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isMalay() {
        return new Locale(LANGUAGE_MALAY).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isArab() {
        return new Locale(LANGUAGE_ARAB).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isZh() {
        return new Locale(LANGUAGE_CHINESE).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isThai() {
        return new Locale(LANGUAGE_THAI).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isMexican() {
        return new Locale(LANGUAGE_MEXICAN).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isVietnamese() {
        return new Locale(LANGUAGE_VIETNAM).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isJapanese() {
        return new Locale(LANGUAGE_JAPANESE).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isKorea() {
        return new Locale(LANGUAGE_KOREA).getLanguage().equals(SystemUtils.getLang());
    }

    public static boolean isRtl() {
        return !LanguageUtils.isLtr();
    }

    public static boolean isLtr() {
        if (isLtr == null) {
            boolean isLtr = true;
            if (Build.VERSION.SDK_INT >= 17) {
                isLtr = 0 == RuntimeContext.sApplicationContext.getResources().getConfiguration().getLayoutDirection();
            }
            LanguageUtils.isLtr = isLtr;
        }
        return isLtr;
    }

    public static boolean isMiddleEast() {
        if (LanguageUtils.isArab()) {
            return true;
        }
        String countryCode = SystemUtils.getHagoCountry();
        return "EG".equalsIgnoreCase(countryCode) || "SA".equalsIgnoreCase(countryCode) || "AE".equalsIgnoreCase(countryCode);
    }
}

