/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.content.ContentResolver;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class LocalUriFetcher<T>
implements DataFetcher<T> {
    private static final String TAG = "LocalUriFetcher";
    private final Uri uri;
    private final ContentResolver contentResolver;
    private T data;

    public LocalUriFetcher(ContentResolver contentResolver, Uri uri) {
        this.contentResolver = contentResolver;
        this.uri = uri;
    }

    @Override
    public final void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super T> callback) {
        try {
            this.data = this.loadResource(this.uri, this.contentResolver);
        }
        catch (FileNotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to open Uri", (Throwable)e);
            }
            callback.onLoadFailed(e);
            return;
        }
        callback.onDataReady(this.data);
    }

    @Override
    public void cleanup() {
        if (this.data != null) {
            try {
                this.close(this.data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return DataSource.LOCAL;
    }

    protected abstract T loadResource(Uri var1, ContentResolver var2) throws FileNotFoundException;

    protected abstract void close(T var1) throws IOException;
}

