/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.StyleSpan;
import androidx.annotation.NonNull;
import java.util.ArrayList;

public class SpannableStringUtil {
    public static final int TYPE_TXT = 0;
    public static final int TYPE_IMG = 1;
    public static final int TYPE_TXT_CLICKABLE = 2;

    public static SpannableStringBuilder getSpannableString(ISpannableBlock ... strBlock) {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        if (strBlock != null && strBlock.length > 0) {
            int currLen = 0;
            int len = 0;
            for (ISpannableBlock block : strBlock) {
                Object[] spans;
                ssb.append(block.getContent());
                len = block.getEnd();
                for (Object span : spans = block.getSpans()) {
                    ssb.setSpan(span, currLen, currLen + len, 17);
                }
                currLen += len;
            }
        }
        return ssb;
    }

    public static class CenterImageSpan
    extends ImageSpan {
        public CenterImageSpan(@NonNull Drawable drawable2) {
            super(drawable2);
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable d = this.getDrawable();
            Paint.FontMetrics fm = paint.getFontMetrics();
            int transY = (int)((float)y + fm.descent + (float)y + fm.ascent) / 2 - d.getBounds().bottom / 2;
            canvas.save();
            canvas.translate(x, (float)transY);
            d.draw(canvas);
            canvas.restore();
        }
    }

    public static class SpannableBlockBuilder {
        private CharSequence mContent;
        private Drawable mDrawable;
        private int mColor;
        private int mSize;
        private int mTypeface;
        private ClickableSpan mClickableSpan;

        public SpannableBlockBuilder withText(CharSequence content) {
            this.mContent = content;
            return this;
        }

        public SpannableBlockBuilder withDrawable(Drawable drawable2) {
            this.mDrawable = drawable2;
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            return this;
        }

        public SpannableBlockBuilder withColor(int color) {
            this.mColor = color;
            return this;
        }

        public SpannableBlockBuilder withSize(int size) {
            this.mSize = size;
            return this;
        }

        public SpannableBlockBuilder withTypeface(int typeface) {
            this.mTypeface = typeface;
            return this;
        }

        public SpannableBlockBuilder withClickableSpan(ClickableSpan clickableSpan) {
            this.mClickableSpan = clickableSpan;
            return this;
        }

        public ISpannableBlock build() {
            return new ISpannableBlock(){

                @Override
                public CharSequence getContent() {
                    if (mDrawable != null && TextUtils.isEmpty((CharSequence)mContent)) {
                        return "image";
                    }
                    return mContent;
                }

                @Override
                public int getEnd() {
                    return mContent.length();
                }

                @Override
                public Object[] getSpans() {
                    ArrayList<Object> spanList = new ArrayList<Object>(5);
                    if (mColor != 0) {
                        spanList.add(new ForegroundColorSpan(mColor));
                    }
                    if (mSize != 0) {
                        spanList.add(new AbsoluteSizeSpan(mSize));
                    }
                    if (mTypeface != 0) {
                        spanList.add(new StyleSpan(mTypeface));
                    }
                    if (mDrawable != null) {
                        spanList.add((Object)new CenterImageSpan(mDrawable));
                    }
                    if (mClickableSpan != null) {
                        spanList.add(mClickableSpan);
                    }
                    return spanList.toArray();
                }

                @Override
                public boolean isValid() {
                    return !TextUtils.isEmpty((CharSequence)mContent) || mDrawable != null;
                }
            };
        }
    }

    public static class SpannableStringBlock
    implements ISpannableBlock {
        CharSequence content;
        Drawable drawable;
        int color;
        int type;
        int size;
        ClickableSpan clickableSpan;

        public SpannableStringBlock(CharSequence content, int color) {
            this.content = content;
            this.color = color;
            this.type = 0;
        }

        public SpannableStringBlock(CharSequence content, int color, int size) {
            this.content = content;
            this.color = color;
            this.size = size;
            this.type = 0;
        }

        public SpannableStringBlock(CharSequence content, ClickableSpan clickableSpan) {
            this.content = content;
            this.type = 2;
            this.clickableSpan = clickableSpan;
        }

        public SpannableStringBlock(Drawable drawable2) {
            this.content = "image";
            this.drawable = drawable2;
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            this.type = 1;
        }

        public boolean isEmpty() {
            return TextUtils.isEmpty((CharSequence)this.content);
        }

        @Override
        public boolean isValid() {
            switch (this.type) {
                case 1: {
                    return this.drawable != null;
                }
                case 0: {
                    return !TextUtils.isEmpty((CharSequence)this.content);
                }
                case 2: {
                    return !TextUtils.isEmpty((CharSequence)this.content) && this.clickableSpan != null;
                }
            }
            return false;
        }

        @Override
        public CharSequence getContent() {
            return this.content;
        }

        @Override
        public int getEnd() {
            return this.content.length();
        }

        @Override
        public Object[] getSpans() {
            if (this.type == 1) {
                return new Object[]{new CenterImageSpan(this.drawable)};
            }
            if (this.type == 2) {
                return new Object[]{this.clickableSpan};
            }
            if (this.type == 0) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                if (this.color != 0) {
                    list.add(new ForegroundColorSpan(this.color));
                }
                if (this.size != 0) {
                    list.add(new AbsoluteSizeSpan(this.size));
                }
                return list.toArray();
            }
            return new Object[0];
        }
    }

    public static interface ISpannableBlock {
        public CharSequence getContent();

        public int getEnd();

        public Object[] getSpans();

        public boolean isValid();
    }
}

