/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.fdutils;

import android.os.Build;
import android.os.Process;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FdsController {
    private static final String TAG = "FdsController";
    private static int sPid = -1;
    private static int sMaxFDCount = -1;

    public static String getFDLogsPath() {
        return FileStorageUtils.getInstance().getTempDir() + File.separator + "fds.txt";
    }

    private static File getFilesParent() {
        String path = "/proc/" + FdsController.getPid() + "/fd";
        File file = new File(path);
        if (file.exists() && file.canRead()) {
            return file;
        }
        return null;
    }

    public static void getFilesNumber(CallBack<Integer> callback) {
        YYTaskExecutor.execute(() -> {
            File tasksParent = FdsController.getFilesParent();
            File[] tasks = null;
            if (tasksParent != null) {
                try {
                    tasks = tasksParent.listFiles();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "", e, new Object[0]);
                }
            }
            if (tasks != null && tasks.length > 0) {
                File[] finalTasks = tasks;
                YYTaskExecutor.postToMainThread(() -> callback.onSuccess(finalTasks.length));
            } else {
                YYTaskExecutor.postToMainThread(() -> callback.onSuccess(0));
            }
        });
    }

    public static void getFilesDetailInfo(CallBack<HashMap<String, Integer>> callBack) {
        YYTaskExecutor.execute(() -> {
            HashMap<String, Integer> fds = new HashMap<String, Integer>();
            File[] tasks = null;
            File tasksParent = FdsController.getFilesParent();
            if (tasksParent != null) {
                try {
                    tasks = tasksParent.listFiles();
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "", e, new Object[0]);
                }
            }
            if (tasks != null && tasks.length > 0) {
                File taskItem = null;
                String taskName = null;
                int num = 0;
                try {
                    for (File item : tasks) {
                        if (!item.exists()) continue;
                        taskItem = new File(item.getAbsolutePath());
                        taskName = taskItem.getCanonicalPath();
                        if (Build.VERSION.SDK_INT >= 26 && Files.isSymbolicLink(item.toPath())) {
                            taskName = Files.readSymbolicLink(item.toPath()).toString();
                        }
                        if (StringUtils.isEmpty(taskName)) continue;
                        int index = taskName.indexOf(":");
                        String string2 = taskName = index >= 0 ? taskName.substring(0, index) : taskName;
                        if (fds.containsKey(taskName)) {
                            num = (Integer)fds.get(taskName) + 1;
                            if (num <= 0) {
                                num = 1;
                            }
                            fds.put(taskName, num);
                            continue;
                        }
                        fds.put(taskName, 1);
                    }
                }
                catch (Exception e) {
                    MLog.error(TAG, e);
                }
            }
            YYTaskExecutor.postToMainThread(() -> callBack.onSuccess(fds));
        });
    }

    public static void getFilesDetailInfoStr(CallBack<String> callBack) {
        FdsController.getFilesDetailInfo(data -> {
            if (data == null || data.size() <= 0) {
                callBack.onSuccess("");
            }
            try {
                StringBuilder str = new StringBuilder("fdsWatch:");
                Set entries = data.entrySet();
                for (Map.Entry item : entries) {
                    str.append("fdname = ");
                    str.append((String)item.getKey());
                    str.append(" , fdcount = ");
                    str.append(item.getValue());
                    str.append("\n");
                }
                String result = str.toString();
                callBack.onSuccess(result);
            }
            catch (Throwable e) {
                MLog.error(TAG, e);
            }
            callBack.onSuccess("");
        });
    }

    public static void getFilesDetailInfoAndSave(final CallBack<String> callBack) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String logPath = FdsController.getFilesDetailInfoAndSaveSync();
                callBack.onSuccess(logPath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilesDetailInfoAndSaveSync() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(FdsController.getFDLogsPath());
            File fddir = FdsController.getFilesParent();
            int count = 0;
            for (File file : fddir.listFiles()) {
                Date lastModified = new Date(file.lastModified());
                String fileName = file.getCanonicalPath();
                if (Build.VERSION.SDK_INT >= 26 && Files.isSymbolicLink(file.toPath())) {
                    fileName = Files.readSymbolicLink(file.toPath()).toString();
                }
                String pattern = "MM-dd-yyyy HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                String date = simpleDateFormat.format(lastModified);
                String line = String.format("%s -> %s -> %s\n", file.getName(), date, fileName);
                os.write(line.getBytes());
                ++count;
            }
            os.write(("total fd count:" + count).getBytes());
            os.close();
        }
        catch (Exception e) {
            try {
                MLog.error((Object)TAG, "getFilesDetailInfoAndSave failed", e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(os);
                throw throwable;
            }
            IOUtils.safeClose(os);
        }
        IOUtils.safeClose(os);
        return FdsController.getFDLogsPath();
    }

    private static int getPid() {
        if (sPid == -1) {
            sPid = Process.myPid();
        }
        return sPid;
    }

    public static String readLimitsFile() {
        return YYFileUtils.getTxtFileContent(RuntimeContext.sApplicationContext, "/proc/" + FdsController.getPid() + "/limits");
    }

    private static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "safeClose failed", e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxFDCount() {
        File limitsFile;
        if (sMaxFDCount == -1 && (limitsFile = new File("/proc/" + FdsController.getPid() + "/limits")).exists() && limitsFile.isFile() && limitsFile.canRead()) {
            BufferedReader bufferReader = null;
            try {
                String line;
                FileInputStream fis = new FileInputStream(limitsFile);
                InputStreamReader inputStreamReader = new InputStreamReader(fis);
                bufferReader = new BufferedReader(inputStreamReader);
                String mMaxOpenFiles = "Max open files";
                do {
                    if ((line = bufferReader.readLine()) == null || !line.startsWith("Max open files")) continue;
                    String valuesStr = line.substring("Max open files".length()).trim();
                    String[] values = (valuesStr = valuesStr.replaceAll("\\s{1,}", " ")).split(" ");
                    if (values.length == 3) {
                        sMaxFDCount = Integer.parseInt(values[0]);
                        break;
                    }
                    MLog.error((Object)TAG, "getMaxFDCount, wrong value: " + line, new Object[0]);
                    break;
                } while (line != null);
                FdsController.safeClose(bufferReader);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, "getMaxFDCount failed", e, new Object[0]);
            }
            finally {
                FdsController.safeClose(bufferReader);
            }
        }
        return sMaxFDCount;
    }

    public static interface CallBack<T> {
        public void onSuccess(T var1);
    }
}

