/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifHeaderParser {
    private static final String TAG = "GifHeaderParser";
    private static final int MASK_INT_LOWEST_BYTE = 255;
    private static final int IMAGE_SEPARATOR = 44;
    private static final int EXTENSION_INTRODUCER = 33;
    private static final int TRAILER = 59;
    private static final int LABEL_GRAPHIC_CONTROL_EXTENSION = 249;
    private static final int LABEL_APPLICATION_EXTENSION = 255;
    private static final int LABEL_COMMENT_EXTENSION = 254;
    private static final int LABEL_PLAIN_TEXT_EXTENSION = 1;
    private static final int GCE_MASK_DISPOSAL_METHOD = 28;
    private static final int GCE_DISPOSAL_METHOD_SHIFT = 2;
    private static final int GCE_MASK_TRANSPARENT_COLOR_FLAG = 1;
    private static final int DESCRIPTOR_MASK_LCT_FLAG = 128;
    private static final int DESCRIPTOR_MASK_INTERLACE_FLAG = 64;
    private static final int DESCRIPTOR_MASK_LCT_SIZE = 7;
    private static final int LSD_MASK_GCT_FLAG = 128;
    private static final int LSD_MASK_GCT_SIZE = 7;
    static final int MIN_FRAME_DELAY = 2;
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block = new byte[256];
    private ByteBuffer rawData;
    private GifHeader header;
    private int blockSize = 0;

    public GifHeaderParser setData(@NonNull ByteBuffer data) {
        this.reset();
        this.rawData = data.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public GifHeaderParser setData(@Nullable byte[] data) {
        if (data != null) {
            this.setData(ByteBuffer.wrap(data));
        } else {
            this.rawData = null;
            this.header.status = 2;
        }
        return this;
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    @NonNull
    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (!this.err()) {
            this.readContents();
            if (this.header.frameCount < 0) {
                this.header.status = 1;
            }
        }
        return this.header;
    }

    public boolean isAnimated() {
        this.readHeader();
        if (!this.err()) {
            this.readContents(2);
        }
        return this.header.frameCount > 1;
    }

    private void readContents() {
        this.readContents(Integer.MAX_VALUE);
    }

    private void readContents(int maxFrames) {
        boolean done = false;
        block11: while (!done && !this.err() && this.header.frameCount <= maxFrames) {
            int code = this.read();
            switch (code) {
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    int extensionLabel = this.read();
                    switch (extensionLabel) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            StringBuilder app = new StringBuilder();
                            for (int i = 0; i < 11; ++i) {
                                app.append((char)this.block[i]);
                            }
                            if (app.toString().equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: {
                            this.skip();
                            continue block11;
                        }
                    }
                    this.skip();
                    continue block11;
                }
                case 59: {
                    done = true;
                    continue block11;
                }
            }
            this.header.status = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.header.currentFrame.dispose = (packed & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        this.header.currentFrame.transparency = (packed & 1) != 0;
        int delayInHundredthsOfASecond = this.readShort();
        if (delayInHundredthsOfASecond < 2) {
            delayInHundredthsOfASecond = 10;
        }
        this.header.currentFrame.delay = delayInHundredthsOfASecond * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    private void readBitmap() {
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int packed = this.read();
        boolean lctFlag = (packed & 0x80) != 0;
        int lctSize = (int)Math.pow(2.0, (packed & 7) + 1);
        this.header.currentFrame.interlace = (packed & 0x40) != 0;
        this.header.currentFrame.lct = (int[])(lctFlag ? this.readColorTable(lctSize) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        ++this.header.frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.header.loopCount = b2 << 8 | b1;
        } while (this.blockSize > 0 && !this.err());
    }

    private void readHeader() {
        StringBuilder id2 = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            id2.append((char)this.read());
        }
        if (!id2.toString().startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (this.header.gctFlag && !this.err()) {
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
        }
    }

    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int packed = this.read();
        this.header.gctFlag = (packed & 0x80) != 0;
        this.header.gctSize = (int)Math.pow(2.0, (packed & 7) + 1);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    @Nullable
    private int[] readColorTable(int nColors) {
        int nBytes = 3 * nColors;
        int[] tab = null;
        byte[] c = new byte[nBytes];
        try {
            this.rawData.get(c);
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < nColors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        catch (BufferUnderflowException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Format Error Reading Color Table", (Throwable)e);
            }
            this.header.status = 1;
        }
        return tab;
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    private void skip() {
        int blockSize;
        do {
            blockSize = this.read();
            int newPosition = Math.min(this.rawData.position() + blockSize, this.rawData.limit());
            this.rawData.position(newPosition);
        } while (blockSize > 0);
    }

    private void readBlock() {
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            int n;
            int count = 0;
            try {
                for (n = 0; n < this.blockSize; n += count) {
                    count = this.blockSize - n;
                    this.rawData.get(this.block, n, count);
                }
            }
            catch (Exception e) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Error Reading Block n: " + n + " count: " + count + " blockSize: " + this.blockSize), (Throwable)e);
                }
                this.header.status = 1;
            }
        }
    }

    private int read() {
        int currByte = 0;
        try {
            currByte = this.rawData.get() & 0xFF;
        }
        catch (Exception e) {
            this.header.status = 1;
        }
        return currByte;
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private boolean err() {
        return this.header.status != 0;
    }
}

