/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.cookie.store;

import com.yy.base.okhttp.cookie.store.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class MemoryCookieStore
implements CookieStore {
    private final HashMap<String, List<Cookie>> allCookies = new HashMap();

    @Override
    public void add(HttpUrl url, List<Cookie> cookies) {
        List<Cookie> oldCookies = this.allCookies.get(url.host());
        if (oldCookies != null) {
            Iterator<Cookie> itNew = cookies.iterator();
            Iterator<Cookie> itOld = oldCookies.iterator();
            while (itNew.hasNext()) {
                String va = itNew.next().name();
                while (va != null && itOld.hasNext()) {
                    String v = itOld.next().name();
                    if (v == null || !va.equals(v)) continue;
                    itOld.remove();
                }
            }
            oldCookies.addAll(cookies);
        } else {
            this.allCookies.put(url.host(), cookies);
        }
    }

    @Override
    public List<Cookie> get(HttpUrl uri) {
        List<Cookie> cookies = this.allCookies.get(uri.host());
        if (cookies == null) {
            cookies = new ArrayList<Cookie>();
            this.allCookies.put(uri.host(), cookies);
        }
        return cookies;
    }

    @Override
    public boolean removeAll() {
        this.allCookies.clear();
        return true;
    }

    @Override
    public List<Cookie> getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Set<String> httpUrls = this.allCookies.keySet();
        for (String url : httpUrls) {
            cookies.addAll((Collection<Cookie>)this.allCookies.get(url));
        }
        return cookies;
    }

    @Override
    public boolean remove(HttpUrl uri, Cookie cookie) {
        List<Cookie> cookies = this.allCookies.get(uri.host());
        if (cookie != null) {
            return cookies.remove(cookie);
        }
        return false;
    }
}

