/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo;

import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventReceiver;
import com.yy.base.event.core.EventReceiverList;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoHelper;
import com.yy.base.logger.MLog;

public class KvoEventReceiverList
extends EventReceiverList {
    private final KvoSource mKvoSource;

    KvoEventReceiverList(EventAction eventAction, KvoSource source) {
        super(eventAction);
        this.mKvoSource = source;
    }

    @Override
    protected void onAddBinding(EventReceiver eventReceiver) {
        KvoHelper.KvoField kvoField = this.mKvoSource.declaredKvoField((String)this.mEventAction.getAction());
        if (kvoField == null) {
            return;
        }
        try {
            Object currentValue = kvoField.field.get(this.mKvoSource);
            KvoEventIntent kvoEventIntent = KvoEventIntent.build(this.mKvoSource, kvoField.fieldAnnotation.name(), true);
            kvoEventIntent.setOldValue(currentValue);
            kvoEventIntent.setNewValue(currentValue);
            this.invokeEventToReceiver(kvoEventIntent, eventReceiver);
        }
        catch (IllegalAccessException e) {
            MLog.error((Object)"KvoEvent", "get field value failed : " + e.toString(), new Object[0]);
        }
    }
}

