/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.image.compress;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.yy.base.image.compress.Checker;
import com.yy.base.image.compress.InputStreamProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Engine {
    static final int DEFAULT_QUALITY = 80;
    private InputStreamProvider srcImg;
    private File tagImg;
    private int srcWidth;
    private int srcHeight;
    private boolean focusAlpha;
    private int compressQuality;

    Engine(InputStreamProvider srcImg, File tagImg, boolean focusAlpha, int compressQuality) throws IOException {
        this.tagImg = tagImg;
        this.srcImg = srcImg;
        this.focusAlpha = focusAlpha;
        this.compressQuality = compressQuality;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        InputStream inputStream = srcImg.open();
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        this.srcWidth = options.outWidth;
        this.srcHeight = options.outHeight;
        inputStream.close();
    }

    private int computeSize() {
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        int longSide = Math.max(this.srcWidth, this.srcHeight);
        int shortSide = Math.min(this.srcWidth, this.srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }

    private Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private Bitmap createScaleBitmap(Bitmap src, String originalPath) {
        int dstHeight;
        int dstWidth;
        if (src == null) {
            return null;
        }
        int longSide = Math.max(src.getWidth(), src.getHeight());
        if (longSide <= 4096) {
            return src;
        }
        float scale = (float)src.getWidth() / (float)src.getHeight();
        if (src.getWidth() > src.getHeight()) {
            dstWidth = 4096;
            dstHeight = (int)(4096.0f / scale);
        } else {
            dstHeight = 4096;
            dstWidth = (int)(4096.0f * scale);
        }
        Bitmap dst = Bitmap.createScaledBitmap((Bitmap)src, (int)dstWidth, (int)dstHeight, (boolean)false);
        if (src != dst) {
            src.recycle();
        }
        return dst;
    }

    File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        InputStream decodeStream = this.srcImg.open();
        Bitmap tagBitmap = BitmapFactory.decodeStream((InputStream)decodeStream, null, (BitmapFactory.Options)options);
        if ((tagBitmap = this.createScaleBitmap(tagBitmap, this.srcImg.getPath())) == null) {
            return new File("");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        tagBitmap = this.rotatingImage(tagBitmap, Checker.SINGLE.getOrientation(this.srcImg.getPath()));
        tagBitmap.compress(this.focusAlpha ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG, this.compressQuality, (OutputStream)stream);
        tagBitmap.recycle();
        FileOutputStream fos = new FileOutputStream(this.tagImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        decodeStream.close();
        return this.tagImg;
    }
}

