/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.request.RequestCall;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Response;

public enum Delivery {
    instance;

    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();

    public void execute(RequestCall requestCall, Callback callback) {
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        final int id2 = requestCall.getOkHttpRequest().getId();
        requestCall.getCall().enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                Delivery.this.sendFailResultCallback(call, e, finalCallback, id2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (call.isCanceled()) {
                        Delivery.this.sendFailResultCallback(call, new IOException("Canceled!"), finalCallback, id2);
                        return;
                    }
                    if (!finalCallback.validateReponse(response, id2)) {
                        Delivery.this.sendFailResultCallback(call, new IOException("request failed , reponse's code is : " + response.code()), finalCallback, id2);
                        return;
                    }
                    Object o = finalCallback.parseNetworkResponse(response, id2);
                    Delivery.this.sendSuccessResultCallback(o, finalCallback, id2);
                }
                catch (Exception e) {
                    Delivery.this.sendFailResultCallback(call, e, finalCallback, id2);
                }
                finally {
                    if (response.body() != null) {
                        response.body().close();
                    }
                }
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Exception e, final Callback callback, final int id2) {
        if (callback == null) {
            return;
        }
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, e, id2);
                callback.onAfter(id2);
            }
        }, 0L);
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback, final int id2) {
        if (callback == null) {
            return;
        }
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object, id2);
                callback.onAfter(id2);
            }
        }, 0L);
    }

    public void sendProgressCallback(final Callback callback, final float progress, final long total, final int id2) {
        if (callback == null) {
            return;
        }
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.inProgress(progress, total, id2);
            }
        }, 0L);
    }
}

