/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.network;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.JsonParseException;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.network.NetworkChangeListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.StreamResetException;
import org.apache.http.conn.ConnectTimeoutException;

public class NetworkUtils {
    public static final String GOOGLE_HOST = "www.google.com";
    public static final String FACEBOOK_HOST = "m.facebook.com";
    public static final String BAIDU_HOST = "www.baidu.com";
    public static final int NET_INVALID = 0;
    public static final int NET_WIFI = 1;
    public static final int NET_2G = 2;
    public static final int NET_3G = 3;
    public static final int NET_4G = 4;
    public static final int UNKNOW_NETWORK_TYPE = 5;
    public static final String NET_NAME_WIFI = "wifi";
    public static final String NET_NAME_2G = "2g";
    public static final String NET_NAME_3G = "3g";
    public static final String NET_NAME_4G = "4g";
    public static final String NET_NAME_UNKNOWN = "unknown";
    public static final String IPADDRESS_URL = "http://nstool.netease.com/";
    private static final String TAG = "NetworkUtils";
    private static final String HTTP_PAT = "(http://|https://){1}[\\w\\.\\-/:]+";
    private static final String IPADRRESS_PAT = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static volatile String sSimOperator;
    private static volatile String sSimOperatorName;
    private static BroadcastReceiver sNetWorkBroadcastReceiver;
    private static Runnable sGetNetInfoRunnable;
    private static Runnable sGetNetInfoRetryRunnable;
    private static volatile String sLocalIpAddress;
    private static volatile String sMac;
    private static volatile String sWifiMacAddr;
    private static volatile NetworkInfo sNetworkInfo;
    private static IpDnsInfo mIpDnsInfo;
    private static int sRetryTimes;
    private static volatile boolean sForeGround;
    private static volatile boolean sLastNetConnect;
    private static volatile boolean sLastNetConnectInit;
    private static volatile boolean sLastNetConnectNotifyChanged;
    private static Runnable sNotifyStatuRunnable;
    private static Runnable sStatuCheckRunnable;
    private static volatile boolean sSWitchCheckNetWhenNotConnect;
    private static ICheckNetWhenNotConnectCallBack sCheckNetWhenNotConnectCallBack;
    private static final List<NetworkChangeListener> mNetworkChangeListener;

    public static boolean isWifiActive(Context c) {
        if (c == null) {
            MLog.error((Object)"xuwakao", "isWifiActive is NULL", new Object[0]);
            return false;
        }
        NetworkInfo networkInfo = NetworkUtils.getActiveNetwork(c);
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static String getWifiName(Context c) {
        if (!NetworkUtils.isWifiActive(c)) {
            MLog.info(TAG, "wifi is not active", new Object[0]);
            return NET_NAME_UNKNOWN;
        }
        NetworkInfo networkInfo = NetworkUtils.getActiveNetwork(c);
        String name = networkInfo.getExtraInfo();
        MLog.info(TAG, "getWifiName, name:%s", name);
        return name;
    }

    public static boolean isTrafficActive(Context c) {
        return NetworkUtils.isNetworkStrictlyAvailable(c) && !NetworkUtils.isWifiActive(c);
    }

    public static boolean isNetworkStrictlyAvailable(Context c) {
        try {
            if (c == null) {
                MLog.error((Object)"xuwakao", "isNetworkStrictlyAvailable context is NULL", new Object[0]);
                return false;
            }
            NetworkInfo ni = NetworkUtils.getActiveNetwork(c);
            if (ni != null && ni.isAvailable() && ni.isConnected()) {
                NetworkUtils.notifyNetStatusIfNeed(true, ni);
                return true;
            }
            String info = null;
            info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected, " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
            MLog.error((Object)TAG, "isNetworkStrictlyAvailable network info" + info, new Object[0]);
            NetworkUtils.notifyNetStatusIfNeed(false, ni);
            return false;
        }
        catch (Throwable throwable) {
            MLog.error(TAG, throwable);
            return false;
        }
    }

    public static boolean pingHost(String host) {
        boolean result = false;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("ping -c 1 -w 10 " + host);
            proc.waitFor();
            result = proc.exitValue() == 0;
            MLog.error((Object)TAG, "pingHost %s result:%s", host, String.valueOf(result));
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Empty Catch on pingHost" + e, new Object[0]);
        }
        return result;
    }

    public static boolean isNetworkAvailable(Context c) {
        if (c == null) {
            return false;
        }
        boolean result = false;
        NetworkInfo ni = NetworkUtils.getActiveNetwork(c);
        if (ni != null && (ni.isConnected() || ni.isAvailable() && ni.isConnectedOrConnecting())) {
            result = true;
        } else {
            String info = null;
            info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected, " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
            MLog.error((Object)TAG, "isNetworkAvailable network info" + info, new Object[0]);
            result = false;
        }
        NetworkUtils.notifyNetStatusIfNeed(result, ni);
        return result;
    }

    public static void setCheckNetWhenNotConnect(boolean switchOn, ICheckNetWhenNotConnectCallBack calback) {
        sSWitchCheckNetWhenNotConnect = switchOn;
        sCheckNetWhenNotConnectCallBack = calback;
    }

    private static synchronized void notifyNetStatusIfNeed(final boolean connected, final NetworkInfo ni) {
        if (connected != sLastNetConnect) {
            sLastNetConnect = connected;
            if (sSWitchCheckNetWhenNotConnect && sLastNetConnectInit && sLastNetConnectNotifyChanged) {
                if (sNotifyStatuRunnable != null) {
                    YYTaskExecutor.removeRunnableFromMainThread(sNotifyStatuRunnable);
                }
                sNotifyStatuRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (sLastNetConnectNotifyChanged) {
                            MLog.error((Object)"NetWorkUtils", "notifyNetStatusIfNeed onNetworkChange!", new Object[0]);
                            NetworkUtils.onNetworkChange(NetworkUtils.getNetworkType(RuntimeContext.sApplicationContext), ni);
                            if (sCheckNetWhenNotConnectCallBack != null) {
                                sCheckNetWhenNotConnectCallBack.onNetStatusNotify(connected);
                            }
                        }
                        sNotifyStatuRunnable = null;
                    }
                };
                YYTaskExecutor.postToMainThread(sNotifyStatuRunnable, 3000L);
            }
        }
        if (sSWitchCheckNetWhenNotConnect) {
            NetworkUtils.checkNetWhenNotConnect();
        }
        sLastNetConnectInit = true;
    }

    private static synchronized void checkNetWhenNotConnect() {
        if (!sLastNetConnect && sSWitchCheckNetWhenNotConnect) {
            if (sStatuCheckRunnable != null) {
                YYTaskExecutor.removeTask(sStatuCheckRunnable);
            } else {
                sStatuCheckRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (sLastNetConnect || !sForeGround) {
                            return;
                        }
                        boolean result = false;
                        NetworkInfo networkInfo = NetworkUtils.getActiveNetworkFromService(RuntimeContext.sApplicationContext);
                        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info(NetworkUtils.TAG, "checkNetWhenNotConnect true", new Object[0]);
                            }
                            result = true;
                        }
                        if (RuntimeContext.sIsDebuggable && !result) {
                            MLog.info(NetworkUtils.TAG, "checkNetWhenNotConnect false", new Object[0]);
                        }
                        if (result) {
                            YYTaskExecutor.postToMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    NetworkUtils.onNetConnectChanged(RuntimeContext.sApplicationContext);
                                }
                            });
                            if (sCheckNetWhenNotConnectCallBack != null) {
                                sCheckNetWhenNotConnectCallBack.onNetErrorCheckCallBack(true);
                            }
                        } else {
                            YYTaskExecutor.execute(sStatuCheckRunnable, 5000L);
                            if (sCheckNetWhenNotConnectCallBack != null) {
                                sCheckNetWhenNotConnectCallBack.onNetErrorCheckCallBack(false);
                            }
                        }
                    }
                };
            }
            YYTaskExecutor.execute(sStatuCheckRunnable, 5000L);
        } else if (sLastNetConnect && sStatuCheckRunnable != null) {
            YYTaskExecutor.removeTask(sStatuCheckRunnable);
        }
    }

    public static void openNetworkConfig(Context c) {
        Intent i = null;
        if (Build.VERSION.SDK_INT > 10) {
            i = new Intent("android.settings.WIRELESS_SETTINGS");
        } else {
            i = new Intent();
            i.setClassName("com.android.settings", "com.android.settings.WirelessSettings");
            i.setAction("android.intent.action.MAIN");
        }
        try {
            c.startActivity(i);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "Empty Catch on openNetworkConfig" + e, new Object[0]);
        }
    }

    private static NetworkInfo getActiveNetworkFromService(Context c) {
        try {
            if (c != null && SystemServiceUtils.getConnectivityManager(c) != null) {
                return SystemServiceUtils.getConnectivityManager(c).getActiveNetworkInfo();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "error on getActiveNetworkInfo " + e, new Object[0]);
        }
        return null;
    }

    private static NetworkInfo getActiveNetwork(Context c) {
        NetworkInfo networkInfo = sNetworkInfo;
        if (networkInfo == null) {
            sNetworkInfo = NetworkUtils.getActiveNetworkFromService(c);
        } else {
            if (networkInfo.isAvailable() && networkInfo.isConnectedOrConnecting()) {
                return networkInfo;
            }
            sNetworkInfo = NetworkUtils.getActiveNetworkFromService(c);
        }
        return sNetworkInfo;
    }

    public static String getNetworkName(Context context) {
        String networkName = NET_NAME_UNKNOWN;
        switch (NetworkUtils.getNetworkType(context)) {
            case 1: {
                networkName = NET_NAME_WIFI;
                break;
            }
            case 2: {
                networkName = NET_NAME_2G;
                break;
            }
            case 3: {
                networkName = NET_NAME_3G;
                break;
            }
            case 4: {
                networkName = NET_NAME_4G;
                break;
            }
            case 5: {
                networkName = NET_NAME_UNKNOWN;
                break;
            }
        }
        return networkName;
    }

    public static String getNetworkNameByType(int type) {
        String networkName = NET_NAME_UNKNOWN;
        switch (type) {
            case 1: {
                networkName = NET_NAME_WIFI;
                break;
            }
            case 2: {
                networkName = NET_NAME_2G;
                break;
            }
            case 3: {
                networkName = NET_NAME_3G;
                break;
            }
            case 4: {
                networkName = NET_NAME_4G;
                break;
            }
            case 5: {
                networkName = NET_NAME_UNKNOWN;
                break;
            }
        }
        return networkName;
    }

    public static int getNetworkType(Context c) {
        int networkType = 5;
        NetworkInfo netInfo = NetworkUtils.getActiveNetwork(c);
        if (netInfo != null) {
            int type = netInfo.getType();
            if (type == 1 || type == 6) {
                networkType = 1;
            } else if (type == 0) {
                int subType = netInfo.getSubtype();
                if (subType == 7 || subType == 3 || subType == 14 || subType == 5 || subType == 6 || subType == 12 || subType == 8 || subType == 10 || subType == 15 || subType == 9) {
                    networkType = 3;
                } else if (subType == 1 || subType == 4 || subType == 2 || subType == 11) {
                    networkType = 2;
                } else if (subType == 13) {
                    networkType = 4;
                }
            }
        }
        return networkType;
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            int val = b & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    private static String getSimOperator(Context c) {
        return SystemServiceUtils.getTelephonyManager(c).getSimOperator();
    }

    private static String getNetOperatorNameInner(Context c) {
        return SystemServiceUtils.getTelephonyManager(c).getNetworkOperatorName();
    }

    public static String getOperator(Context c) {
        String sim;
        if (StringUtils.isEmpty(sSimOperator)) {
            sSimOperator = NetworkUtils.getSimOperator(c);
        }
        if (StringUtils.isEmpty(sim = sSimOperator)) {
            return "Unknown";
        }
        if (sim.startsWith("46003") || sim.startsWith("46005")) {
            return "CTL";
        }
        if (sim.startsWith("46001") || sim.startsWith("46006")) {
            return "UNICOM";
        }
        if (sim.startsWith("46000") || sim.startsWith("46002") || sim.startsWith("46007") || sim.startsWith("46020")) {
            return "CMCC";
        }
        return sim;
    }

    public static String getNetOperatorName(Context c) {
        String sim;
        if (StringUtils.isEmpty(sSimOperatorName)) {
            sSimOperatorName = NetworkUtils.getNetOperatorNameInner(c);
        }
        if (StringUtils.isEmpty(sim = sSimOperatorName)) {
            return "Unknown";
        }
        return sSimOperatorName;
    }

    public static void init(final Context context) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetworkUtils.registerNetWorkReceiver(context);
                NetworkUtils.isNetworkAvailable(context);
            }
        });
    }

    private static void registerNetWorkReceiver(Context context) {
        if (sNetWorkBroadcastReceiver == null) {
            sNetWorkBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkUtils.onNetConnectChanged(context);
                }
            };
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(sNetWorkBroadcastReceiver, filter);
        }
    }

    public static IpDnsInfo getIpDnsInfo() {
        return mIpDnsInfo;
    }

    private static String getHttpPat(String response) {
        Pattern pattern = Pattern.compile(HTTP_PAT);
        StringBuffer httpPatBuf = new StringBuffer();
        String url = null;
        MLog.verbose(TAG, "getHttpPat length:" + response.length(), new Object[0]);
        Matcher matcher = pattern.matcher(response);
        while (matcher.find()) {
            httpPatBuf.append(matcher.group());
        }
        url = httpPatBuf.toString();
        return url;
    }

    private static IpDnsInfo praseIpDnsInfo(String response) {
        MLog.verbose(TAG, "praseDns length:" + response.length(), new Object[0]);
        IpDnsInfo ipDnsInfo = new IpDnsInfo();
        Pattern pattern = Pattern.compile(IPADRRESS_PAT);
        Matcher matcher = pattern.matcher(response);
        StringBuffer buffer = new StringBuffer();
        boolean ipFlag = true;
        while (matcher.find()) {
            if (ipFlag) {
                ipDnsInfo.setIp(matcher.group());
                ipFlag = false;
                continue;
            }
            ipDnsInfo.setDns(matcher.group());
        }
        return ipDnsInfo;
    }

    private static void onNetConnectChanged(final Context context) {
        sRetryTimes = 0;
        if (sGetNetInfoRunnable == null) {
            sGetNetInfoRunnable = new Runnable(){

                @Override
                public void run() {
                    NetworkUtils.updateActiveNetwork(context);
                    sLocalIpAddress = NetworkUtils.getLocalIpAddressFromService();
                    sMac = NetworkUtils.getMacFromService(context);
                    String macFromService = NetworkUtils.getMacFromService(context);
                    if ("YY_FAKE_MAC".equals(macFromService)) {
                        sWifiMacAddr = "";
                    } else {
                        sWifiMacAddr = macFromService;
                    }
                    sLastNetConnectNotifyChanged = false;
                    if (NetworkUtils.isNetworkAvailable(context)) {
                        sGetNetInfoRunnable = null;
                        sRetryTimes = 0;
                        sGetNetInfoRetryRunnable = null;
                    } else if (sGetNetInfoRetryRunnable == null) {
                        sGetNetInfoRetryRunnable = new Runnable(){

                            @Override
                            public void run() {
                                NetworkUtils.updateActiveNetwork(RuntimeContext.sApplicationContext != null ? RuntimeContext.sApplicationContext : context);
                                sLastNetConnectNotifyChanged = false;
                                if (NetworkUtils.isNetworkAvailable(context)) {
                                    sGetNetInfoRunnable = null;
                                    sRetryTimes = 0;
                                    sGetNetInfoRetryRunnable = null;
                                    NetworkInfo ni = NetworkUtils.getActiveNetwork(context);
                                    if (sNotifyStatuRunnable != null) {
                                        YYTaskExecutor.removeRunnableFromMainThread(sNotifyStatuRunnable);
                                    }
                                    NetworkUtils.onNetworkChange(NetworkUtils.getNetworkType(context), ni);
                                } else {
                                    sRetryTimes++;
                                    if (sRetryTimes < 4) {
                                        YYTaskExecutor.execute(sGetNetInfoRetryRunnable, 5000 + (sRetryTimes > 0 ? sRetryTimes * 5000 : 0));
                                    } else {
                                        sNetworkInfo = null;
                                        sGetNetInfoRunnable = null;
                                        sGetNetInfoRetryRunnable = null;
                                        NetworkUtils.checkNetWhenNotConnect();
                                    }
                                }
                                if (sNetworkInfo != null) {
                                    MLog.info(NetworkUtils.TAG, "onNetConnectChanged retry:" + (sNetworkInfo.isConnected() || sNetworkInfo.isAvailable() && sNetworkInfo.isConnectedOrConnecting()), new Object[0]);
                                } else {
                                    MLog.info(NetworkUtils.TAG, "onNetConnectChanged:", new Object[0]);
                                }
                                sLastNetConnectNotifyChanged = true;
                            }
                        };
                        YYTaskExecutor.execute(sGetNetInfoRetryRunnable, 5000 + (sRetryTimes > 0 ? sRetryTimes * 5000 : 0));
                    }
                    if (sNotifyStatuRunnable != null) {
                        YYTaskExecutor.removeRunnableFromMainThread(sNotifyStatuRunnable);
                    }
                    NetworkInfo ni = NetworkUtils.getActiveNetwork(context);
                    NetworkUtils.onNetworkChange(NetworkUtils.getNetworkType(context), ni);
                    sLastNetConnectNotifyChanged = true;
                    if (sNetworkInfo != null) {
                        MLog.info(NetworkUtils.TAG, "onNetConnectChanged:" + (sNetworkInfo.isConnected() || sNetworkInfo.isAvailable() && sNetworkInfo.isConnectedOrConnecting()), new Object[0]);
                    } else {
                        MLog.info(NetworkUtils.TAG, "onNetConnectChanged:", new Object[0]);
                    }
                }
            };
            YYTaskExecutor.execute(sGetNetInfoRunnable);
        } else {
            YYTaskExecutor.removeTask(sGetNetInfoRetryRunnable);
            YYTaskExecutor.removeTask(sGetNetInfoRunnable);
            YYTaskExecutor.execute(sGetNetInfoRunnable);
        }
    }

    private static void updateActiveNetwork(Context context) {
        if (context == null) {
            return;
        }
        sNetworkInfo = NetworkUtils.getActiveNetworkFromService(context);
    }

    public static String getInetAddress(String host) {
        String ipaddress = "";
        InetAddress returnStr1 = null;
        try {
            returnStr1 = InetAddress.getByName(host);
            ipaddress = returnStr1.getHostAddress();
        }
        catch (UnknownHostException e) {
            MLog.error((Object)TAG, "printStackTrace", e, new Object[0]);
            return ipaddress;
        }
        return ipaddress;
    }

    @Nullable
    private static String getLocalIpAddressFromService() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            MLog.error((Object)"NetworkUtils getLocalIpAddress:", ex.toString(), new Object[0]);
        }
        return null;
    }

    private static String getMacFromService(Context c) {
        try {
            WifiInfo connectionInfo;
            String macAddress = NetworkUtils.getMacAddrV23(c);
            if (!TextUtils.isEmpty((CharSequence)macAddress)) {
                return macAddress;
            }
            if (SystemServiceUtils.getWifiManager(c) != null && (connectionInfo = SystemServiceUtils.getWifiManager(c).getConnectionInfo()) != null && (macAddress = connectionInfo.getMacAddress()) != null) {
                return macAddress;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "getMac error! " + throwable, new Object[0]);
        }
        return "YY_FAKE_MAC";
    }

    @Nullable
    public static String getLocalIpAddress() {
        if (sLocalIpAddress != null) {
            return sLocalIpAddress;
        }
        sLocalIpAddress = NetworkUtils.getLocalIpAddressFromService();
        return sLocalIpAddress;
    }

    public static String getWifiIp(Context c) {
        String ip = NetworkUtils.getWifiIpFromService(c);
        if (!"YY_FAKE_WIFI_IP".equals(ip)) {
            return ip;
        }
        return "";
    }

    private static String getWifiIpFromService(Context c) {
        try {
            WifiInfo connectionInfo;
            if (SystemServiceUtils.getWifiManager(c) != null && (connectionInfo = SystemServiceUtils.getWifiManager(c).getConnectionInfo()) != null) {
                int ipAddress = connectionInfo.getIpAddress();
                return NetworkUtils.getIpString(ipAddress);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "getWifiIp error! " + throwable, new Object[0]);
        }
        return "YY_FAKE_WIFI_IP";
    }

    public static String getIpString(int ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip & 0xFF);
        sb.append(".");
        sb.append(ip >>> 8 & 0xFF);
        sb.append(".");
        sb.append(ip >>> 16 & 0xFF);
        sb.append(".");
        sb.append(ip >>> 24 & 0xFF);
        return sb.toString();
    }

    public static String getIpString(byte[] ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip[0] & 0xFF);
        sb.append(".");
        sb.append(ip[1] & 0xFF);
        sb.append(".");
        sb.append(ip[2] & 0xFF);
        sb.append(".");
        sb.append(ip[3] & 0xFF);
        return sb.toString();
    }

    public static String getMac(Context c) {
        return NetworkUtils.getMacByDefault(c);
    }

    private static String getMacByDefault(Context c) {
        if (sMac != null) {
            return sMac;
        }
        sMac = NetworkUtils.getMacFromService(c);
        return sMac;
    }

    public static String getWifiMacAddr(Context c) {
        if (sWifiMacAddr != null) {
            return sWifiMacAddr;
        }
        String macFromService = NetworkUtils.getMacFromService(c);
        sWifiMacAddr = "YY_FAKE_MAC".equals(macFromService) ? "" : macFromService;
        return sWifiMacAddr;
    }

    public static boolean isValidMac(String mac) {
        return !TextUtils.isEmpty((CharSequence)mac) && !mac.equalsIgnoreCase("02:00:00:00:00:00");
    }

    private static String getMacAddrV23(Context c) {
        String mac21;
        String mMacAddress = null;
        try {
            if (SystemServiceUtils.getWifiManager(c) != null) {
                WifiInfo connectionInfo = SystemServiceUtils.getWifiManager(c).getConnectionInfo();
                mMacAddress = connectionInfo == null ? null : connectionInfo.getMacAddress();
            }
        }
        catch (Throwable var4) {
            MLog.error((Object)"getMacAddrV23", "exception on getMacAddr : %s", var4);
        }
        if (!NetworkUtils.isValidMac(mMacAddress) && NetworkUtils.isValidMac(mac21 = NetworkUtils.getMacAddr2())) {
            mMacAddress = mac21;
        }
        return mMacAddress;
    }

    @SuppressLint(value={"NewApi"})
    private static String getMacAddr2() {
        String address = null;
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (true) {
                    String var10;
                    byte[] by;
                    if (!e.hasMoreElements()) {
                        return address;
                    }
                    NetworkInterface netWork = e.nextElement();
                    if (!netWork.getName().equalsIgnoreCase("wlan0") || (by = netWork.getHardwareAddress()) == null || by.length == 0) continue;
                    StringBuilder builder = new StringBuilder();
                    byte[] mac = by;
                    int var6 = by.length;
                    for (int var7 = 0; var7 < var6; ++var7) {
                        byte b = mac[var7];
                        builder.append(StringUtils.formatWitUSLocal("%02X:", b));
                    }
                    if (builder.length() > 0) {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                    address = var10 = builder.toString();
                }
            }
        }
        catch (Throwable var9) {
            MLog.error((Object)"getMacAddr2", "exception on getMacAddr2 : %s", var9);
        }
        return address;
    }

    public static void showNetworkConfigDialog(Context context) {
    }

    public static synchronized void addNetworkChangeListener(NetworkChangeListener listener) {
        if (listener != null && !mNetworkChangeListener.contains(listener)) {
            mNetworkChangeListener.add(listener);
        }
    }

    public static synchronized void removeNetworkChangeListener(NetworkChangeListener listener) {
        mNetworkChangeListener.remove(listener);
    }

    private static synchronized void onNetworkChange(int type, NetworkInfo info) {
        for (NetworkChangeListener listener : mNetworkChangeListener) {
            if (listener == null) continue;
            listener.onChange(type, info);
        }
        if (info != null) {
            MLog.error((Object)"NetWorkUtils", "onNetworkChange connect %d type %d!", info.isConnected() ? 1 : 0, info.getType());
        } else {
            MLog.error((Object)"NetWorkUtils", "onNetworkChange connect 0 type -1!", new Object[0]);
        }
    }

    public static void enterToForeground() {
        sForeGround = true;
        NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        NetworkUtils.checkNetWhenNotConnect();
    }

    public static void enterToBackground() {
        sForeGround = false;
    }

    public static int getWifiStrength(Context context) {
        WifiManager wifiManager = SystemServiceUtils.getWifiManager(context);
        WifiInfo info = null;
        int strength = 0;
        try {
            info = wifiManager.getConnectionInfo();
            if (info.getBSSID() != null) {
                strength = WifiManager.calculateSignalLevel((int)info.getRssi(), (int)5);
            }
        }
        catch (Throwable e) {
            MLog.error(TAG, e);
        }
        return strength;
    }

    public static String getWifiSSid(Context context) {
        WifiManager wifiManager = SystemServiceUtils.getWifiManager(context);
        WifiInfo info = null;
        String ssid = "";
        try {
            info = wifiManager.getConnectionInfo();
            ssid = info.getSSID();
        }
        catch (Throwable e) {
            MLog.error(TAG, e);
        }
        return ssid;
    }

    public static int getWsRpcRequestTimeoutCode() {
        return 99;
    }

    public static int getErrorCodeByExc(Throwable e) {
        int errorCode = -2;
        if (e != null) {
            if (!NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext)) {
                errorCode = 250;
            } else if (e instanceof SocketTimeoutException) {
                errorCode = 1;
            } else if (e instanceof ConnectTimeoutException) {
                errorCode = 9;
            } else if (e instanceof UnknownHostException) {
                errorCode = 2;
            } else if (e instanceof ConnectException) {
                errorCode = 3;
            } else if (e instanceof NoRouteToHostException) {
                errorCode = 7;
            } else if (e instanceof SocketException) {
                errorCode = 4;
                String msg = e.getMessage();
                if (StringUtils.isNotEmpty(msg) && msg.contains("No route to ")) {
                    errorCode = 7;
                }
            } else if (e instanceof SSLPeerUnverifiedException) {
                errorCode = 5;
            } else if (e instanceof SSLHandshakeException) {
                errorCode = 6;
            } else if (e instanceof ConnectionShutdownException) {
                errorCode = 8;
            } else if (e instanceof ProtocolException) {
                errorCode = 15;
            } else if (e instanceof RouteException) {
                errorCode = 7;
            } else if (e instanceof UnknownServiceException) {
                errorCode = 60;
            } else if (e instanceof IOException) {
                errorCode = 50;
                String msg = e.getMessage();
                if (e instanceof StreamResetException) {
                    errorCode = 11;
                } else if (StringUtils.isNotEmpty(msg)) {
                    errorCode = 50;
                    if (msg.contains("stream closed")) {
                        errorCode = 10;
                    } else if (msg.contains("Canceled")) {
                        errorCode = 97;
                    }
                }
            } else if (e instanceof JsonParseException) {
                errorCode = 98;
            }
        }
        return errorCode;
    }

    public static boolean isErrorNeedRetry(Throwable e) {
        boolean netOk = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        return !(e != null && netOk ? e instanceof UnknownHostException || e instanceof NoRouteToHostException : !netOk);
    }

    static {
        mIpDnsInfo = new IpDnsInfo();
        sRetryTimes = 0;
        sForeGround = false;
        sLastNetConnect = false;
        sLastNetConnectInit = false;
        sLastNetConnectNotifyChanged = true;
        sSWitchCheckNetWhenNotConnect = false;
        mNetworkChangeListener = new CopyOnWriteArrayList<NetworkChangeListener>();
    }

    public class NetErrorType {
        public static final int PARSE_ERROR = -1;
        public static final int NATIVE_NOT_NORMAL_EXCEPTION = -2;
        public static final int NET_OK = 0;
        public static final int SocketTimeout = 1;
        public static final int UnknownHost = 2;
        public static final int Connect = 3;
        public static final int ConnectTimeout = 9;
        public static final int SocketException = 4;
        public static final int SSLPeerUnverified = 5;
        public static final int SSLHandshake = 6;
        public static final int NoRouteToHost = 7;
        public static final int ConnectionShutdown = 8;
        public static final int IOException = 50;
        public static final int StreamClosed = 10;
        public static final int StreamReset = 11;
        public static final int ProtocolError = 15;
        public static final int UnknownServiceError = 60;
        public static final int CANCEL = 97;
        public static final int DataError = 98;
        public static final int Timeout = 99;
        public static final int NoImportantData = 100;
        public static final int NO_NET = 250;
        public static final int WS_NOT_CONNECT = 251;
        public static final int SERVER_START_ERROR_CODE = 252;
        public static final int URL_ILLEGAL = -99;
        public static final int ERROR__FILE_MD5_ERROR = 76;
        public static final int WS_RPC_REQUEST_RESULT_CODE_ERROR = 96;
        public static final int WS_RPC_REQUEST_RESULT_ONRESPONSE_SOME_ERROR = -1;
    }

    public static interface ICheckNetWhenNotConnectCallBack {
        public void onNetStatusNotify(boolean var1);

        public void onNetErrorCheckCallBack(boolean var1);
    }

    public static class IpDnsInfo {
        private String mIP = "";
        private String mDNS = "";

        public String getIp() {
            return this.mIP;
        }

        public void setIp(String ip) {
            this.mIP = ip;
        }

        public String getDns() {
            return this.mDNS;
        }

        public void setDns(String dns) {
            this.mDNS = dns;
        }
    }

    public static class ChinaOperator {
        public static final String CMCC = "CMCC";
        public static final String CTL = "CTL";
        public static final String UNICOM = "UNICOM";
        public static final String UNKNOWN = "Unknown";
    }
}

