/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.widget.TextView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import java.util.Hashtable;

public class FontUtils {
    private static final String TAG = "FontUtils";
    private static Hashtable<FontType, Typeface> fontCache = new Hashtable();

    public static void setFontType(TextView textView, Typeface typeface) {
        textView.setTypeface(typeface);
    }

    public static Typeface getTypeFace(Context context, FontType fontType) {
        Typeface typeface = fontCache.get((Object)fontType);
        try {
            if (typeface == null) {
                switch (fontType) {
                    case DINMittelschriftAlternate: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/DINMittelschrift-Alternate.ttf");
                        break;
                    }
                    case RefrigeratorDeluxeHeavy: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Refrigerator_Deluxe_Heavy.ttf");
                        break;
                    }
                    case WenYueXinQingNianTi: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/WenYue-XinQingNianTi-NC-W8_2.ttf");
                        break;
                    }
                    case CaptainAmerica: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/CAPTAIN_AMERICA.ttf");
                        break;
                    }
                    case HagoNumber: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/HagoNumber.ttf");
                        break;
                    }
                    case HagoTitle: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/HagoTitle.ttf");
                        break;
                    }
                    case ROBOTO_REGULAR: {
                        typeface = Typeface.SANS_SERIF;
                        break;
                    }
                    case ROBOTO_MEDIUM: {
                        typeface = Typeface.create((String)"sans-serif-medium", (int)0);
                        break;
                    }
                }
                if (typeface != null) {
                    fontCache.put(fontType, typeface);
                } else {
                    MLog.info(TAG, "[getTypeFace] can not get font from asset,fonttype=" + (Object)((Object)fontType), new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "[getTypeFace] exception=" + e + ",fonttype=" + (Object)((Object)fontType), new Object[0]);
            return null;
        }
        return typeface;
    }

    public static Typeface getTypeFace(FontType fontType) {
        if (FontUtils.isUnSupportLanguage()) {
            return Typeface.DEFAULT;
        }
        return FontUtils.getTypeFace(RuntimeContext.sApplicationContext, fontType);
    }

    private static boolean isUnSupportLanguage() {
        return LanguageUtils.isRussian() || LanguageUtils.isHindi() || LanguageUtils.isVietnamese();
    }

    public static enum FontType {
        DINMittelschriftAlternate,
        RefrigeratorDeluxeHeavy,
        WenYueXinQingNianTi,
        CaptainAmerica,
        HagoNumber,
        HagoTitle,
        ROBOTO_REGULAR,
        ROBOTO_MEDIUM;

    }
}

