/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.drawable.DrawableDecoderCompat;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.request.transition.TransitionFactory;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.List;
import java.util.concurrent.Executor;

public final class SingleRequest<R>
implements Request,
SizeReadyCallback,
ResourceCallback,
FactoryPools.Poolable {
    private static final String TAG = "Request";
    private static final String GLIDE_TAG = "Glide";
    private static final Pools.Pool<SingleRequest<?>> POOL = FactoryPools.threadSafe(150, new FactoryPools.Factory<SingleRequest<?>>(){

        @Override
        public SingleRequest<?> create() {
            return new SingleRequest();
        }
    });
    private boolean isCallingCallbacks;
    private static final boolean IS_VERBOSE_LOGGABLE = Log.isLoggable((String)"Request", (int)2);
    @Nullable
    private final String tag = IS_VERBOSE_LOGGABLE ? String.valueOf(super.hashCode()) : null;
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    @Nullable
    private RequestListener<R> targetListener;
    private RequestCoordinator requestCoordinator;
    private Context context;
    private GlideContext glideContext;
    @Nullable
    private Object model;
    private Class<R> transcodeClass;
    private BaseRequestOptions<?> requestOptions;
    private int overrideWidth;
    private int overrideHeight;
    private Priority priority;
    private Target<R> target;
    @Nullable
    private List<RequestListener<R>> requestListeners;
    private Engine engine;
    private TransitionFactory<? super R> animationFactory;
    private Executor callbackExecutor;
    private Resource<R> resource;
    private Engine.LoadStatus loadStatus;
    private long startTime;
    @GuardedBy(value="this")
    private Status status;
    private Drawable errorDrawable;
    private Drawable placeholderDrawable;
    private Drawable fallbackDrawable;
    private int width;
    private int height;
    @Nullable
    private RuntimeException requestOrigin;

    public static <R> SingleRequest<R> obtain(Context context, GlideContext glideContext, Object model, Class<R> transcodeClass, BaseRequestOptions<?> requestOptions, int overrideWidth, int overrideHeight, Priority priority, Target<R> target, RequestListener<R> targetListener, @Nullable List<RequestListener<R>> requestListeners, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> animationFactory, Executor callbackExecutor) {
        SingleRequest<R> request = (SingleRequest<R>)POOL.acquire();
        if (request == null) {
            request = new SingleRequest<R>();
        }
        super.init(context, glideContext, model, transcodeClass, requestOptions, overrideWidth, overrideHeight, priority, target, targetListener, requestListeners, requestCoordinator, engine, animationFactory, callbackExecutor);
        return request;
    }

    SingleRequest() {
    }

    private synchronized void init(Context context, GlideContext glideContext, Object model, Class<R> transcodeClass, BaseRequestOptions<?> requestOptions, int overrideWidth, int overrideHeight, Priority priority, Target<R> target, RequestListener<R> targetListener, @Nullable List<RequestListener<R>> requestListeners, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> animationFactory, Executor callbackExecutor) {
        this.context = context;
        this.glideContext = glideContext;
        this.model = model;
        this.transcodeClass = transcodeClass;
        this.requestOptions = requestOptions;
        this.overrideWidth = overrideWidth;
        this.overrideHeight = overrideHeight;
        this.priority = priority;
        this.target = target;
        this.targetListener = targetListener;
        this.requestListeners = requestListeners;
        this.requestCoordinator = requestCoordinator;
        this.engine = engine;
        this.animationFactory = animationFactory;
        this.callbackExecutor = callbackExecutor;
        this.status = Status.PENDING;
        if (this.requestOrigin == null && glideContext.isLoggingRequestOriginsEnabled()) {
            this.requestOrigin = new RuntimeException("Glide request origin trace");
        }
    }

    @Override
    @NonNull
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    @Override
    public synchronized void recycle() {
        this.assertNotCallingCallbacks();
        this.context = null;
        this.glideContext = null;
        this.model = null;
        this.transcodeClass = null;
        this.requestOptions = null;
        this.overrideWidth = -1;
        this.overrideHeight = -1;
        this.target = null;
        this.requestListeners = null;
        this.targetListener = null;
        this.requestCoordinator = null;
        this.animationFactory = null;
        this.loadStatus = null;
        this.errorDrawable = null;
        this.placeholderDrawable = null;
        this.fallbackDrawable = null;
        this.width = -1;
        this.height = -1;
        this.requestOrigin = null;
        POOL.release((Object)this);
    }

    @Override
    public synchronized void begin() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        this.startTime = LogTime.getLogTime();
        if (this.model == null) {
            if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
                this.width = this.overrideWidth;
                this.height = this.overrideHeight;
            }
            int logLevel = this.getFallbackDrawable() == null ? 5 : 3;
            this.onLoadFailed(new GlideException("Received null model"), logLevel);
            return;
        }
        if (this.status == Status.RUNNING) {
            throw new IllegalArgumentException("Cannot restart a running request");
        }
        if (this.status == Status.COMPLETE) {
            this.onResourceReady(this.resource, DataSource.MEMORY_CACHE, new PerformanceData(-1.0, -1.0));
            return;
        }
        this.status = Status.WAITING_FOR_SIZE;
        if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
            this.onSizeReady(this.overrideWidth, this.overrideHeight);
        } else {
            this.target.getSize(this);
        }
        if ((this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE) && this.canNotifyStatusChanged()) {
            this.target.onLoadStarted(this.getPlaceholderDrawable());
        }
        if (IS_VERBOSE_LOGGABLE) {
            this.logV("finished run method in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    private void cancel() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        this.target.removeCallback(this);
        if (this.loadStatus != null) {
            this.loadStatus.cancel();
            this.loadStatus = null;
        }
    }

    private void assertNotCallingCallbacks() {
        if (this.isCallingCallbacks) {
            throw new IllegalStateException("You can't start or clear loads in RequestListener or Target callbacks. If you're trying to start a fallback request when a load fails, use RequestBuilder#error(RequestBuilder). Otherwise consider posting your into() or clear() calls to the main thread using a Handler instead.");
        }
    }

    @Override
    public synchronized void clear() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        if (this.status == Status.CLEARED) {
            return;
        }
        this.cancel();
        if (this.resource != null) {
            this.releaseResource(this.resource);
        }
        if (this.canNotifyCleared()) {
            this.target.onLoadCleared(this.getPlaceholderDrawable());
        }
        this.status = Status.CLEARED;
    }

    private void releaseResource(Resource<?> resource) {
        this.engine.release(resource);
        this.resource = null;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.status == Status.COMPLETE;
    }

    @Override
    public synchronized boolean isResourceSet() {
        return this.isComplete();
    }

    @Override
    public synchronized boolean isCleared() {
        return this.status == Status.CLEARED;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.status == Status.FAILED;
    }

    private Drawable getErrorDrawable() {
        if (this.errorDrawable == null) {
            this.errorDrawable = this.requestOptions.getErrorPlaceholder();
            if (this.errorDrawable == null && this.requestOptions.getErrorId() > 0) {
                this.errorDrawable = this.loadDrawable(this.requestOptions.getErrorId());
            }
        }
        return this.errorDrawable;
    }

    private Drawable getPlaceholderDrawable() {
        if (this.placeholderDrawable == null) {
            this.placeholderDrawable = this.requestOptions.getPlaceholderDrawable();
            if (this.placeholderDrawable == null && this.requestOptions.getPlaceholderId() > 0) {
                this.placeholderDrawable = this.loadDrawable(this.requestOptions.getPlaceholderId());
            }
        }
        return this.placeholderDrawable;
    }

    private Drawable getFallbackDrawable() {
        if (this.fallbackDrawable == null) {
            this.fallbackDrawable = this.requestOptions.getFallbackDrawable();
            if (this.fallbackDrawable == null && this.requestOptions.getFallbackId() > 0) {
                this.fallbackDrawable = this.loadDrawable(this.requestOptions.getFallbackId());
            }
        }
        return this.fallbackDrawable;
    }

    private Drawable loadDrawable(@DrawableRes int resourceId) {
        Resources.Theme theme = this.requestOptions.getTheme() != null ? this.requestOptions.getTheme() : this.context.getTheme();
        return DrawableDecoderCompat.getDrawable((Context)this.glideContext, resourceId, theme);
    }

    private synchronized void setErrorPlaceholder() {
        if (!this.canNotifyStatusChanged()) {
            return;
        }
        Drawable error = null;
        if (this.model == null) {
            error = this.getFallbackDrawable();
        }
        if (error == null) {
            error = this.getErrorDrawable();
        }
        if (error == null) {
            error = this.getPlaceholderDrawable();
        }
        this.target.onLoadFailed(error);
    }

    @Override
    public synchronized void onSizeReady(int width, int height) {
        this.stateVerifier.throwIfRecycled();
        if (IS_VERBOSE_LOGGABLE) {
            this.logV("Got onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
        if (this.status != Status.WAITING_FOR_SIZE) {
            return;
        }
        this.status = Status.RUNNING;
        float sizeMultiplier = this.requestOptions.getSizeMultiplier();
        this.width = SingleRequest.maybeApplySizeMultiplier(width, sizeMultiplier);
        this.height = SingleRequest.maybeApplySizeMultiplier(height, sizeMultiplier);
        if (IS_VERBOSE_LOGGABLE) {
            this.logV("finished setup for calling load in " + LogTime.getElapsedMillis(this.startTime));
        }
        this.loadStatus = this.engine.load(this.glideContext, this.model, this.requestOptions.getSignature(), this.width, this.height, this.requestOptions.getResourceClass(), this.transcodeClass, this.priority, this.requestOptions.getDiskCacheStrategy(), this.requestOptions.getTransformations(), this.requestOptions.isTransformationRequired(), this.requestOptions.isScaleOnlyOrNoTransform(), this.requestOptions.getOptions(), this.requestOptions.isMemoryCacheable(), this.requestOptions.getUseUnlimitedSourceGeneratorsPool(), this.requestOptions.getUseAnimationPool(), this.requestOptions.getOnlyRetrieveFromCache(), this, this.callbackExecutor);
        if (this.status != Status.RUNNING) {
            this.loadStatus = null;
        }
        if (IS_VERBOSE_LOGGABLE) {
            this.logV("finished onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    private static int maybeApplySizeMultiplier(int size, float sizeMultiplier) {
        return size == Integer.MIN_VALUE ? size : Math.round(sizeMultiplier * (float)size);
    }

    private boolean canSetResource() {
        return this.requestCoordinator == null || this.requestCoordinator.canSetImage(this);
    }

    private boolean canNotifyCleared() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyCleared(this);
    }

    private boolean canNotifyStatusChanged() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyStatusChanged(this);
    }

    private boolean isFirstReadyResource() {
        return this.requestCoordinator == null || !this.requestCoordinator.isAnyResourceSet();
    }

    private void notifyLoadSuccess() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestSuccess(this);
        }
    }

    private void notifyLoadFailed() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestFailed(this);
        }
    }

    @Override
    public void onResourceReady(Resource<?> resource, DataSource dataSource, PerformanceData performanceData) {
        this.stateVerifier.throwIfRecycled();
        this.loadStatus = null;
        if (resource == null) {
            GlideException exception = new GlideException("Expected to receive a Resource<R> with an object of " + this.transcodeClass + " inside, but instead got null.");
            this.onLoadFailed(exception);
            return;
        }
        Object received = resource.get();
        if (received == null || !this.transcodeClass.isAssignableFrom(received.getClass())) {
            this.releaseResource(resource);
            GlideException exception = new GlideException("Expected to receive an object of " + this.transcodeClass + " but instead got " + (received != null ? received.getClass() : "") + "{" + received + "} inside Resource{" + resource + "}." + (received != null ? "" : " To indicate failure return a null Resource object, rather than a Resource object containing null data."));
            this.onLoadFailed(exception);
            return;
        }
        if (!this.canSetResource()) {
            this.releaseResource(resource);
            this.status = Status.COMPLETE;
            return;
        }
        this.onResourceReady(resource, received, dataSource, performanceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onResourceReady(Resource<R> resource, R result, DataSource dataSource, PerformanceData performanceData) {
        boolean isFirstResource = this.isFirstReadyResource();
        this.status = Status.COMPLETE;
        this.resource = resource;
        if (this.glideContext.getLogLevel() <= 3) {
            Log.d((String)GLIDE_TAG, (String)("Finished loading " + result.getClass().getSimpleName() + " from " + (Object)((Object)dataSource) + " for " + this.model + " with size [" + this.width + "x" + this.height + "] in " + LogTime.getElapsedMillis(this.startTime) + " ms"));
        }
        this.isCallingCallbacks = true;
        try {
            boolean anyListenerHandledUpdatingTarget = false;
            if (this.requestListeners != null) {
                for (RequestListener<R> listener : this.requestListeners) {
                    anyListenerHandledUpdatingTarget |= listener.onResourceReady(result, this.model, this.target, dataSource, isFirstResource, performanceData);
                }
            }
            if (!(anyListenerHandledUpdatingTarget |= this.targetListener != null && this.targetListener.onResourceReady(result, this.model, this.target, dataSource, isFirstResource, performanceData))) {
                Transition<? super R> animation = this.animationFactory.build(dataSource, isFirstResource);
                this.target.onResourceReady((R)result, animation);
            }
        }
        finally {
            this.isCallingCallbacks = false;
        }
        this.notifyLoadSuccess();
    }

    @Override
    public synchronized void onLoadFailed(GlideException e) {
        this.onLoadFailed(e, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onLoadFailed(GlideException e, int maxLogLevel) {
        this.stateVerifier.throwIfRecycled();
        e.setOrigin(this.requestOrigin);
        int logLevel = this.glideContext.getLogLevel();
        if (logLevel <= maxLogLevel) {
            Log.w((String)GLIDE_TAG, (String)("Load failed for " + this.model + " with size [" + this.width + "x" + this.height + "]"), (Throwable)e);
            if (logLevel <= 4) {
                e.logRootCauses(GLIDE_TAG);
            }
        }
        this.loadStatus = null;
        this.status = Status.FAILED;
        this.isCallingCallbacks = true;
        try {
            boolean anyListenerHandledUpdatingTarget = false;
            if (this.requestListeners != null) {
                for (RequestListener<R> listener : this.requestListeners) {
                    anyListenerHandledUpdatingTarget |= listener.onLoadFailed(e, this.model, this.target, this.isFirstReadyResource());
                }
            }
            if (!(anyListenerHandledUpdatingTarget |= this.targetListener != null && this.targetListener.onLoadFailed(e, this.model, this.target, this.isFirstReadyResource()))) {
                this.setErrorPlaceholder();
            }
        }
        finally {
            this.isCallingCallbacks = false;
        }
        this.notifyLoadFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEquivalentTo(Request o) {
        if (o instanceof SingleRequest) {
            SingleRequest that;
            SingleRequest singleRequest = that = (SingleRequest)o;
            synchronized (singleRequest) {
                return this.overrideWidth == that.overrideWidth && this.overrideHeight == that.overrideHeight && Util.bothModelsNullEquivalentOrEquals(this.model, that.model) && this.transcodeClass.equals(that.transcodeClass) && this.requestOptions.equals(that.requestOptions) && this.priority == that.priority && this.listenerCountEquals(that);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean listenerCountEquals(SingleRequest<?> other) {
        SingleRequest<?> singleRequest = other;
        synchronized (singleRequest) {
            int firstListenerCount = this.requestListeners == null ? 0 : this.requestListeners.size();
            int secondListenerCount = other.requestListeners == null ? 0 : other.requestListeners.size();
            return firstListenerCount == secondListenerCount;
        }
    }

    private void logV(String message) {
        Log.v((String)TAG, (String)(message + " this: " + this.tag));
    }

    private static enum Status {
        PENDING,
        RUNNING,
        WAITING_FOR_SIZE,
        COMPLETE,
        FAILED,
        CLEARED;

    }
}

