/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.env;

import android.content.Context;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Registry;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.engine.cache.DiskLruCacheFactory;
import com.bumptech.glide.module.AppGlideModule;
import com.bumptech.glide.request.target.ViewTarget;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;

@GlideModule
public class YYGlideModule
extends AppGlideModule {
    private static boolean sHasSetTagId = false;

    @Override
    public void applyOptions(Context context, GlideBuilder builder) {
        if (!sHasSetTagId) {
            int theID = R.id.glide_target_id;
            try {
                ViewTarget.setTagId(theID);
            }
            catch (Exception e) {
                MLog.error("YYGlideModule", e);
            }
            sHasSetTagId = true;
        }
        builder.setBitmapPool(ImageLoader.getBitmapPool());
        builder.setMemoryCache(ImageLoader.getResourceCache());
        ImageLoader.fillExecutor(builder);
        builder.setDiskCache(new MyInternalCacheDiskCacheFactory(context, 0x1E00000));
    }

    @Override
    public void registerComponents(@NonNull Context context, @NonNull Glide glide, @NonNull Registry registry) {
    }

    public static String getImageCacheSize() {
        File cacheDirectory = null;
        boolean storageEnable = FileStorageUtils.getInstance().isExternalStorageAvailable() && FileStorageUtils.getInstance().isExternalStorageWriteable();
        cacheDirectory = storageEnable ? FileStorageUtils.getInstance().getDir(false, "image_manager_disk_cache") : RuntimeContext.sApplicationContext.getCacheDir();
        if (cacheDirectory != null) {
            long size = FileUtils.getFileSize(cacheDirectory);
            return FileUtils.getFileSizeDesp(size);
        }
        return "";
    }

    public final class MyInternalCacheDiskCacheFactory
    extends DiskLruCacheFactory {
        public MyInternalCacheDiskCacheFactory(Context context, int diskCacheSize) {
            this(context, "image_manager_disk_cache", diskCacheSize);
        }

        public MyInternalCacheDiskCacheFactory(final Context context, final String diskCacheName, int diskCacheSize) {
            super(new DiskLruCacheFactory.CacheDirectoryGetter(){

                @Override
                public File getCacheDirectory() {
                    boolean storageEnable;
                    File cacheDirectory = null;
                    boolean bl = storageEnable = FileStorageUtils.getInstance().isExternalStorageAvailable() && FileStorageUtils.getInstance().isExternalStorageWriteable();
                    if (storageEnable) {
                        cacheDirectory = FileStorageUtils.getInstance().getDir(false, diskCacheName);
                    } else {
                        cacheDirectory = context.getCacheDir();
                        if (cacheDirectory == null) {
                            return null;
                        }
                        if (diskCacheName != null) {
                            return new File(cacheDirectory, diskCacheName);
                        }
                    }
                    return cacheDirectory;
                }
            }, (long)diskCacheSize);
        }
    }
}

