/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.httptohttpsstrategyimpl.HttpsSchemeTransformStrategy;
import com.yy.base.imageloader.strategy.StrategySelector;
import com.yy.base.imageloader.strategy.StrategyStatus;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;

public class ImageLoaderBackUrl {
    public static final String OSS_PARAM_MATCH_RULE = "?x-oss-process=image";
    private static volatile IUrlChecker sUrlChecker;

    public static String getBackupUrl(String url) {
        if (sUrlChecker != null) {
            return sUrlChecker.getBackupUrl(url);
        }
        return null;
    }

    private static String removeOssFormat(String url, String format) {
        if (url.startsWith("null") || url.startsWith(format) || url.startsWith("/" + format)) {
            return null;
        }
        int index = url.indexOf(format);
        if (index > 0) {
            url = url.substring(0, index);
        }
        return url;
    }

    private static boolean isHttpRequest(String url) {
        return StringUtils.isNotEmpty(url) && url.startsWith("http");
    }

    private static int containOssParamLastIndex(String url, String format) {
        return StringUtils.isNotEmpty(url) ? url.lastIndexOf(format) : -1;
    }

    private static String removeDuplicatedOssParam(String url, String format) {
        int startIndex;
        boolean containOss;
        int lastIndex = ImageLoaderBackUrl.containOssParamLastIndex(url, format);
        boolean bl = containOss = lastIndex > 0;
        if (containOss && (startIndex = url.indexOf(format)) != lastIndex && startIndex > 0) {
            String endOssString = url.substring(lastIndex);
            url = url.substring(0, startIndex) + endOssString;
        }
        return url;
    }

    private static boolean canTransformToWebP(String url) {
        return YYImageUtils.canUseWebp() && ImageLoaderBackUrl.isOssImageProcessHost(url) && ImageLoaderBackUrl.supportImageFormat(url);
    }

    private static boolean isOssImageProcessHost(String url) {
        if (sUrlChecker != null) {
            return sUrlChecker.isOssImageProcessHost(url);
        }
        return false;
    }

    private static String transformWebPUrl(String url) {
        int lastIndex = ImageLoaderBackUrl.containOssParamLastIndex(url, OSS_PARAM_MATCH_RULE);
        if (lastIndex < 0) {
            url = url + "?x-oss-process=image/format,webp";
        } else if (!url.contains("format,webp")) {
            url = url + "/format,webp";
        }
        return url;
    }

    private static String transformWebPForGifUrl(String url) {
        if (ImageUtil.isGif(url)) {
            int lastIndex = ImageLoaderBackUrl.containOssParamLastIndex(url, OSS_PARAM_MATCH_RULE);
            if (lastIndex < 0) {
                url = url + "?x-oss-process=image/format,webp";
            } else if (!url.contains("format,webp")) {
                url = url + "/format,webp";
            }
        }
        return url;
    }

    public static String urlTransform(RecycleImageView recycleImageView, String originUrl) {
        if (StringUtils.isEmpty(originUrl)) {
            return originUrl;
        }
        if (!ImageLoaderBackUrl.isHttpRequest(originUrl)) {
            return ImageLoaderBackUrl.removeOssFormat(originUrl, OSS_PARAM_MATCH_RULE);
        }
        originUrl = ImageLoaderBackUrl.removeDuplicatedOssParam(originUrl, OSS_PARAM_MATCH_RULE);
        if ((recycleImageView == null || recycleImageView.autoTransforToWebp()) && ImageLoaderBackUrl.canTransformToWebP(originUrl)) {
            originUrl = ImageLoaderBackUrl.transformWebPUrl(originUrl);
        } else if (!ImageLoaderBackUrl.isOssImageProcessHost(originUrl) || !ImageLoaderBackUrl.supportImageFormat(originUrl) && !ImageUtil.isWebPUrl(originUrl) && !ImageUtil.isGif(originUrl)) {
            originUrl = ImageLoaderBackUrl.removeOssFormat(originUrl, OSS_PARAM_MATCH_RULE);
        } else if (ImageUtil.isGif(originUrl)) {
            originUrl = ImageLoaderBackUrl.transformWebPForGifUrl(originUrl);
        }
        originUrl = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.FINAL, originUrl);
        return originUrl;
    }

    private static boolean supportImageFormat(String url) {
        return ImageUtil.isJpg(url) || ImageUtil.isPng(url);
    }

    public static void setUrlChecker(IUrlChecker interceptor) {
        sUrlChecker = interceptor;
    }

    public static interface IUrlChecker {
        public boolean isOssImageProcessHost(String var1);

        public String getBackupUrl(String var1);
    }
}

