/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.timing;

import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.timing.TimingLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimingTracer {
    private static final String TAG = "TimingLogger";
    private static boolean ENABLED;
    private static Map<String, TimingLogger> mTracings;

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    public static void addSplit(String tag, String label) {
        if (ENABLED) {
            if (TextUtils.isEmpty((CharSequence)tag)) {
                MLog.error((Object)TAG, "addSplit: the trace tag shouldn't be empty", new Object[0]);
                return;
            }
            if (mTracings == null) {
                MLog.error((Object)TAG, "addSplit: mTracings null, Did you have called the beginTrace?", new Object[0]);
                return;
            }
            TimingLogger timingLogger = mTracings.get(tag);
            if (timingLogger != null) {
                timingLogger.addSplit(label);
            } else {
                MLog.error((Object)TAG, "addSplit: Did you have called the beginTrace?", new Object[0]);
            }
        }
    }

    public static void beginTrace(String tag) {
        if (ENABLED) {
            if (mTracings == null) {
                mTracings = new ConcurrentHashMap<String, TimingLogger>();
            }
            if (TextUtils.isEmpty((CharSequence)tag)) {
                MLog.error((Object)TAG, "beginTracing: the trace tag shouldn't be empty", new Object[0]);
                return;
            }
            mTracings.put(tag, new TimingLogger(tag));
        }
    }

    public static void stopTrace(String tag) {
        if (!ENABLED) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            MLog.error((Object)TAG, "stopTracing: the trace tag shouldn't be empty", new Object[0]);
            return;
        }
        TimingLogger timingLogger = mTracings.get(tag);
        if (timingLogger != null) {
            mTracings.remove(tag);
            timingLogger.dumpToLog();
        } else {
            MLog.error((Object)TAG, "stopTracing: Did you have called the beginTracing?", new Object[0]);
        }
    }

    static {
        if (!RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        ENABLED = true;
    }
}

