/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core;

import androidx.annotation.NonNull;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.core.EventReceiver;
import com.yy.base.event.core.EventReceiverList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventDispatcher {
    public static final transient String EVENT_LOG_TAG = "FrameWork_Event";
    private final transient HashMap<EventAction, EventReceiverList> mConnections = new HashMap();
    private final transient ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    public void addBinding(@NonNull EventAction eventAction, @NonNull EventReceiver receiver) {
        this.mReadWriteLock.readLock().lock();
        EventReceiverList receiverList = this.mConnections.get(eventAction);
        if (receiverList == null) {
            this.mReadWriteLock.readLock().unlock();
            this.mReadWriteLock.writeLock().lock();
            receiverList = this.mConnections.get(eventAction);
            if (receiverList == null) {
                receiverList = this.buildEventReceiverList(eventAction);
                this.mConnections.put(eventAction, receiverList);
            }
            this.mReadWriteLock.readLock().lock();
            this.mReadWriteLock.writeLock().unlock();
        }
        receiverList.add(receiver);
        this.mReadWriteLock.readLock().unlock();
        this.onAddBinding(eventAction, receiver, receiverList);
    }

    protected EventReceiverList buildEventReceiverList(EventAction eventAction) {
        return new EventReceiverList(eventAction);
    }

    protected void onAddBinding(@NonNull EventAction eventAction, @NonNull EventReceiver receiver, @NonNull EventReceiverList receiverList) {
    }

    public void removeBinding(@NonNull EventAction eventAction, @NonNull EventReceiver receiver) {
        this.mReadWriteLock.readLock().lock();
        EventReceiverList receiverList = this.mConnections.get(eventAction);
        if (receiverList != null) {
            this.mReadWriteLock.readLock().unlock();
            receiverList.remove(receiver);
            if (!eventAction.isSticky() && receiverList.size() == 0) {
                this.mReadWriteLock.writeLock().lock();
                receiverList.onTrim(this.mConnections);
                this.mReadWriteLock.writeLock().unlock();
            }
            this.onRemoveBinding(eventAction, receiver, receiverList);
        } else {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    protected void onRemoveBinding(@NonNull EventAction eventAction, @NonNull EventReceiver receiver, @NonNull EventReceiverList receiverList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(@NonNull EventIntent eventIntent) {
        EventAction eventAction = eventIntent.eventAction();
        this.mReadWriteLock.readLock().lock();
        EventReceiverList receiverList = this.mConnections.get(eventAction);
        this.mReadWriteLock.readLock().unlock();
        if (receiverList != null) {
            receiverList.invokeToReceivers(eventIntent);
        } else if (eventIntent.eventAction().isSticky()) {
            try {
                this.mReadWriteLock.writeLock().lock();
                receiverList = this.mConnections.get(eventAction);
                if (receiverList == null) {
                    receiverList = this.buildEventReceiverList(eventAction);
                    this.mConnections.put(eventAction, receiverList);
                }
                receiverList.invokeToReceivers(eventIntent);
            }
            finally {
                this.mReadWriteLock.writeLock().unlock();
            }
        }
    }

    public boolean hasConnections() {
        this.mReadWriteLock.readLock().lock();
        try {
            boolean bl = !this.mConnections.isEmpty();
            return bl;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }
}

