/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger.memorycachelog;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.LogHandlerThread;
import com.yy.base.logger.LogRunnable;
import com.yy.base.utils.SettingFlags;

public class MemoryCacheLogManager {
    private static final long MAX_CRASH_LOG_SIZE = SettingFlags.getIntValue("crash_log_size", 512) * 1024;
    private static final long MAX_SIZE = (long)((RuntimeContext.getPhoneType() == 1 ? 1.5 : 4.0) * 1024.0 * 1024.0);
    private static long mCurSize = 0L;
    private static long mCurLength = 0L;
    private static LogRunnable mHeadLogRunnable;
    private static LogRunnable mCurLogRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enqueueLogRunnable(LogRunnable logRunnable) {
        Class<MemoryCacheLogManager> clazz = MemoryCacheLogManager.class;
        synchronized (MemoryCacheLogManager.class) {
            ++mCurLength;
            if (mHeadLogRunnable == null) {
                mCurLogRunnable = null;
                mHeadLogRunnable = logRunnable;
            }
            if (mCurLogRunnable == null) {
                mCurLogRunnable = mHeadLogRunnable;
            } else {
                MemoryCacheLogManager.mCurLogRunnable.mNext = logRunnable;
                mCurLogRunnable = logRunnable;
            }
            mCurSize += MemoryCacheLogManager.mCurLogRunnable.size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogRunnable produceLogRunnable() {
        Class<MemoryCacheLogManager> clazz = MemoryCacheLogManager.class;
        synchronized (MemoryCacheLogManager.class) {
            LogRunnable logRunnable;
            if (mCurSize >= MAX_SIZE && mHeadLogRunnable != null) {
                LogRunnable temp;
                mCurSize -= MemoryCacheLogManager.mHeadLogRunnable.size;
                --mCurLength;
                logRunnable = temp = mHeadLogRunnable;
                mHeadLogRunnable = temp.mNext;
            } else {
                logRunnable = LogRunnable.obtain();
            }
            logRunnable.setTime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return logRunnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(boolean isCrash) {
        long size = mCurSize;
        Class<MemoryCacheLogManager> clazz = MemoryCacheLogManager.class;
        synchronized (MemoryCacheLogManager.class) {
            LogRunnable head = mHeadLogRunnable;
            mHeadLogRunnable = null;
            mCurLogRunnable = null;
            mCurSize = 0L;
            mCurLength = 0L;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            while (head != null) {
                if (isCrash) {
                    if ((size -= head.size) <= MAX_CRASH_LOG_SIZE) {
                        LogHandlerThread.getInstance().postLogRunnable(head);
                    }
                } else {
                    LogHandlerThread.getInstance().postLogRunnable(head);
                }
                LogRunnable temp = head.mNext;
                head.mNext = null;
                head = temp;
            }
            return;
        }
    }
}

