/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.webpanim.decoder;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.yy.base.imageloader.webpanim.WebPImage;
import com.yy.base.imageloader.webpanim.WebpHeaderParser;
import com.yy.base.imageloader.webpanim.decoder.Utils;
import com.yy.base.imageloader.webpanim.decoder.WebpDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class AnimatedWebpBitmapDecoder {
    public static final Option<Boolean> DISABLE_BITMAP = Option.memory("com.yy.base.imageloader.webpanim.decoder.AnimatedWebpBitmapDecoder.DisableBitmap", false);
    private final ArrayPool mArrayPool;
    private final BitmapPool mBitmapPool;
    private final GifBitmapProvider mProvider;

    public AnimatedWebpBitmapDecoder(ArrayPool byteArrayPool, BitmapPool bitmapPool) {
        this.mArrayPool = byteArrayPool;
        this.mBitmapPool = bitmapPool;
        this.mProvider = new GifBitmapProvider(bitmapPool, byteArrayPool);
    }

    public boolean handles(InputStream source, @NonNull Options options) throws IOException {
        if (options.get(DISABLE_BITMAP).booleanValue()) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(source, this.mArrayPool);
        return WebpHeaderParser.isAnimatedWebpType(webpType);
    }

    public boolean handles(ByteBuffer source, @NonNull Options options) throws IOException {
        if (options.get(DISABLE_BITMAP).booleanValue()) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(source);
        return WebpHeaderParser.isAnimatedWebpType(webpType);
    }

    public Resource<Bitmap> decode(InputStream source, int width, int height, Options options) throws IOException {
        byte[] data = Utils.inputStreamToBytes(source);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.decode(byteBuffer, width, height, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<Bitmap> decode(ByteBuffer source, int width, int height, Options options) throws IOException {
        int length = source.remaining();
        byte[] data = new byte[length];
        source.get(data, 0, length);
        WebPImage webp = WebPImage.create((byte[])data);
        int sampleSize = Utils.getSampleSize(webp.getWidth(), webp.getHeight(), width, height);
        WebpDecoder webpDecoder = new WebpDecoder(this.mProvider, webp, source, sampleSize);
        try {
            webpDecoder.advance();
            Bitmap firstFrame = webpDecoder.getNextFrame();
            BitmapResource bitmapResource = BitmapResource.obtain(firstFrame, this.mBitmapPool);
            return bitmapResource;
        }
        finally {
            webpDecoder.clear();
        }
    }
}

