/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.glideadapter;

import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.SdkNormalExecutorAdapter;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GlideExecutorDelegate
implements ExecutorService {
    private ExecutorService backupDelegate;
    private SdkNormalExecutorAdapter limitExecutor;
    private boolean executeTaskUseBackupDelegate = false;

    public GlideExecutorDelegate(ExecutorService backupDelegate, SdkNormalExecutorAdapter normalExecutor, boolean executeTaskUseBackupDelegate) {
        this.backupDelegate = backupDelegate;
        this.limitExecutor = normalExecutor;
        this.executeTaskUseBackupDelegate = executeTaskUseBackupDelegate;
    }

    @Override
    public void execute(final @NonNull Runnable command) {
        if (this.executeTaskUseBackupDelegate) {
            this.limitExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    GlideExecutorDelegate.this.backupDelegate.execute(command);
                }
            });
        } else {
            this.limitExecutor.execute(command, 5);
        }
    }

    @Override
    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.submit(task);
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.invokeAll(tasks);
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    @NonNull
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Runnable task, T result) {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.submit(task);
    }

    @Override
    public void shutdown() {
        this.warningUnExpectMethodCall();
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        this.warningUnExpectMethodCall();
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return this.backupDelegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backupDelegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        this.warningUnExpectMethodCall();
        return this.backupDelegate.awaitTermination(timeout, unit);
    }

    public String toString() {
        return this.backupDelegate.toString();
    }

    private void warningUnExpectMethodCall() {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.error("GlideExecutorDelegate", new RuntimeException("must not call this method, find lulong to Handler!"));
        }
    }
}

