/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.timing;

import android.os.Build;
import android.os.Debug;
import android.os.SystemClock;
import android.os.Trace;
import com.yy.base.logger.MLog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yy/base/timing/TimingLogger;", "", "label", "", "(Ljava/lang/String;)V", "tag", "(Ljava/lang/String;Ljava/lang/String;)V", "ENABLE_METHOD_TRACING", "", "mLabel", "mSplitLabels", "Ljava/util/ArrayList;", "getMSplitLabels", "()Ljava/util/ArrayList;", "setMSplitLabels", "(Ljava/util/ArrayList;)V", "mSplits", "", "getMSplits", "setMSplits", "mTag", "addSplit", "", "splitLabel", "dumpToLog", "reset", "Companion", "framework-base_release"})
public final class TimingLogger {
    private String mTag;
    private String mLabel;
    @Nullable
    private ArrayList<Long> mSplits;
    @Nullable
    private ArrayList<String> mSplitLabels;
    private final boolean ENABLE_METHOD_TRACING = false;
    private static final String DEFAULT_TAG = "TimingLogger";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ArrayList<Long> getMSplits() {
        return this.mSplits;
    }

    public final void setMSplits(@Nullable ArrayList<Long> arrayList) {
        this.mSplits = arrayList;
    }

    @Nullable
    public final ArrayList<String> getMSplitLabels() {
        return this.mSplitLabels;
    }

    public final void setMSplitLabels(@Nullable ArrayList<String> arrayList) {
        this.mSplitLabels = arrayList;
    }

    public final void reset(@NotNull String tag, @NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.mTag = tag;
        this.mLabel = label;
        this.reset();
    }

    public final void reset() {
        if (this.mSplits == null) {
            this.mSplits = new ArrayList();
            this.mSplitLabels = new ArrayList();
        } else {
            ArrayList<Long> arrayList = this.mSplits;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            arrayList.clear();
            ArrayList<String> arrayList2 = this.mSplitLabels;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            arrayList2.clear();
        }
    }

    public final void addSplit(@NotNull String splitLabel) {
        Intrinsics.checkParameterIsNotNull((Object)splitLabel, (String)"splitLabel");
        long now = SystemClock.elapsedRealtime();
        ArrayList<String> arrayList = this.mSplitLabels;
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        Collection collection = arrayList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 29) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.mLabel;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
                }
                String string3 = stringBuilder.append(string2).append('#').append(splitLabel).toString();
                StringBuilder stringBuilder2 = new StringBuilder();
                String string4 = this.mLabel;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
                }
                Trace.endAsyncSection((String)string3, (int)stringBuilder2.append(string4).append('#').append(splitLabel).toString().hashCode());
            } else {
                Trace.endSection();
            }
        }
        if (Build.VERSION.SDK_INT >= 29) {
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this.mLabel;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
            }
            String string6 = stringBuilder.append(string5).append('#').append(splitLabel).toString();
            StringBuilder stringBuilder3 = new StringBuilder();
            String string7 = this.mLabel;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
            }
            Trace.beginAsyncSection((String)string6, (int)stringBuilder3.append(string7).append('#').append(splitLabel).toString().hashCode());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string8 = this.mLabel;
            if (string8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
            }
            Trace.beginSection((String)stringBuilder.append(string8).append('#').append(splitLabel).toString());
        }
        ArrayList<Long> arrayList2 = this.mSplits;
        if (arrayList2 == null) {
            Intrinsics.throwNpe();
        }
        arrayList2.add(now);
        ArrayList<String> arrayList3 = this.mSplitLabels;
        if (arrayList3 == null) {
            Intrinsics.throwNpe();
        }
        arrayList3.add(splitLabel);
    }

    /*
     * WARNING - void declaration
     */
    public final void dumpToLog() {
        long last = SystemClock.elapsedRealtime();
        ArrayList<String> arrayList = this.mSplitLabels;
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        Collection collection = arrayList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 29) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.mLabel;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append('#');
                ArrayList<String> arrayList2 = this.mSplitLabels;
                if (arrayList2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = stringBuilder2.append((String)CollectionsKt.last((List)arrayList2)).toString();
                StringBuilder stringBuilder3 = new StringBuilder();
                String string4 = this.mLabel;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
                }
                StringBuilder stringBuilder4 = stringBuilder3.append(string4).append('#');
                ArrayList<String> arrayList3 = this.mSplitLabels;
                if (arrayList3 == null) {
                    Intrinsics.throwNpe();
                }
                Trace.endAsyncSection((String)string3, (int)stringBuilder4.append((String)CollectionsKt.last((List)arrayList3)).toString().hashCode());
            } else {
                Trace.endSection();
            }
        }
        String string5 = this.mTag;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTag");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = this.mLabel;
        if (string6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
        }
        MLog.info(string5, stringBuilder.append(string6).append(": begin").toString(), new Object[0]);
        ArrayList<Long> arrayList4 = this.mSplits;
        if (arrayList4 == null) {
            Intrinsics.throwNpe();
        }
        Long l = arrayList4.get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"mSplits!![0]");
        long first = ((Number)l).longValue();
        long now = 0L;
        int n = 0;
        ArrayList<Long> arrayList5 = this.mSplits;
        if (arrayList5 == null) {
            Intrinsics.throwNpe();
        }
        int n2 = ((Collection)arrayList5).size();
        while (n < n2) {
            String splitLabel;
            Long l2;
            void i;
            ArrayList<Long> arrayList6 = this.mSplits;
            if (arrayList6 == null) {
                Intrinsics.throwNpe();
            }
            Long l3 = arrayList6.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"mSplits!![i]");
            now = ((Number)l3).longValue();
            ArrayList<String> arrayList7 = this.mSplitLabels;
            if (arrayList7 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList7.get((int)i), (String)"mSplitLabels!![i]");
            ArrayList<Long> arrayList8 = this.mSplits;
            if (arrayList8 == null) {
                Intrinsics.throwNpe();
            }
            if (i < arrayList8.size() - 1) {
                ArrayList<Long> arrayList9 = this.mSplits;
                if (arrayList9 == null) {
                    Intrinsics.throwNpe();
                }
                l2 = arrayList9.get((int)(i + true));
            } else {
                l2 = last;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"if (i < mSplits!!.size -\u2026Splits!![i + 1] else last");
            long behind = l2;
            String string7 = this.mTag;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTag");
            }
            StringBuilder stringBuilder5 = new StringBuilder();
            String string8 = this.mLabel;
            if (string8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
            }
            MLog.info(string7, stringBuilder5.append(string8).append(":      ").append(behind - now).append(" ms, ").append(splitLabel).toString(), new Object[0]);
            ++i;
        }
        String string9 = this.mTag;
        if (string9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTag");
        }
        StringBuilder stringBuilder6 = new StringBuilder();
        String string10 = this.mLabel;
        if (string10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLabel");
        }
        MLog.info(string9, stringBuilder6.append(string10).append(": end, ").append(last - first).append(" ms").toString(), new Object[0]);
        if (this.ENABLE_METHOD_TRACING) {
            Debug.stopMethodTracing();
        }
    }

    public TimingLogger(@NotNull String tag, @NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.reset(tag, label);
        if (this.ENABLE_METHOD_TRACING) {
            DateFormat dateFormat = new SimpleDateFormat("dd_MM_yyyy_hh_mm_ss", Locale.getDefault());
            String string2 = dateFormat.format(new Date());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(Date())");
            String logDate = string2;
            if (Build.VERSION.SDK_INT >= 21) {
                Debug.startMethodTracingSampling((String)("sample-" + logDate), (int)0x1000000, (int)10);
            } else {
                Debug.startMethodTracing((String)("sample-" + logDate));
            }
        }
    }

    public TimingLogger(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this(DEFAULT_TAG, label);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/base/timing/TimingLogger$Companion;", "", "()V", "DEFAULT_TAG", "", "framework-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

