/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import androidx.annotation.IntRange;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.Prioritized;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.taskexecutor.YYThreadPoolExecutor;
import com.yy.base.taskexecutor.util.PriorityHelper;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.SystemUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class NewYYTaskExecutor {
    private static final String TAG = "YYTaskExecutor";
    private static final String TIMER_HANDLER_THREAD_NAME = "YYNewTask-scheduled";
    private static Handler timerHandler;
    protected static final Map<Integer, ExecutorService> TYPE_POOLS;
    private static final Map<Runnable, Task> RUNNABLE_TASK_MAP;
    private static final Map<Runnable, Runnable> DELAY_RUNNABLE_TASK_MAP;
    private static final Map<Callback, Task> CALLBACK_TASK_MAP;
    private static final Map<Callback, Runnable> DELAY_CALLBACK_TASK_MAP;

    public static void execute(Runnable runnable) {
        NewYYTaskExecutor.executeWithDelay(-3, runnable, 0L);
    }

    public static <T> void execute(Callback<T> callback) {
        NewYYTaskExecutor.executeWithDelay(-3, callback, 0L);
    }

    public static <T> void executeWithDelay(int executorType, Callback<T> callback, long delayMillis) {
        NewYYTaskExecutor.execute(executorType, callback, delayMillis, 0L);
    }

    public static <T> void executeWithDelay(int executorType, Runnable runnable, long delayMillis) {
        NewYYTaskExecutor.execute(executorType, runnable, delayMillis, 0L);
    }

    public static <T> void executeAtFixedRate(int executorType, Callback<T> callback, long initialDelayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), null, 10, callback, initialDelayMillis, periodMillis);
    }

    public static <T> void executeAtFixedRate(int executorType, Runnable runnable, long initialDelayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), runnable, 10, null, initialDelayMillis, periodMillis);
    }

    public static <T> void execute(int executorType, Runnable runnable, @IntRange(from=-20L, to=19L) int priority, Callback<T> callback, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), runnable, priority, callback, delayMillis, periodMillis);
    }

    public static <T> void execute(final ExecutorService pool, Runnable runnable, @IntRange(from=-20L, to=19L) int priority, Callback<T> callback, long delayMillis, long periodMillis) {
        if (callback == null && runnable == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("callback or runnable cannot null");
            }
            return;
        }
        if (callback != null && runnable != null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("can only choose one , callback or runnable");
            }
            return;
        }
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        if (periodMillis < 0L) {
            periodMillis = 0L;
        }
        NewYYTaskExecutor.removeRunnableInCache(runnable);
        NewYYTaskExecutor.removeCallbackInCache(callback);
        final Task task = Task.obtain(runnable, priority, callback);
        Runnable delayRunnable = null;
        if (delayMillis > 0L) {
            if (periodMillis > 0L) {
                final long finalPeriodMillis = periodMillis;
                delayRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!task.isDone()) {
                            pool.execute(task);
                            NewYYTaskExecutor.getTimerHandler().postDelayed((Runnable)this, finalPeriodMillis);
                        }
                    }
                };
            } else {
                delayRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!task.isDone()) {
                            pool.execute(task);
                        }
                    }
                };
            }
        }
        if (runnable != null) {
            if (delayRunnable != null) {
                DELAY_RUNNABLE_TASK_MAP.put(runnable, delayRunnable);
            }
            RUNNABLE_TASK_MAP.put(runnable, task);
        } else if (callback != null) {
            if (delayRunnable != null) {
                DELAY_CALLBACK_TASK_MAP.put(callback, delayRunnable);
            }
            CALLBACK_TASK_MAP.put(callback, task);
        }
        if (periodMillis == 0L) {
            if (delayMillis == 0L) {
                pool.execute(task);
            } else {
                NewYYTaskExecutor.getTimerHandler().postDelayed(delayRunnable, delayMillis);
            }
        } else {
            task.setSchedule(true);
            NewYYTaskExecutor.getTimerHandler().postDelayed(delayRunnable, delayMillis);
        }
    }

    public static void cancel(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (!RUNNABLE_TASK_MAP.containsKey(runnable)) {
            return;
        }
        Task task = RUNNABLE_TASK_MAP.get(runnable);
        if (task != null) {
            task.cancel(runnable);
        }
        NewYYTaskExecutor.removeRunnableInCache(runnable);
    }

    public static <T> void cancel(Callback<T> callback) {
        if (callback == null) {
            return;
        }
        if (!CALLBACK_TASK_MAP.containsKey(callback)) {
            return;
        }
        Task task = RUNNABLE_TASK_MAP.get(callback);
        if (task != null) {
            task.cancel(callback);
        }
        NewYYTaskExecutor.removeCallbackInCache(callback);
    }

    public static ExecutorService getCommonPool() {
        return NewYYTaskExecutor.getPoolByType(-3);
    }

    public static ExecutorService getSinglePool() {
        return NewYYTaskExecutor.getPoolByType(-1);
    }

    public static ExecutorService getCachePool() {
        return NewYYTaskExecutor.getPoolByType(-2);
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int size) {
        return NewYYTaskExecutor.getPoolByType(size);
    }

    private static void removeRunnableInCache(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (!RUNNABLE_TASK_MAP.containsKey(runnable)) {
            return;
        }
        RUNNABLE_TASK_MAP.remove(runnable);
        if (DELAY_RUNNABLE_TASK_MAP.containsKey(runnable)) {
            Runnable delayRunnable = DELAY_RUNNABLE_TASK_MAP.get(runnable);
            if (delayRunnable != null) {
                NewYYTaskExecutor.getTimerHandler().removeCallbacks(delayRunnable);
            }
            DELAY_RUNNABLE_TASK_MAP.remove(runnable);
        }
    }

    private static void removeCallbackInCache(Callback callback) {
        if (callback == null) {
            return;
        }
        if (!CALLBACK_TASK_MAP.containsKey(callback)) {
            return;
        }
        CALLBACK_TASK_MAP.remove(callback);
        if (DELAY_CALLBACK_TASK_MAP.containsKey(callback)) {
            Runnable delayRunnable = DELAY_CALLBACK_TASK_MAP.get(callback);
            if (delayRunnable != null) {
                NewYYTaskExecutor.getTimerHandler().removeCallbacks(delayRunnable);
            }
            DELAY_CALLBACK_TASK_MAP.remove(callback);
        }
    }

    private static <T> void execute(int executorType, Callback<T> callback, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), null, 10, callback, delayMillis, periodMillis);
    }

    private static void execute(int executorType, Runnable runnable, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), runnable, 10, null, delayMillis, periodMillis);
    }

    private static <T> void execute(int executorType, Runnable runnable, Callback<T> callback, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), runnable, 10, callback, delayMillis, periodMillis);
    }

    private static void execute(int executorType, Runnable runnable, int priority, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), runnable, priority, null, delayMillis, periodMillis);
    }

    private static <T> void execute(int executorType, Callback<T> callback, @IntRange(from=-20L, to=19L) int priority, long delayMillis, long periodMillis) {
        NewYYTaskExecutor.execute(NewYYTaskExecutor.getPoolByType(executorType), null, priority, callback, delayMillis, periodMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getPoolByType(int type) {
        Map<Integer, ExecutorService> map = TYPE_POOLS;
        synchronized (map) {
            ExecutorService pool = TYPE_POOLS.get(type);
            if (pool == null) {
                pool = YYThreadPoolExecutor.createPool(type);
                TYPE_POOLS.put(type, pool);
            }
            return pool;
        }
    }

    protected static Handler getTimerHandler() {
        if (PageResponse.isUseBgTimerHandlerEnable()) {
            if (timerHandler == null) {
                HandlerThread handlerThread = new HandlerThread(TIMER_HANDLER_THREAD_NAME, -2);
                handlerThread.start();
                timerHandler = new Handler(handlerThread.getLooper());
            }
            return timerHandler;
        }
        return YYTaskExecutor.getMainThreadHandler();
    }

    static {
        TYPE_POOLS = new HashMap<Integer, ExecutorService>();
        RUNNABLE_TASK_MAP = new ConcurrentHashMap<Runnable, Task>();
        DELAY_RUNNABLE_TASK_MAP = new ConcurrentHashMap<Runnable, Runnable>();
        CALLBACK_TASK_MAP = new ConcurrentHashMap<Callback, Task>();
        DELAY_CALLBACK_TASK_MAP = new ConcurrentHashMap<Callback, Runnable>();
    }

    protected static class Task<T>
    implements Runnable,
    Prioritized,
    Comparable<Prioritized> {
        protected static final String TAG = "YYTaskExecutor.Task";
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int EXCEPTIONAL = 2;
        private static final int COMPLETING = 3;
        private static final int CANCELLED = 4;
        private static final int INTERRUPTED = 5;
        private static final int TIMEOUT = 6;
        private final AtomicInteger state = new AtomicInteger(0);
        private volatile boolean isSchedule;
        private volatile Thread runner;
        private long mTimeoutMillis;
        private OnTimeoutListener mTimeoutListener;
        private Callback<T> callback;
        private Runnable runnable;
        private static final int MAX_POOL_SIZE = 100;
        private static volatile int HASH_ID = 1;
        private static final Object sPoolSync = new Object();
        private static int sPoolSize = 0;
        private static Task sPool;
        private Task mNext;
        private int priority;
        private int hashId;
        private final Runnable mTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                if (!this.isDone() && mTimeoutListener != null) {
                    this.timeout();
                    mTimeoutListener.onTimeout();
                }
            }
        };

        public Task() {
            this.resetHashId();
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.hashId;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            return loadTask.getPriority() - this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Task obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    Task t = sPool;
                    sPool = t.mNext;
                    t.mNext = null;
                    --sPoolSize;
                    return t;
                }
            }
            return new Task();
        }

        public static Task obtain(Runnable runnable, int priority, Callback callback) {
            Task task = Task.obtain();
            task.runnable = runnable;
            task.callback = callback;
            task.priority = priority;
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 100) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }

        private void reset() {
            this.callback = null;
            this.runnable = null;
            this.isSchedule = false;
            this.runner = null;
            this.state.set(0);
            this.priority = 10;
            this.resetHashId();
            this.mTimeoutMillis = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetHashId() {
            Class<Task> clazz = Task.class;
            synchronized (Task.class) {
                this.hashId = HASH_ID++;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void run() {
            block32: {
                if (this.callback == null && this.runnable == null) {
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.warn(TAG, "task null can not run !!", new Object[0]);
                    }
                    return;
                }
                if (this.isSchedule) {
                    if (this.runner == null) {
                        if (!this.state.compareAndSet(0, 1)) {
                            return;
                        }
                        this.runner = Thread.currentThread();
                        if (this.mTimeoutListener != null) {
                            MLog.warn(TAG, "Scheduled task doesn't support timeout.", new Object[0]);
                        }
                    } else if (this.state.get() != 1) {
                        return;
                    }
                } else {
                    NewYYTaskExecutor.removeCallbackInCache(this.callback);
                    NewYYTaskExecutor.removeRunnableInCache(this.runnable);
                    if (!this.state.compareAndSet(0, 1)) {
                        return;
                    }
                    this.runner = Thread.currentThread();
                    if (this.mTimeoutListener != null) {
                        NewYYTaskExecutor.getTimerHandler().postDelayed(this.mTimeoutRunnable, this.mTimeoutMillis);
                    }
                }
                try {
                    if (this.priority != -9999) {
                        try {
                            int runnerPriority = Process.getThreadPriority((int)Process.myTid());
                            int adjustPriority = PriorityHelper.getAdjustPriority(this.priority, true);
                            if (runnerPriority != adjustPriority) {
                                Process.setThreadPriority((int)adjustPriority);
                            }
                        }
                        catch (Throwable t) {
                            MLog.error((Object)TAG, "setThreadPriority threw caught throwable", t, new Object[0]);
                        }
                    }
                    if (this.callback != null) {
                        final T result = this.callback.doInBackground();
                        if (this.isSchedule) {
                            if (this.state.get() != 1) {
                                return;
                            }
                            YYTaskExecutor.postToMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSuccess(result);
                                }
                            });
                        } else {
                            if (!this.state.compareAndSet(1, 3)) {
                                return;
                            }
                            YYTaskExecutor.postToMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSuccess(result);
                                    this.onDone();
                                }
                            });
                        }
                    } else if (this.runnable != null) {
                        this.runnable.run();
                        if (!this.isSchedule) {
                            if (!this.state.compareAndSet(1, 3)) {
                                return;
                            }
                            this.onDone();
                        }
                    } else {
                        MLog.warn(TAG, "task null can not run !!", new Object[0]);
                    }
                }
                catch (InterruptedException ignore) {
                    this.state.compareAndSet(4, 5);
                }
                catch (Throwable throwable) {
                    if (!this.state.compareAndSet(1, 2)) {
                        return;
                    }
                    if (this.runner != null) {
                        MLog.error((Object)TAG, "thread [%s] fail, error:", this.runner.getName(), throwable.getMessage());
                    }
                    if (this.callback != null) {
                        YYTaskExecutor.postToMainThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onFail(throwable);
                                this.onDone();
                            }
                        });
                    } else {
                        this.onDone();
                    }
                    if (!RuntimeContext.sIsDebuggable && !SystemUtils.isShowEnvSetting()) break block32;
                    YYTaskExecutor.postToMainThread(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(throwable);
                        }
                    });
                }
            }
        }

        public void cancel(Runnable runnable) {
            if (this.runnable == runnable) {
                this.cancel();
            }
        }

        public void cancel(Callback callback) {
            if (this.callback == callback) {
                this.cancel();
            }
        }

        public void cancel() {
            this.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(boolean mayInterruptIfRunning) {
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(4);
            }
            if (this.runner != null) {
                MLog.warn(TAG, "thread [%s] cannel", this.runner.getName());
            }
            if (mayInterruptIfRunning && this.runner != null) {
                this.runner.interrupt();
            }
            if (this.callback != null) {
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCancel();
                        this.onDone();
                    }
                });
            } else {
                this.onDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timeout() {
            if (this.runner != null) {
                MLog.warn(TAG, "thread [%s] timeout", this.runner.getName());
            } else {
                MLog.warn(TAG, "thread timeout", new Object[0]);
            }
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(6);
            }
            if (this.runner != null) {
                this.runner.interrupt();
            }
            this.onDone();
        }

        public boolean isCanceled() {
            return this.state.get() >= 4;
        }

        public boolean isDone() {
            return this.state.get() > 1 || this.runnable == null && this.callback == null;
        }

        public Task<T> setTimeout(long timeoutMillis, OnTimeoutListener listener) {
            this.mTimeoutMillis = timeoutMillis;
            this.mTimeoutListener = listener;
            return this;
        }

        protected void setSchedule(boolean isSchedule) {
            this.isSchedule = isSchedule;
        }

        protected void onDone() {
            NewYYTaskExecutor.getTimerHandler().removeCallbacks(this.mTimeoutRunnable);
            this.mTimeoutListener = null;
            this.recycle();
        }

        public static interface OnTimeoutListener {
            public void onTimeout();
        }
    }

    public static interface Callback<T> {
        public T doInBackground() throws Throwable;

        public void onSuccess(T var1);

        default public void onCancel() {
        }

        default public void onFail(Throwable t) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExecutorType {
        public static final int SINGLE = -1;
        public static final int CACHED = -2;
        public static final int COMMON = -3;
    }
}

