/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.callback.FileCallBack;
import com.yy.base.okhttp.listener.BizTag;
import com.yy.base.okhttp.request.Delivery;
import com.yy.base.okhttp.request.OkHttpRequest;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RequestCall {
    private OkHttpRequest okHttpRequest;
    private Request request;
    private Call call;
    private long readTimeOut;
    private long writeTimeOut;
    private long connTimeOut;
    private long lastUseTime;
    private OkHttpClient clone;
    private int mIndex = RequestCall.generateIndex();
    private String mOriginUrl;
    private long mStartTime;
    private boolean mIsFile = false;
    private boolean mIsRetry = false;
    private boolean mFailOver = false;
    protected static volatile IMonitorCallBack sMonitor;
    protected static volatile IRetryerCallBack sRetryerCallBack;
    private static volatile int sIndex;

    public RequestCall(OkHttpRequest request) {
        this.okHttpRequest = request;
        this.mStartTime = System.currentTimeMillis();
        this.mOriginUrl = request.getUrl();
        if (this.mOriginUrl != null && RuntimeContext.sIsDebuggable && !RuntimeContext.sIsAppStartFinished) {
            if (this.mOriginUrl.contains("gameMeta/go/getGameListB")) {
                return;
            }
            MLog.error((Object)"RequestCall", "%s request hanppen with startup no finished!", this.mOriginUrl);
        }
    }

    public RequestCall readTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
        return this;
    }

    public RequestCall writeTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
        return this;
    }

    public RequestCall connTimeOut(long connTimeOut) {
        this.connTimeOut = connTimeOut;
        return this;
    }

    public RequestCall failOver(boolean failOver) {
        this.mFailOver = failOver;
        return this;
    }

    public Call buildCall(Callback callback) {
        BizTag bizTag = new BizTag();
        bizTag.isFile = this.mIsFile;
        bizTag.businessType = 2;
        bizTag.tag = "FTQuicNetRequestCall";
        this.request = this.generateRequest(callback).tag(BizTag.class, (Object)bizTag).build();
        if (this.readTimeOut > 0L || this.writeTimeOut > 0L || this.connTimeOut > 0L) {
            this.readTimeOut = this.readTimeOut > 0L ? this.readTimeOut : 15000L;
            this.writeTimeOut = this.writeTimeOut > 0L ? this.writeTimeOut : 15000L;
            this.connTimeOut = this.connTimeOut > 0L ? this.connTimeOut : 15000L;
            this.clone = this.okHttpRequest.getOkHttpClient().newBuilder().readTimeout(this.readTimeOut, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS).connectTimeout(this.connTimeOut, TimeUnit.MILLISECONDS).build();
            this.call = this.clone.newCall(this.request);
        } else {
            this.call = this.okHttpRequest.getOkHttpClient().newCall(this.request);
        }
        return this.call;
    }

    public void replaceUrl(String url) {
        this.okHttpRequest.replaceUrl(url);
    }

    private Request.Builder generateRequest(Callback callback) {
        return this.okHttpRequest.generateRequest(callback);
    }

    public void onStartMonitor() {
        if (sMonitor != null && this.okHttpRequest != null) {
            sMonitor.onStart(this.mIndex, this.okHttpRequest.getOrigin(), this.okHttpRequest.getUrl(), this.okHttpRequest.getHeaders());
        }
    }

    public void onResponseMonitor(long contentLength, boolean isRetry) {
        if (sMonitor != null && this.okHttpRequest != null) {
            sMonitor.onResponse(this.mIndex, this.okHttpRequest.getOrigin(), this.okHttpRequest.getUrl(), contentLength, this.okHttpRequest.getHeaders());
        }
    }

    public void onFailureMonitor(Throwable e, boolean isRetry) {
        if (RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast(RuntimeContext.sApplicationContext, "\u7f51\u7edc\u5f02\u5e38\uff01\uff01\u65e5\u5fd7TAG\uff1aFeatureQuicNet, \u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), 1);
            FeatureLog.e("FTQuicNet", " network error e = " + e.getMessage(), new Object[0]);
        }
        if (sMonitor != null && this.okHttpRequest != null) {
            sMonitor.onFailure(this.mIndex, this.okHttpRequest.getOrigin(), this.okHttpRequest.getUrl(), e, this.okHttpRequest.getHeaders());
        }
    }

    public void execute(Callback callback) {
        this.onStartMonitor();
        this.execute(callback, false);
    }

    private void execute(final Callback callback, final boolean retry) {
        this.lastUseTime = SystemClock.uptimeMillis();
        this.mIsFile = callback instanceof FileCallBack;
        this.mIsRetry = retry;
        Callback myCallBack = new Callback(){

            public Object parseNetworkResponse(Response response, int id2) throws Exception {
                if (callback != null) {
                    return callback.parseNetworkResponse(response, id2);
                }
                return null;
            }

            @Override
            public void onError(Call call, Exception e, int id2) {
                if (!retry) {
                    RequestCall.onOriginError(RequestCall.this.mOriginUrl, e);
                }
                if (retry && RequestCall.this.okHttpRequest != null) {
                    RequestCall.onRetryError(RequestCall.this.okHttpRequest.getUrl(), e, RequestCall.this.mOriginUrl);
                }
                String backupUrl = null;
                if (!retry && RequestCall.isErrorNeedRetry(e) && SystemClock.uptimeMillis() - RequestCall.this.lastUseTime < 15000L) {
                    String string2 = backupUrl = sRetryerCallBack != null ? sRetryerCallBack.getBackUpUrl(RequestCall.this.mOriginUrl) : null;
                }
                if (StringUtils.isEmpty(backupUrl)) {
                    if (callback != null) {
                        callback.onError(call, e, id2);
                    }
                    RequestCall.this.onFailureMonitor(e, retry && RequestCall.this.okHttpRequest != null);
                    if (retry) {
                        MLog.error((Object)"RequestCall", "originUrl %s retry error!", RequestCall.this.mOriginUrl);
                    }
                } else {
                    MLog.error((Object)"RequestCall", "start retry, error url:%s retryUrl:%s", RequestCall.this.mOriginUrl, backupUrl);
                    RequestCall.this.okHttpRequest.replaceUrl(backupUrl);
                    RequestCall.this.execute(callback, true);
                }
            }

            public void onResponse(Object response, int id2) {
                long contentLength = 0L;
                if (response instanceof Response) {
                    ResponseBody body = ((Response)response).body();
                    if (body != null) {
                        contentLength = body.contentLength();
                    }
                } else if (response instanceof String) {
                    contentLength = ((String)response).length();
                }
                if (callback != null) {
                    callback.onResponse(response, id2);
                }
                RequestCall.this.onResponseMonitor(contentLength, retry && RequestCall.this.okHttpRequest != null);
                if (retry && RequestCall.this.okHttpRequest != null) {
                    RequestCall.onRetrySuccess(RequestCall.this.okHttpRequest.getUrl(), RequestCall.this.mOriginUrl);
                }
            }
        };
        this.buildCall(myCallBack);
        if (callback != null) {
            callback.onBefore(this.request, this.getOkHttpRequest().getId());
        }
        Delivery.instance.execute(this, myCallBack);
    }

    public static boolean isErrorNeedRetry(Exception e) {
        boolean netOk = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        return !(e != null && netOk ? e instanceof UnknownHostException || e instanceof NoRouteToHostException : !netOk);
    }

    public Call getCall() {
        return this.call;
    }

    public Request getRequest() {
        return this.request;
    }

    public OkHttpRequest getOkHttpRequest() {
        return this.okHttpRequest;
    }

    public Response execute() throws IOException {
        this.buildCall(null);
        return this.call.execute();
    }

    public void cancel() {
        IMonitorCallBack monitor;
        if (this.call != null) {
            this.call.cancel();
        }
        if ((monitor = sMonitor) != null && this.okHttpRequest != null) {
            monitor.onCancel(this.mIndex, this.okHttpRequest.getOrigin(), this.okHttpRequest.getUrl(), this.okHttpRequest.getHeaders());
        }
    }

    public static String getRetryUrl(String originUrl, String url) {
        if (StringUtils.equalsIgnoreCase(originUrl, url)) {
            return sRetryerCallBack != null ? sRetryerCallBack.getBackUpUrl(originUrl) : null;
        }
        return null;
    }

    public static void onRetrySuccess(String url, String originUrl) {
        if (sRetryerCallBack != null) {
            sRetryerCallBack.onRetrySuccess(url);
        }
        MLog.error((Object)"RequestCall", "originUrl %s retry success!", originUrl);
    }

    public static void onRetryError(String url, Exception e, String originUrl) {
        if (sRetryerCallBack != null) {
            sRetryerCallBack.onRetryError(url, e);
        }
        MLog.error((Object)"RequestCall", "originUrl %s retry error!", originUrl);
    }

    public static void onOriginError(String url, Exception e) {
        if (sRetryerCallBack != null) {
            sRetryerCallBack.onOriginError(url, e);
        }
    }

    public static void setMonitor(IMonitorCallBack monitor) {
        sMonitor = monitor;
    }

    public static void setRetryerCallBack(IRetryerCallBack retryerCallBack) {
        sRetryerCallBack = retryerCallBack;
    }

    private static int generateIndex() {
        return ++sIndex;
    }

    static {
        sIndex = 0;
    }

    public static interface IRetryerCallBack {
        public String getBackUpUrl(String var1);

        public void onRetrySuccess(String var1);

        public void onRetryError(String var1, Exception var2);

        public void onOriginError(String var1, Exception var2);
    }

    public static interface IMonitorCallBack {
        public void onStart(int var1, String var2, String var3, Map<String, String> var4);

        public void onCancel(int var1, String var2, String var3, Map<String, String> var4);

        public void onFailure(int var1, String var2, String var3, Throwable var4, Map<String, String> var5);

        public void onResponse(int var1, String var2, String var3, long var4, Map<String, String> var6);
    }
}

