/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.HandlerThread;
import androidx.annotation.RequiresApi;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYExecutors;
import com.yy.base.taskexecutor.YYThread;
import com.yy.base.utils.DontProguardClass;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@DontProguardClass
public class ThreadHookHelper {
    private static final String TAG = "ThreadHookHelper";
    private static IThreadHookSwticher sThreadHookSwticher;

    public static String makeThreadName(String name, String tag) {
        return name == null ? tag : tag + "#" + name;
    }

    private static boolean enableLog() {
        return false;
    }

    public static Timer newTimer(String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Timer: tag: %s!", tag);
        }
        return new Timer(ThreadHookHelper.makeThreadName(null, tag));
    }

    public static Timer newTimer(String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Timer:%s, %s!", name, tag);
        }
        return new Timer(ThreadHookHelper.makeThreadName(name, tag));
    }

    public static Timer newTimer(String name, boolean isDaemon, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Timer:%s, %s, isDaemon:%d!", name, tag, isDaemon ? 1 : 0);
        }
        return new Timer(ThreadHookHelper.makeThreadName(name, tag), isDaemon);
    }

    public static HandlerThread newHandlerThread(String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new newHandlerThread:%s, %s!", name, tag);
        }
        HandlerThread handlerThread = null;
        if (sThreadHookSwticher != null) {
            handlerThread = sThreadHookSwticher.newHandlerThread(tag);
        }
        if (handlerThread == null) {
            handlerThread = new HandlerThread(ThreadHookHelper.makeThreadName(name, tag));
        }
        return handlerThread;
    }

    public static HandlerThread newHandlerThread(String name, int priority, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new newHandlerThread:%s, %s, priority:%d!", name, tag, priority);
        }
        HandlerThread handlerThread = null;
        if (sThreadHookSwticher != null) {
            handlerThread = sThreadHookSwticher.newHandlerThread(tag);
        }
        if (handlerThread == null) {
            handlerThread = new HandlerThread(ThreadHookHelper.makeThreadName(name, tag), priority);
        }
        return handlerThread;
    }

    public static Thread newThread(String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread:%s!", tag);
        }
        return new YYThread(tag);
    }

    public static Thread newThread(Runnable target, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread:%s, target:%s!", tag, target);
        }
        return new YYThread(target, tag);
    }

    public static Thread newThread(ThreadGroup group, Runnable target, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread:%s, target:%s!", tag, target);
        }
        return new YYThread(group, target, tag);
    }

    public static Thread newThread(String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread name:%s, tag:%s!", name, tag);
        }
        return new YYThread(ThreadHookHelper.makeThreadName(name, tag));
    }

    public static Thread newThread(ThreadGroup group, String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread name:%s, tag:%s!", name, tag);
        }
        return new YYThread(group, ThreadHookHelper.makeThreadName(name, tag));
    }

    public static Thread newThread(Runnable target, String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread name:%s, tag:%s!", name, tag);
        }
        return new YYThread(target, ThreadHookHelper.makeThreadName(name, tag));
    }

    public static Thread newThread(ThreadGroup group, Runnable target, String name, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread name:%s, tag:%s!", name, tag);
        }
        return new YYThread(group, target, ThreadHookHelper.makeThreadName(name, tag));
    }

    public static Thread newThread(ThreadGroup group, Runnable target, String name, long stackSize, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new Thread name:%s, tag:%s!", name, tag);
        }
        return new YYThread(group, target, ThreadHookHelper.makeThreadName(name, tag), stackSize);
    }

    public static ExecutorService newSingleThreadExecutor(String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadExecutor tag:%s!", tag);
        }
        return ThreadHookHelper.newSingleThreadExecutor(null, tag);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadExecutor tag:%s, Factory:%s!", tag, threadFactory);
        }
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newSingleThreadExecutor(threadFactory, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? YYExecutors.newSingleThreadExecutor(tag) : YYExecutors.newSingleThreadExecutor(threadFactory, tag);
        }
        return executorService;
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadExecutor tag:%s, threadNum:%d!", tag, nThreads);
        }
        return ThreadHookHelper.newFixedThreadPool(nThreads, null, tag);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadExecutor tag:%s, threadNum:%d, Factory:%s!", tag, nThreads, threadFactory);
        }
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newFixedThreadPool(nThreads, threadFactory, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? YYExecutors.newFixedThreadPool(nThreads, tag) : YYExecutors.newFixedThreadPool(nThreads, threadFactory, tag);
        }
        return executorService;
    }

    public static ExecutorService newCachedThreadPool(String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new CachedThreadPool tag:%s!", tag);
        }
        return ThreadHookHelper.newCachedThreadPool(null, tag);
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new CachedThreadPool tag:%s, threadFactory:%s!", tag, threadFactory);
        }
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newCachedThreadPool(threadFactory, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? YYExecutors.newCachedThreadPool(tag) : YYExecutors.newCachedThreadPool(threadFactory, tag);
        }
        return executorService;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadScheduledExecutor tag:%s!", tag);
        }
        return ThreadHookHelper.newSingleThreadScheduledExecutor(null, tag);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new SingleThreadScheduledExecutor tag:%s, threadFactory:%s!", tag, threadFactory);
        }
        ScheduledExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newSingleThreadScheduledExecutor(threadFactory, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? YYExecutors.newSingleThreadScheduledExecutor(tag) : YYExecutors.newSingleThreadScheduledExecutor(threadFactory, tag);
        }
        return executorService;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPool tag:%s, corePoolSize:%d!", tag, corePoolSize);
        }
        return ThreadHookHelper.newScheduledThreadPoolExecutor(corePoolSize, tag);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPool tag:%s, corePoolSize:%d, threadFactory:%s!", tag, corePoolSize, threadFactory);
        }
        return ThreadHookHelper.newScheduledThreadPoolExecutor(corePoolSize, threadFactory, tag);
    }

    @RequiresApi(api=21)
    public static ExecutorService newWorkStealingPool(String tag) {
        return YYExecutors.newWorkStealingPool(tag);
    }

    @RequiresApi(api=21)
    public static ExecutorService newWorkStealingPool(int parallelism, String tag) {
        return YYExecutors.newWorkStealingPool(parallelism, tag);
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ThreadPoolExecutor tag:%s, corePoolSize:%d, maximumPoolSize:%s!", tag, corePoolSize, maximumPoolSize);
        }
        return ThreadHookHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), tag);
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ThreadPoolExecutor tag:%s, corePoolSize:%d, maximumPoolSize:%s, threadFactory:%s!", tag, corePoolSize, maximumPoolSize, threadFactory);
        }
        return ThreadHookHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new DiscardPolicy(), tag);
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ThreadPoolExecutor tag:%s, corePoolSize:%d, maximumPoolSize:%s, rejectedExecutionHandler:%s!", tag, corePoolSize, maximumPoolSize, handler);
        }
        return ThreadHookHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler, tag);
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ThreadPoolExecutor tag:%s, corePoolSize:%d, maximumPoolSize:%s, threadFactory:%s, rejectedExecutionHandler:%s!", tag, corePoolSize, maximumPoolSize, threadFactory, handler);
        }
        ThreadPoolExecutor executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? (handler != null ? new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler) : new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue)) : (handler != null ? new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler) : new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory));
        }
        return executorService;
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPoolExecutor tag:%s, corePoolSize:%d!", tag, corePoolSize);
        }
        return ThreadHookHelper.newScheduledThreadPoolExecutor(corePoolSize, Executors.defaultThreadFactory(), tag);
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPoolExecutor tag:%s, corePoolSize:%d, threadFactory:%s!", tag, corePoolSize, threadFactory);
        }
        return ThreadHookHelper.newScheduledThreadPoolExecutor(corePoolSize, threadFactory, new DiscardPolicy(), tag);
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPoolExecutor tag:%s, corePoolSize:%d, rejectedExecutionHandler:%s!", tag, corePoolSize, handler);
        }
        return ThreadHookHelper.newScheduledThreadPoolExecutor(corePoolSize, Executors.defaultThreadFactory(), handler, tag);
    }

    public static ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String tag) {
        if (ThreadHookHelper.enableLog()) {
            MLog.info(TAG, "new ScheduledThreadPoolExecutor tag:%s, corePoolSize:%d, threadFactory:%s, rejectedExecutionHandler:%s!", tag, corePoolSize, threadFactory, handler);
        }
        ScheduledThreadPoolExecutor executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newScheduledThreadPoolExecutor(corePoolSize, threadFactory, handler, tag);
        }
        if (executorService == null) {
            executorService = threadFactory == null ? (handler != null ? new ScheduledThreadPoolExecutor(corePoolSize, handler) : new ScheduledThreadPoolExecutor(corePoolSize)) : (handler != null ? new ScheduledThreadPoolExecutor(corePoolSize, threadFactory, handler) : new ScheduledThreadPoolExecutor(corePoolSize, threadFactory));
        }
        return executorService;
    }

    public static void setThreadHookSwticher(IThreadHookSwticher threadHookSwticher) {
        sThreadHookSwticher = threadHookSwticher;
    }

    public static boolean shouldHookOneThread(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldHookOneThread(tag);
        }
        return false;
    }

    public static boolean shouldOneThreadUseHighPriority(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldOneThreadUseHighPriority(tag);
        }
        return false;
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static interface IThreadHookSwticher {
        public boolean shouldHookOneThread(String var1);

        public boolean shouldOneThreadUseHighPriority(String var1);

        public HandlerThread newHandlerThread(String var1);

        public HandlerThread newHandlerThread(int var1, String var2);

        public ExecutorService newSingleThreadExecutor(ThreadFactory var1, String var2);

        public ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory var1, String var2);

        public ExecutorService newFixedThreadPool(int var1, ThreadFactory var2, String var3);

        public ExecutorService newCachedThreadPool(ThreadFactory var1, String var2);

        public ThreadPoolExecutor newThreadPoolExecutor(int var1, int var2, long var3, TimeUnit var5, BlockingQueue<Runnable> var6, ThreadFactory var7, RejectedExecutionHandler var8, String var9);

        public ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int var1, ThreadFactory var2, RejectedExecutionHandler var3, String var4);
    }
}

