/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.Process;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    AtomicInteger mAtomicInteger = new AtomicInteger(0);
    private String mThreadPrefix;
    private int threadPriority;

    public DefaultThreadFactory(String threadPrefix) {
        this(threadPrefix, 10);
    }

    public DefaultThreadFactory(String threadPrefix, int threadPriority) {
        this.mThreadPrefix = threadPrefix;
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(final Runnable r) {
        Runnable wrapperRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Process.setThreadPriority((int)DefaultThreadFactory.this.threadPriority);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                r.run();
            }
        };
        final String index = this.mThreadPrefix + this.mAtomicInteger.incrementAndGet();
        Thread thread = new Thread(wrapperRunnable, index);
        thread.setDaemon(false);
        MLog.info("YYDefaultThreadFactory", "create thread:%s", index);
        if (SystemUtils.isShowEnvSetting()) {
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    PerfActionLog.add("ThreadCreate_" + index, new Object[0]);
                }
            });
        }
        return thread;
    }
}

