/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.yy.base.utils.ResultException;

public final class Result<T> {
    private boolean isSuccess;
    @Nullable
    private T data;
    private Throwable throwable;

    public Result(@Nullable T data) {
        this.data = data;
        this.isSuccess = true;
    }

    public Result(@Nullable Throwable throwable) {
        this.throwable = throwable;
        this.isSuccess = false;
    }

    public Result(int errorCode, String errorMsg) {
        this(new ResultException(errorCode, errorMsg));
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Result<T> onSuccess(Consumer<T> block) {
        if (this.isSuccess) {
            block.accept(this.data);
        }
        return this;
    }

    public Result<T> onFailure(Consumer<Throwable> block) {
        if (!this.isSuccess) {
            block.accept((Object)this.throwable);
        }
        return this;
    }
}

