/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.logger.MLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    public static final int INVALID_VALUE = -1;

    public static Object getObjectByConstructor(String className, Class[] intArgsClass, Object[] intArgs) {
        Object returnObj = null;
        try {
            Class<?> classType = Class.forName(className);
            Constructor<?> constructor = classType.getDeclaredConstructor(intArgsClass);
            constructor.setAccessible(true);
            returnObj = constructor.newInstance(intArgs);
        }
        catch (NoSuchMethodException ex) {
            MLog.processSilentException(ex);
        }
        catch (Exception ex) {
            MLog.processSilentException(ex);
        }
        return returnObj;
    }

    public static void modifyFileValue(Object object, String filedName, String filedValue) {
        Class<?> classType = object.getClass();
        Field fild = null;
        try {
            fild = classType.getDeclaredField(filedName);
            fild.setAccessible(true);
            fild.set(object, filedValue);
        }
        catch (NoSuchFieldException ex) {
            MLog.processSilentException(ex);
        }
        catch (Exception ex) {
            MLog.processSilentException(ex);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Class<?> classType = object.getClass();
        Field fild = null;
        Object fildValue = null;
        try {
            fild = classType.getDeclaredField(fieldName);
            fild.setAccessible(true);
            fildValue = fild.get(object);
        }
        catch (NoSuchFieldException ex) {
            MLog.processSilentException(ex);
        }
        catch (Exception ex) {
            MLog.processSilentException(ex);
        }
        return fildValue;
    }

    public static Object getStaticFieldValue(Class cls, String fieldName) {
        Field fild = null;
        Object fildValue = null;
        try {
            fild = cls.getDeclaredField(fieldName);
            fild.setAccessible(true);
            fildValue = fild.get(null);
        }
        catch (NoSuchFieldException ex) {
            MLog.processSilentException(ex);
        }
        catch (Exception ex) {
            MLog.processSilentException(ex);
        }
        return fildValue;
    }

    public static int getIntFileValue(Object object, String filedName) {
        Class<?> classType = object.getClass();
        Field fild = null;
        int fildValue = -1;
        try {
            fild = classType.getDeclaredField(filedName);
            fild.setAccessible(true);
            fildValue = fild.getInt(object);
        }
        catch (NoSuchFieldException ex) {
            MLog.processSilentException(ex);
        }
        catch (Exception ex) {
            MLog.processSilentException(ex);
        }
        return fildValue;
    }

    public static int getIntFileValueFromClass(Class c, String filedName) {
        Field fild = null;
        int fildValue = 0;
        try {
            fild = c.getDeclaredField(filedName);
            fild.setAccessible(true);
            fildValue = fild.getInt(c);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fildValue;
    }

    public static void setReflectField(Object obj, String field, Object value) {
        try {
            Field f = null;
            try {
                f = obj.getClass().getDeclaredField(field);
            }
            catch (Exception e) {
                f = obj.getClass().getField(field);
            }
            f.setAccessible(true);
            f.set(obj, value);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
    }

    public static void setSuperClassReflectFieldValue(Object obj, String field, Object value) {
        try {
            Field f = null;
            Class<?> curClass = obj.getClass().getSuperclass();
            while (curClass != null) {
                try {
                    f = curClass.getDeclaredField(field);
                    if (f == null) continue;
                    break;
                }
                catch (Exception e) {
                    curClass = curClass.getSuperclass();
                }
            }
            if (f != null) {
                f.setAccessible(true);
                f.set(obj, value);
            }
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
    }

    public static Object getSuperClassReflectFieldValue(Object obj, String field) {
        try {
            Field f = null;
            Class<?> curClass = obj.getClass().getSuperclass();
            while (curClass != null) {
                try {
                    f = curClass.getDeclaredField(field);
                    if (f == null) continue;
                    break;
                }
                catch (Exception e) {
                    curClass = curClass.getSuperclass();
                }
            }
            if (f != null) {
                f.setAccessible(true);
                return f.get(obj);
            }
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        return null;
    }

    public static Object getReflectFieldValue(Object obj, String field) {
        try {
            Field f = null;
            try {
                f = obj.getClass().getDeclaredField(field);
            }
            catch (Exception e) {
                f = obj.getClass().getField(field);
            }
            f.setAccessible(true);
            return f.get(obj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object invokeReflectFunction(Object obj, String method) {
        try {
            Method m = null;
            try {
                m = obj.getClass().getDeclaredMethod(method, new Class[0]);
            }
            catch (Exception e) {
                m = obj.getClass().getMethod(method, new Class[0]);
            }
            m.setAccessible(true);
            return m.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
            return null;
        }
    }

    public static Object invokeObjectMethod(Object o, String methodName, Class[] argsClass, Object[] args) {
        Object returnValue = null;
        try {
            Class<?> c = o.getClass();
            Method method = c.getMethod(methodName, argsClass);
            returnValue = method.invoke(o, args);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        return returnValue;
    }
}

