/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import com.yy.base.okhttp.builder.PostFormBuilder;
import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.request.CountingRequestBody;
import com.yy.base.okhttp.request.Delivery;
import com.yy.base.okhttp.request.OkHttpRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostFormRequest
extends OkHttpRequest {
    private List<PostFormBuilder.FileInput> files;

    public PostFormRequest(OkHttpClient executor, String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostFormBuilder.FileInput> files, int id2) {
        super(executor, url, tag, params, headers, id2);
        this.files = files;
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.files == null || this.files.isEmpty()) {
            FormBody.Builder builder = new FormBody.Builder();
            this.addParams(builder);
            FormBody formBody = builder.build();
            return formBody;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addParams(builder);
        for (int i = 0; i < this.files.size(); ++i) {
            PostFormBuilder.FileInput fileInput = this.files.get(i);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)this.guessMimeType(fileInput.filename)), (File)fileInput.file);
            builder.addFormDataPart(fileInput.key, fileInput.filename, fileBody);
        }
        return builder.build();
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(long bytesWritten, long contentLength) {
                Delivery.instance.sendProgressCallback(callback, bytesWritten, contentLength, PostFormRequest.this.id);
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request.Builder buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody);
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                String value = (String)this.params.get(key);
                if (value == null) {
                    value = "";
                }
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)value));
            }
        }
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params != null) {
            for (String key : this.params.keySet()) {
                String value = (String)this.params.get(key);
                if (value == null) {
                    value = "";
                }
                builder.add(key, value);
            }
        }
    }
}

