/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.thread;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.thread.PriorityThreadFactory;
import com.yy.base.thread.ThreadAsyncAdapter;
import com.yy.base.thread.ThreadPoolRejectHandler;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduledThreadPoolAsyncAdapter
implements ThreadAsyncAdapter {
    private static final String LOG_TAG = "ScheduledThreadPoolAsyncAdapter";
    public static final int MAX_THREAD_POOL_SIZE = 30;
    private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;
    private final ScheduledThreadPoolExecutor mScheduledExecutor;
    private final String mName;
    private WeakHashMap<Runnable, ScheduledFuture> mTaskMap = new WeakHashMap(30);
    private final ReentrantLock mTaskMapLock = new ReentrantLock();

    public ScheduledThreadPoolAsyncAdapter(String name, int corePoolSize, int priority) {
        this.mName = name;
        this.mScheduledExecutor = new ScheduledThreadPoolExecutor(corePoolSize, new PriorityThreadFactory(name, priority));
        this.mScheduledExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.mScheduledExecutor.setRejectedExecutionHandler(new ThreadPoolRejectHandler(name, priority));
        if (Build.VERSION.SDK_INT >= 21) {
            this.mScheduledExecutor.setRemoveOnCancelPolicy(true);
        }
    }

    public ScheduledThreadPoolAsyncAdapter(String name, ScheduledThreadPoolExecutor threadPoolExecutor) {
        this.mName = name;
        this.mScheduledExecutor = threadPoolExecutor;
    }

    @Override
    public boolean post(Runnable r) {
        return this.postDelayed(r, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postDelayed(@NonNull Runnable r, long delayMillis) {
        if (this.verifyMaxPoolSize(r)) {
            try {
                this.mTaskMapLock.lock();
                this.mTaskMap.put(r, this.mScheduledExecutor.schedule(r, delayMillis, TimeUnit.MILLISECONDS));
            }
            finally {
                this.mTaskMapLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean postAtTime(Runnable r, long uptimeMillis) {
        return this.postDelayed(r, Math.max(uptimeMillis - SystemClock.uptimeMillis(), 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallbacks(Runnable r, Object token) {
        ScheduledFuture runnableFuture;
        try {
            this.mTaskMapLock.lock();
            runnableFuture = this.mTaskMap.remove(r);
        }
        finally {
            this.mTaskMapLock.unlock();
        }
        try {
            if (runnableFuture != null) {
                runnableFuture.cancel(false);
                if (Build.VERSION.SDK_INT < 21) {
                    this.mScheduledExecutor.purge();
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)LOG_TAG, "removeCallbacks future cancel error : " + Log.getStackTraceString((Throwable)e), new Object[0]);
        }
    }

    @Override
    public void quit() {
        this.mScheduledExecutor.shutdown();
    }

    @Override
    public boolean isCurrentThread() {
        return false;
    }

    private boolean verifyMaxPoolSize(Runnable runnable) {
        if (this.mScheduledExecutor.getPoolSize() >= 30) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalThreadStateException("thread pool " + this.mName + " reach max pool size, runnable is " + runnable.getClass().getSimpleName());
            }
            MLog.error((Object)LOG_TAG, "thread pool reach max size : " + this.mScheduledExecutor.getPoolSize(), new Object[0]);
            this.mScheduledExecutor.getRejectedExecutionHandler().rejectedExecution(runnable, this.mScheduledExecutor);
            return false;
        }
        return true;
    }
}

