/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.callback;

import android.os.Environment;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.request.Delivery;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public abstract class FileCallBack
extends Callback<File> {
    private String destFileDir;
    private String destFileName;
    private String filePath;
    private static String cacheDir;
    private boolean externalFile = true;

    public FileCallBack(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    public FileCallBack(String path) {
        this.filePath = path;
        this.validateParam();
    }

    public FileCallBack(String path, boolean external) {
        this.filePath = path;
        this.externalFile = external;
        this.validateParam();
    }

    public void validateParam() {
        File externalStorageDirectory = Environment.getExternalStorageDirectory();
        if (this.filePath != null) {
            if (this.externalFile && !this.filePath.startsWith(externalStorageDirectory.getAbsolutePath())) {
                MLog.error((Object)"FileCallBack", "validateParam error, \u81ea\u52a8\u4fee\u6b63", new Object[0]);
                this.externalFile = false;
            } else if (!this.externalFile && this.filePath.startsWith(externalStorageDirectory.getAbsolutePath())) {
                MLog.error((Object)"FileCallBack", "validateParam error, \u81ea\u52a8\u4fee\u6b63", new Object[0]);
                this.externalFile = true;
            }
        }
    }

    @Override
    public File parseNetworkResponse(Response response, int id2) throws Exception {
        return this.saveFile(response, id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveFile(Response response, int id2) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[2048];
        int len = 0;
        FileOutputStream fos = null;
        try {
            is = response.body().byteStream();
            long total = response.body().contentLength();
            long sum = 0L;
            File file = this.createTempFile();
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
                long finalSum = sum += (long)len;
                Delivery.instance.sendProgressCallback(this, (float)finalSum * 1.0f / (float)total, total, id2);
            }
            fos.flush();
            File destFile = this.createNewFile();
            boolean rename = file.renameTo(destFile);
            if (!rename) {
                throw new IOException(String.format("fail to rename from temp file: %s, to dest file: %s", file.getAbsolutePath(), destFile.getAbsolutePath()));
            }
            File file2 = destFile;
            return file2;
        }
        finally {
            try {
                response.body().close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File createTempFile() {
        String downloadFilePath = TextUtils.isEmpty((CharSequence)this.filePath) ? this.destFileDir + this.destFileName : this.filePath;
        String tmpDir = this.externalFile ? this.getExternalCacheDir() : this.getCacheDir();
        String name = TextUtils.isEmpty((CharSequence)downloadFilePath) ? String.valueOf(System.currentTimeMillis()) : MD5Utils.getMd5StringNew(downloadFilePath);
        String path = tmpDir + "/download/" + name;
        return this.createNewFile(path);
    }

    private String getExternalCacheDir() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir();
    }

    private String getCacheDir() {
        return FileStorageUtils.getInstance().getInternalCacheRootDir();
    }

    private File createNewFile() {
        File file = this.createNewFile(this.filePath);
        if (file == null) {
            File dir = new File(this.destFileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(dir, this.destFileName);
        }
        return file;
    }

    private File createNewFile(String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File newFile = new File(path);
            if (!newFile.exists()) {
                try {
                    File parent = newFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    newFile.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                boolean delete = newFile.delete();
                MLog.info("FileCallBack", "file exists and delete: %b", delete);
            }
            return newFile;
        }
        return null;
    }
}

