/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.list;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoSource;
import java.util.List;

public class KvoListHelper {
    public static final String KvoList_EventArg_Key_Type = "KvoList_EventArg_Key_Type";
    public static final String KvoList_EventArg_Key_Range = "KvoList_EventArg_Key_Range";

    public static <T> void notifyInsert(KvoSource source, String name, List<T> list, int location, int length) {
        KvoListHelper.notifyKvoArrayChange(source, name, list, KvoListChangeType.KvoEventArg_Type_Insert, new NSRange(location, length));
    }

    public static <T> void notifyRangeRemove(KvoSource source, String name, List<T> list, int location, int length) {
        KvoListHelper.notifyKvoArrayChange(source, name, list, KvoListChangeType.KvoEventArg_Type_Remove, new NSRange(location, length));
    }

    public static <T> void notifyMove(KvoSource source, String name, List<T> list, int oldLocation, int newLocation) {
        KvoListHelper.notifyKvoArrayChange(source, name, list, KvoListChangeType.KvoEventArg_Type_Move, new NSRange(oldLocation, newLocation - oldLocation));
    }

    public static <T> void notifyRangeReplace(KvoSource source, String name, List<T> list, int location, int length) {
        KvoListHelper.notifyKvoArrayChange(source, name, list, KvoListChangeType.KvoEventArg_Type_Replace, new NSRange(location, length));
    }

    public static <T> void notifyReload(KvoSource source, String name, List<T> list) {
        KvoListHelper.notifyKvoArrayChange(source, name, list, KvoListChangeType.KvoEventArg_Type_Reload, new NSRange(0, list.size()));
    }

    private static <T> void notifyKvoArrayChange(KvoSource source, String name, List<T> list, KvoListChangeType type, NSRange range) {
        KvoEventIntent kvoEventIntent = KvoEventIntent.build(source, name);
        kvoEventIntent.setOldValue(list);
        kvoEventIntent.setNewValue(list);
        kvoEventIntent.putArg(KvoList_EventArg_Key_Range, range);
        kvoEventIntent.putArg(KvoList_EventArg_Key_Type, (Object)type);
        source.notifyEvent(kvoEventIntent);
    }

    public static NSRange getNotifyRange(KvoEventIntent intent) {
        NSRange range = (NSRange)intent.getArgWithKey(KvoList_EventArg_Key_Range);
        return range == null ? new NSRange(0, 0) : range;
    }

    @NonNull
    public static KvoListChangeType getNotifyType(KvoEventIntent intent) {
        KvoListChangeType type = (KvoListChangeType)((Object)intent.getArgWithKey(KvoList_EventArg_Key_Type));
        return type == null ? KvoListChangeType.KvoEventArg_Type_Reload : type;
    }

    public static enum KvoListChangeType {
        KvoEventArg_Type_Insert,
        KvoEventArg_Type_Remove,
        KvoEventArg_Type_Replace,
        KvoEventArg_Type_Move,
        KvoEventArg_Type_Reload;

    }

    public static class NSRange {
        public int position;
        public int length;

        public NSRange(int position, int length) {
            this.length = length;
            this.position = position;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof NSRange)) {
                return false;
            }
            NSRange other = (NSRange)obj;
            return other.position == this.position && other.length == this.length;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @NonNull
        public String toString() {
            return "NSRange : " + this.position + "_" + this.length;
        }
    }
}

