/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.taskexecutor.NamedThreadFactory;
import com.yy.base.taskexecutor.SdkNormalExecutorAdapter;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class YYProxyThreadPoolExecutor
extends ThreadPoolExecutor {
    private static boolean sUseProxy = true;
    private int corePoolSize = 0;
    private int maxCorePoolSize = 1;
    private long keepAliveTime = 0L;
    private TimeUnit unit;
    private ThreadFactory defaultThreadFactory;
    private RejectedExecutionHandler handler;
    private SdkNormalExecutorAdapter mExecutorAdapter;
    private static RejectedExecutionHandler sHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    };

    public YYProxyThreadPoolExecutor(int corePoolSize, String tag) {
        this(corePoolSize, new NamedThreadFactory(tag), tag);
    }

    public YYProxyThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, String tag) {
        this(corePoolSize, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tag);
    }

    public YYProxyThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, (ThreadFactory)new NamedThreadFactory(tag), tag);
    }

    public YYProxyThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, sHandler, tag);
    }

    public YYProxyThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamedThreadFactory(tag), handler, tag);
    }

    public YYProxyThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String tag) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.corePoolSize = corePoolSize;
        this.maxCorePoolSize = maximumPoolSize;
        this.unit = unit;
        this.keepAliveTime = keepAliveTime;
        this.defaultThreadFactory = this.defaultThreadFactory;
        this.handler = handler;
        if (this.maxCorePoolSize > YYTaskExecutor.MAX_THREADPOOL_SIZE / 2) {
            this.maxCorePoolSize = YYTaskExecutor.MAX_THREADPOOL_SIZE / 2;
        }
        this.mExecutorAdapter = new SdkNormalExecutorAdapter(this.maxCorePoolSize > 0 ? maximumPoolSize : 2, tag);
    }

    public void setUseWorkPriority(boolean useWorkPriority) {
        this.mExecutorAdapter.setUseWorkPriority(useWorkPriority);
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        super.setThreadFactory(threadFactory);
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        super.setRejectedExecutionHandler(handler);
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        super.allowCoreThreadTimeOut(value);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maxCorePoolSize = maximumPoolSize;
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.keepAliveTime = time;
        this.unit = unit;
    }

    @Override
    public void purge() {
        super.purge();
    }

    @Override
    public boolean prestartCoreThread() {
        return true;
    }

    @Override
    public int prestartAllCoreThreads() {
        return 1;
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return super.allowsCoreThreadTimeOut();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    @Override
    public boolean remove(Runnable task) {
        return this.mExecutorAdapter.remove(task);
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown()) {
            super.shutdown();
        }
        this.mExecutorAdapter.removeAll();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.mExecutorAdapter.removeAll();
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        return super.isTerminating();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.mExecutorAdapter.execute(command);
    }
}

