/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.webkit.WebView;
import com.yy.base.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/base/utils/WebViewUtils;", "", "()V", "sWebPackage", "Landroid/content/pm/PackageInfo;", "getCurrentWebViewPackage", "context", "Landroid/content/Context;", "getLoadedWebViewPackageInfo", "getNotYetLoadedWebViewPackageInfo", "isWebPackageValid", "", "webPackage", "framework-base_release"})
public final class WebViewUtils {
    private static PackageInfo sWebPackage;
    public static final WebViewUtils INSTANCE;

    @Nullable
    public final PackageInfo getCurrentWebViewPackage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (sWebPackage != null) {
            return sWebPackage;
        }
        PackageInfo webPackage = null;
        if (Build.VERSION.SDK_INT >= 26) {
            webPackage = WebView.getCurrentWebViewPackage();
            if (this.isWebPackageValid(webPackage)) {
                sWebPackage = webPackage;
            }
            return webPackage;
        }
        try {
            PackageInfo loadedWebViewPackageInfo = this.getLoadedWebViewPackageInfo();
            if (this.isWebPackageValid(loadedWebViewPackageInfo)) {
                sWebPackage = loadedWebViewPackageInfo;
            }
            if (loadedWebViewPackageInfo != null) {
                return loadedWebViewPackageInfo;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable e) {
            return null;
        }
        webPackage = this.getNotYetLoadedWebViewPackageInfo(context);
        if (this.isWebPackageValid(webPackage)) {
            sWebPackage = webPackage;
        }
        return webPackage;
    }

    public final boolean isWebPackageValid(@Nullable PackageInfo webPackage) {
        return webPackage != null && (StringUtils.isNotEmpty(webPackage.packageName) || StringUtils.isNotEmpty(webPackage.versionName));
    }

    @SuppressLint(value={"PrivateApi"})
    private final PackageInfo getLoadedWebViewPackageInfo() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> webViewFactoryClass = Class.forName("android.webkit.WebViewFactory");
        Object object = webViewFactoryClass.getMethod("getLoadedPackageInfo", new Class[0]).invoke(null, new Object[0]);
        if (!(object instanceof PackageInfo)) {
            object = null;
        }
        return (PackageInfo)object;
    }

    @SuppressLint(value={"PrivateApi"})
    private final PackageInfo getNotYetLoadedWebViewPackageInfo(Context context) {
        PackageInfo packageInfo;
        Object webviewUpdateServiceClass;
        Object webviewPackageName = null;
        try {
            String string2;
            if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 23) {
                Class<?> webViewFactoryClass = Class.forName("android.webkit.WebViewFactory");
                Object object = webViewFactoryClass.getMethod("getWebViewPackageName", new Class[0]).invoke(null, new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                string2 = (String)object;
            } else {
                webviewUpdateServiceClass = Class.forName("android.webkit.WebViewUpdateService");
                Object object = ((Class)webviewUpdateServiceClass).getMethod("getCurrentWebViewPackageName", new Class[0]).invoke(null, new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                string2 = (String)object;
            }
            webviewUpdateServiceClass = string2;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        webviewPackageName = webviewUpdateServiceClass;
        if (webviewPackageName == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        try {
            packageInfo = pm.getPackageInfo((String)webviewPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
        }
        return packageInfo;
    }

    private WebViewUtils() {
    }

    static {
        WebViewUtils webViewUtils;
        INSTANCE = webViewUtils = new WebViewUtils();
    }
}

