/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.provider.Settings;
import android.text.ClipboardManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ReflectionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemUtils {
    public static final byte APP_STATE_FG = 1;
    public static final byte APP_STATE_BG = 2;
    public static final byte APP_STATE_UNACTIVE = 0;
    public static final String SNAPSHOT_PREFIX = "TMPSNAPSHOT";
    private static final String TAG = "SystemUtilsImpl";
    private static final boolean DEBUG = false;
    private static final int SDK_INT_MEIZU_FLYME_2 = 16;
    private static final int SDK_INT_MEIZU_FLYME_3 = 17;
    private static final String[] MEIZU_SMARTBAR_DEVICE_LIST = new String[]{"M040", "M045"};
    private static Context sContext = null;
    private static String sUCClipboardText;
    private static String sLastSyncUCClipboardText;
    private static boolean sCanUseClipBoxSandBox;
    private static long sLastTimeOfUpdateClipBoard;
    private static int sStatusBarHeight;
    private static boolean sHasCheckStatusBarHeight;
    private static int sNaviBarHeight;
    private static int sVerticalNaviBarHeight;
    private static boolean sEnableTransparentStatusBar;
    private static boolean sHasCheckTransparentStatusBar;
    private static boolean sEnableChangeStatusBarFontColor;
    private static boolean sHasCheckChangeStatusBarFontColor;
    private static boolean sNeedDrawFakeStatusBarBgOnWindow;
    private static boolean sNeedDrawFakeStatusBarBgOnFullScreen;
    private static boolean gIsStatusBarHidden;
    private static boolean sHasCheckedIsRomMainVersionAtLeast4;
    private static boolean sIsRomMainVersionAtLeast4;
    private static boolean sHasCheckedMeizuMXSeries;
    private static boolean sIsMeizuMXSeries;
    private static boolean sHasCheckedMeizuFlyemeVersion;
    private static boolean sIsMeizuFlyme2;
    private static boolean sIsMeizuFlyme3;
    private static boolean sHasCheckedIfMIUISystemV5OrAbove;
    private static boolean sIsMIUISystemV5OrAbove;
    private static boolean mIsACVersion;
    private static Runnable sGcRunnable;
    private static String sLangAndCountryCode;
    private static String sLangAndCountryCodeForUdb;
    private static String sLang;
    private static final String NAVIGATION = "navigationBarBackground";
    private static volatile String sLocaleCountry;
    private static volatile String sNetworkCountry;
    private static int sIsSamSung;
    private static int sIsAndroid9;
    private static volatile String sCountry;
    private static volatile String sSimCountryIso;
    private static volatile String sDeviceCountry;
    private static volatile String sSystemCountry;

    public static void initialize(Context context) {
        if (context != null) {
            sContext = context.getApplicationContext();
        }
    }

    public static void destroy() {
        sContext = null;
    }

    private static void checkIfContextInitialized() {
        if (sContext == null) {
            throw new RuntimeException("context has not been initialized! You MUST call this only after initialize() is invoked.");
        }
    }

    public static boolean setSystemWallpaper(String wallpaperPath) {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.setSystemWallpaper(sContext, wallpaperPath);
    }

    public static String getLastSyncUCClipboardText() {
        return sLastSyncUCClipboardText;
    }

    public static void setLastSyncUCClipboardText(String text) {
        sLastSyncUCClipboardText = text;
    }

    public static String getClipboardText() {
        if (SystemUtils.isClipBoxSandBoxEnable()) {
            return sUCClipboardText;
        }
        return SystemUtils.getClipboardTextFromSystem();
    }

    public static void setClipboardText(String text) {
        if (SystemUtils.isClipBoxSandBoxEnable()) {
            if (text != null) {
                sUCClipboardText = text;
                sLastTimeOfUpdateClipBoard = System.currentTimeMillis();
            }
        } else {
            SystemUtils.setClipboardTextToSystem(text);
        }
    }

    public static boolean isClipBoxSandBoxEnable() {
        return SystemUtils.canUseClipBoxSandBox();
    }

    private static boolean canUseClipBoxSandBox() {
        return sCanUseClipBoxSandBox;
    }

    public static long getLastTimeOfUpdateClipBoard() {
        return sLastTimeOfUpdateClipBoard;
    }

    public static void setUseClipBoxSandBox(boolean use) {
        sCanUseClipBoxSandBox = use;
    }

    public static String getClipboardTextFromSystem() {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.getClipboardText(sContext);
    }

    public static void resetClipboardText() {
        sUCClipboardText = null;
    }

    public static void setClipboardTextToSystem(String text) {
        SystemUtils.checkIfContextInitialized();
        SystemUtils.setClipboardText(sContext, text);
    }

    public static int getSystemBrightness() {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.getSystemBrightness(sContext);
    }

    public static int getStatusBarHeight(Context context) {
        if (sHasCheckStatusBarHeight) {
            return sStatusBarHeight;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object o = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = (Integer)field.get(o);
            sStatusBarHeight = context.getResources().getDimensionPixelSize(x);
            sHasCheckStatusBarHeight = true;
        }
        catch (Exception e) {
            sStatusBarHeight = SystemUtils.guessStatusBarHeight(context);
            sHasCheckStatusBarHeight = true;
            MLog.processSilentException(e);
        }
        return sStatusBarHeight;
    }

    private static int guessStatusBarHeight(Context context) {
        try {
            if (context != null) {
                int statusBarHeightDP = 25;
                float density = context.getResources().getDisplayMetrics().density;
                return Math.round(density * 25.0f);
            }
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        return 0;
    }

    public static boolean isNavigationBarShow(Context context) {
        ViewGroup vp = (ViewGroup)((Activity)context).getWindow().getDecorView();
        if (vp != null) {
            for (int i = 0; i < vp.getChildCount(); ++i) {
                vp.getChildAt(i).getContext().getPackageName();
                if (vp.getChildAt(i).getId() == -1 || !NAVIGATION.equals(context.getResources().getResourceEntryName(vp.getChildAt(i).getId()))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNaviBarHeight(Context context) {
        if (sNaviBarHeight > 0) {
            return sNaviBarHeight;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object o = c.newInstance();
            Field field = c.getField("navigation_bar_height");
            int x = (Integer)field.get(o);
            sNaviBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            int dp = 48;
            float density = context.getResources().getDisplayMetrics().density;
            sNaviBarHeight = Math.round(density * 48.0f);
            MLog.processSilentException(e);
        }
        return sNaviBarHeight;
    }

    public static int getVerticalNaviBarHeight(Context context) {
        if (sVerticalNaviBarHeight > 0) {
            return sVerticalNaviBarHeight;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object o = c.newInstance();
            Field field = c.getField("navigation_bar_width");
            int x = (Integer)field.get(o);
            sVerticalNaviBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            int dp = 42;
            float density = context.getResources().getDisplayMetrics().density;
            sVerticalNaviBarHeight = Math.round(density * 42.0f);
            MLog.processSilentException(e);
        }
        return sVerticalNaviBarHeight;
    }

    public static boolean isResolutionHigherThanQHD(int width, int height) {
        return Math.max(width, height) >= 960 && Math.min(width, height) >= 540;
    }

    public static boolean isResolutionHigherThanWVGA(int width, int height) {
        return Math.max(width, height) >= 800 && Math.min(width, height) >= 480;
    }

    public static boolean checkTransparentStatusBar(Context context) {
        if (sHasCheckTransparentStatusBar) {
            return sEnableTransparentStatusBar;
        }
        return sEnableTransparentStatusBar;
    }

    public static boolean checkChangeStatusBarColorEnable() {
        return sEnableChangeStatusBarFontColor;
    }

    public static boolean isTransparentStatusBarEnable() {
        return sEnableTransparentStatusBar;
    }

    public static boolean isChangeStatusBarFontColorEnable() {
        return sEnableChangeStatusBarFontColor;
    }

    public static void setChangeStatusBarFontColorEnable(boolean statusBarFontColorEnable) {
        sEnableChangeStatusBarFontColor = statusBarFontColorEnable;
    }

    public static boolean needDrawFakeStatusBarBgOnWindow() {
        return sNeedDrawFakeStatusBarBgOnWindow;
    }

    public static void setNeedDrawFakeStatusBarBgOnWindow(boolean b) {
        sNeedDrawFakeStatusBarBgOnWindow = b;
    }

    public static void setNeedDrawFakeStatusBarBgOnFullScreen(boolean b) {
        sNeedDrawFakeStatusBarBgOnFullScreen = b;
    }

    public static boolean needDrawFakeStatusBarBgOnFullScreen() {
        return sNeedDrawFakeStatusBarBgOnFullScreen;
    }

    @TargetApi(value=19)
    public static void configTransparentStatusBar(Window window) {
        if (window != null) {
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    @TargetApi(value=19)
    public static void configTransparentStatusBar(WindowManager.LayoutParams lp) {
        if (lp != null) {
            int flags = 0x4000000;
            int mask = 0x4000000;
            lp.flags = lp.flags & ~mask | flags & mask;
        }
    }

    public static boolean isStatusBarHidden() {
        return gIsStatusBarHidden;
    }

    public static void setStatusBarHidden(boolean isStatusBarHidden) {
        gIsStatusBarHidden = isStatusBarHidden;
    }

    public static boolean isSystemFullScreen(Activity activity) {
        if (activity == null) {
            return false;
        }
        boolean isSystemFullscreen = false;
        Window window = activity.getWindow();
        if (window != null && window.getAttributes() != null) {
            int flag = window.getAttributes().flags;
            if ((flag & 0x400) == 1024) {
                isSystemFullscreen = true;
            } else if ((flag & 0x800) == 2048) {
                isSystemFullscreen = false;
            }
        }
        return isSystemFullscreen;
    }

    public static Bitmap getInstalledAppIcon(String packageName) {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.getInstalledAppIcon(sContext, packageName);
    }

    public static boolean isAppInstalled(String pkgName) {
        boolean appInstalled;
        try {
            PackageManager pm = RuntimeContext.sApplicationContext.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(pkgName, 0);
            appInstalled = packageInfo != null;
        }
        catch (PackageManager.NameNotFoundException error) {
            MLog.error((Object)TAG, "can not find package: %s", pkgName);
            appInstalled = false;
        }
        return appInstalled;
    }

    public static List<String> getInstalledApps() {
        ArrayList<String> appNames = new ArrayList<String>();
        try {
            PackageManager pm = RuntimeContext.sApplicationContext.getPackageManager();
            List installedPackages = pm.getInstalledPackages(0);
            if (!FP.empty(installedPackages)) {
                for (PackageInfo packageInfo : installedPackages) {
                    if (packageInfo == null) continue;
                    appNames.add(packageInfo.packageName);
                }
            }
        }
        catch (Exception error) {
            MLog.error((Object)TAG, "getInstalledApps error: %s", error, new Object[0]);
        }
        return appNames;
    }

    public static boolean installApkFile(String filePath) {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.installApkFile(sContext, filePath);
    }

    public static boolean uninstallPackage(String packageName) {
        SystemUtils.checkIfContextInitialized();
        return SystemUtils.uninstallPackage(sContext, packageName);
    }

    public static int currentTimeSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static String getSystemLanguage() {
        return Locale.getDefault().getLanguage();
    }

    static boolean setSystemWallpaper(Context context, String wallpaperPath) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(wallpaperPath);
            WallpaperManager.getInstance((Context)context).setStream((InputStream)fis);
            fis.close();
            return true;
        }
        catch (Exception e) {
            MLog.processSilentException(e);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {
                MLog.processSilentException(e);
            }
            return false;
        }
    }

    public static boolean isRomMainVersionAtLeast4() {
        if (sHasCheckedIsRomMainVersionAtLeast4) {
            return sIsRomMainVersionAtLeast4;
        }
        boolean isOSVersionValid = Character.getNumericValue(Build.VERSION.RELEASE.trim().charAt(0)) >= 4;
        int sdkversion = Build.VERSION.SDK_INT;
        if (!isOSVersionValid || sdkversion < 14) {
            sIsRomMainVersionAtLeast4 = false;
        } else if (sdkversion < 20) {
            Class<?> displayListClass = null;
            try {
                displayListClass = Class.forName("android.view.DisplayList");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (displayListClass == null) {
                sIsRomMainVersionAtLeast4 = false;
            }
        }
        sHasCheckedIsRomMainVersionAtLeast4 = true;
        return sIsRomMainVersionAtLeast4;
    }

    public static boolean isMeizuMXSeries() {
        if (sHasCheckedMeizuMXSeries) {
            return sIsMeizuMXSeries;
        }
        if (Build.DISPLAY.contains("Flyme")) {
            SystemUtils.checkMeizuFlymeVersion();
            if (!sIsMeizuMXSeries) {
                try {
                    Class<Build> buildClass = Build.class;
                    Method hasSmartBarMethod = buildClass.getMethod("hasSmartBar", new Class[0]);
                    sIsMeizuMXSeries = (Boolean)hasSmartBarMethod.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    MLog.processSilentException(e);
                }
            }
        }
        sHasCheckedMeizuMXSeries = true;
        return sIsMeizuMXSeries;
    }

    private static void checkMeizuFlymeVersion() {
        if (Build.DISPLAY.contains("Flyme")) {
            if (Build.VERSION.SDK_INT == 16) {
                sIsMeizuFlyme2 = true;
            } else if (Build.VERSION.SDK_INT == 17) {
                sIsMeizuFlyme3 = true;
            }
            sIsMeizuMXSeries = true;
        }
    }

    static boolean isMeizuFlyme2() {
        if (!sHasCheckedMeizuFlyemeVersion) {
            SystemUtils.checkMeizuFlymeVersion();
            sHasCheckedMeizuFlyemeVersion = true;
        }
        return sIsMeizuFlyme2;
    }

    public static boolean isMeizuFlyme3() {
        if (!sHasCheckedMeizuFlyemeVersion) {
            SystemUtils.checkMeizuFlymeVersion();
            sHasCheckedMeizuFlyemeVersion = true;
        }
        return sIsMeizuFlyme3;
    }

    public static boolean isSupportStatusBarTextModifyFlyme() {
        return Build.DISPLAY.contains("Flyme") && 19 <= Build.VERSION.SDK_INT;
    }

    public static boolean isMIPhone() {
        return Build.MANUFACTURER.equals("Xiaomi");
    }

    public static boolean isMIBrand() {
        return "Xiaomi".equals(Build.BRAND);
    }

    public static boolean isAsus() {
        return "asus".equalsIgnoreCase(Build.BRAND);
    }

    public static boolean isSamSung() {
        if (sIsSamSung == -1) {
            sIsSamSung = "samsung".equalsIgnoreCase(Build.BRAND) ? 1 : 0;
        }
        return sIsSamSung == 1;
    }

    public static boolean isAndroid9() {
        if (sIsAndroid9 == -1) {
            sIsAndroid9 = Build.VERSION.SDK_INT == 28 ? 1 : 0;
        }
        return sIsAndroid9 == 1;
    }

    public static boolean isMotoGBrand() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && Build.MODEL.contains("MotoE2") && Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isMiUIV6orAbove() {
        try {
            String keyMiuiVersionName = "ro.miui.ui.version.name";
            BuildProperties prop = BuildProperties.newInstance();
            String name = prop.getProperty("ro.miui.ui.version.name", "");
            return "V6".equalsIgnoreCase(name) || "V7".equalsIgnoreCase(name);
        }
        catch (IOException e) {
            MLog.processSilentException(e);
            return false;
        }
    }

    public static boolean isMIUISystemV5OrAbove() {
        if (sHasCheckedIfMIUISystemV5OrAbove) {
            return sIsMIUISystemV5OrAbove;
        }
        String version = "";
        try {
            Class<?> classType = Class.forName("android.os.SystemProperties");
            Method getMethod = classType.getDeclaredMethod("get", String.class);
            version = (String)getMethod.invoke(classType, "ro.miui.ui.version.name");
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        sIsMIUISystemV5OrAbove = !TextUtils.isEmpty((CharSequence)version);
        sHasCheckedIfMIUISystemV5OrAbove = true;
        return sIsMIUISystemV5OrAbove;
    }

    static String getClipboardText(Context context) {
        String text = "";
        try {
            ClipboardManager clipboardManager;
            if (context != null && null != (clipboardManager = SystemServiceUtils.getClipboardManager(context)) && clipboardManager.hasText()) {
                text = text + clipboardManager.getText();
            }
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        return text;
    }

    static void setClipboardText(Context context, String text) {
        ClipboardManager clipboardManager;
        if (context != null && text != null && null != (clipboardManager = SystemServiceUtils.getClipboardManager(context))) {
            try {
                clipboardManager.setText((CharSequence)text);
            }
            catch (Exception e) {
                MLog.processSilentException(e);
            }
        }
    }

    static int getSystemBrightness(Context context) {
        int brightness = 0;
        ContentResolver contentResolver = context.getContentResolver();
        try {
            brightness = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness", (int)-1);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        return brightness;
    }

    static Bitmap getInstalledAppIcon(Context context, String packageName) {
        if (context == null || packageName == null || "".equals(packageName.trim())) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        try {
            Drawable drawable2 = pm.getApplicationIcon(packageName);
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
        }
        catch (Throwable e) {
            MLog.processSilentException(e);
        }
        return null;
    }

    static boolean installApkFile(Context context, String filePath) {
        if (context == null || filePath == null || "".equals(filePath.trim())) {
            return false;
        }
        try {
            File apkFile = new File(filePath);
            if (!apkFile.exists()) {
                return false;
            }
            Intent i = new Intent();
            i.addFlags(0x10000000);
            i.addFlags(0x8000000);
            i.setAction("android.intent.action.VIEW");
            i.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
            context.startActivity(i);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
            return false;
        }
        return true;
    }

    static boolean uninstallPackage(Context context, String packageName) {
        if (context == null || packageName == null || "".equals(packageName.trim())) {
            return false;
        }
        try {
            Uri packageURI = Uri.parse((String)("package:" + packageName));
            Intent i = new Intent("android.intent.action.DELETE", packageURI);
            i.setFlags(0x10000000);
            context.startActivity(i);
        }
        catch (Exception e) {
            MLog.processSilentException(e);
            return false;
        }
        return true;
    }

    private static int getWindowWidth(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        SystemServiceUtils.getWindowManager(context).getDefaultDisplay().getMetrics(dm);
        int deviceWidth = Math.min(dm.widthPixels, dm.heightPixels);
        return deviceWidth;
    }

    public static boolean supportACVersion(Context context) {
        return SystemUtils.isRomMainVersionAtLeast4();
    }

    public static void checkIsACVersion(Context context) {
        SystemUtils.setIsACVersion(SystemUtils.supportACVersion(context));
    }

    public static boolean isACVersion() {
        return mIsACVersion;
    }

    public static void setIsACVersion(boolean isACVersion) {
        mIsACVersion = isACVersion;
    }

    public static boolean checkSystemVersionSatisfied(int lowestVersion) {
        return Build.VERSION.SDK_INT >= lowestVersion;
    }

    public static ButtonOrder getButtonOrder() {
        if (Build.VERSION.SDK_INT < 11) {
            return ButtonOrder.LEFT_TO_RIGHT;
        }
        return ButtonOrder.RIGHT_TO_LEFT;
    }

    public static boolean isButtonOrderLeftToRight() {
        return SystemUtils.getButtonOrder() == ButtonOrder.LEFT_TO_RIGHT;
    }

    public static boolean checkResolutionHigherThanQHD(int width, int height) {
        return Math.max(width, height) >= 960 && Math.min(width, height) >= 540;
    }

    public static final int getIMEHeight(Context context) {
        View root = ((Activity)context).getWindow().getDecorView();
        if (root == null) {
            return -1;
        }
        Rect rect = new Rect();
        root.getWindowVisibleDisplayFrame(rect);
        return root.getHeight() - rect.height();
    }

    public static String getCurrentProcessName() {
        Context context = RuntimeContext.sApplicationContext;
        int pid = Process.myPid();
        List list = SystemServiceUtils.getActivityManager(context).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo appProcess : list) {
                if (appProcess.pid != pid) continue;
                return appProcess.processName;
            }
        }
        return "default";
    }

    public static long getFreeMemory() {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        SystemServiceUtils.getActivityManager(RuntimeContext.sApplicationContext).getMemoryInfo(mi);
        long availableMegs = mi.availMem / 0x100000L;
        return availableMegs;
    }

    public static boolean isSupportModifyStatusBarTextColor() {
        return SystemUtils.isMiUIV6orAbove() || SystemUtils.isSupportStatusBarTextModifyFlyme();
    }

    public static byte getRunningState(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return SystemUtils.getRunningStateAfter21ApiLevel(context);
        }
        if (null == context) {
            if (null == sContext) {
                return 0;
            }
            context = sContext;
        }
        if (SystemServiceUtils.getActivityManager(context) != null) {
            int index = 0;
            List runningTaskInfos = SystemServiceUtils.getActivityManager(context).getRunningTasks(100);
            if (runningTaskInfos == null) {
                return 0;
            }
            for (ActivityManager.RunningTaskInfo runningTaskInfo : runningTaskInfos) {
                ComponentName cn = runningTaskInfo.topActivity;
                ComponentName bn = runningTaskInfo.baseActivity;
                if (cn == null || bn == null) continue;
                String cnPackageName = cn.getPackageName();
                String bnPackageName = bn.getPackageName();
                if (StringUtils.isNotEmpty(cnPackageName) && cnPackageName.equals(context.getPackageName()) && StringUtils.isNotEmpty(bnPackageName) && bnPackageName.equals(context.getPackageName())) {
                    if (index == 0) {
                        return 1;
                    }
                    return 2;
                }
                ++index;
            }
        }
        return 0;
    }

    public static boolean shouldUseToastWindowType() {
        return Build.VERSION.SDK_INT >= 19;
    }

    private static byte getRunningStateAfter21ApiLevel(Context context) {
        List runningTaskInfos;
        boolean needJudgeFgOrBg;
        int result;
        block10: {
            result = 0;
            if (null == context) {
                if (null == sContext) {
                    return 0;
                }
                context = sContext;
            }
            needJudgeFgOrBg = false;
            if (SystemServiceUtils.getActivityManager(context) != null) {
                try {
                    List appTasks = (List)ReflectionUtils.invokeObjectMethod(SystemServiceUtils.getActivityManager(context), "getAppTasks", null, null);
                    if (appTasks == null || appTasks.size() <= 0) break block10;
                    ActivityManager.RecentTaskInfo appRecentTaskInfo = null;
                    for (Object appTask : appTasks) {
                        appRecentTaskInfo = (ActivityManager.RecentTaskInfo)ReflectionUtils.invokeObjectMethod(appTask, "getTaskInfo", null, null);
                        if (appRecentTaskInfo == null || !appRecentTaskInfo.baseIntent.getComponent().getPackageName().equals(context.getPackageName())) continue;
                        if (appRecentTaskInfo.id != -1) {
                            needJudgeFgOrBg = true;
                            result = 2;
                        } else {
                            result = 0;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    MLog.processSilentException(e);
                }
            }
        }
        if (SystemServiceUtils.getActivityManager(context) != null && needJudgeFgOrBg && null != (runningTaskInfos = SystemServiceUtils.getActivityManager(context).getRunningTasks(1)) && runningTaskInfos.size() > 0) {
            ActivityManager.RunningTaskInfo runningTaskInfo = (ActivityManager.RunningTaskInfo)runningTaskInfos.get(0);
            ComponentName cn = runningTaskInfo.topActivity;
            ComponentName bn = runningTaskInfo.baseActivity;
            if (cn != null && bn != null) {
                String cnPackageName = cn.getPackageName();
                result = StringUtils.isNotEmpty(cnPackageName) && cnPackageName.equals(context.getPackageName()) ? 1 : 2;
            }
        }
        return (byte)result;
    }

    public static void gc(long delayMillis) {
        SystemUtils.cancelGc();
        if (RuntimeContext.sIsAppStartFinished) {
            YYTaskExecutor.execute(sGcRunnable, delayMillis);
        }
    }

    public static void cancelGc() {
        YYTaskExecutor.removeTask(sGcRunnable);
    }

    public static String getLangAndCountry() {
        if (TextUtils.isEmpty((CharSequence)sLangAndCountryCode)) {
            sLangAndCountryCode = SystemUtils.getLang() + "_" + SystemUtils.getHagoCountry();
        }
        return sLangAndCountryCode;
    }

    public static String getLangAndCountryForUdb() {
        if (TextUtils.isEmpty((CharSequence)sLangAndCountryCodeForUdb)) {
            sLangAndCountryCodeForUdb = Locale.getDefault().getLanguage() + "-" + SystemUtils.getHagoCountry();
        }
        return sLangAndCountryCodeForUdb;
    }

    public static String getLang() {
        if (TextUtils.isEmpty((CharSequence)sLang)) {
            sLang = Locale.getDefault().getLanguage();
        }
        return sLang;
    }

    public static void setHagoCountry(final String country) {
        if (RuntimeContext.sIsDebuggable) {
            final String countryNewGet = SystemUtils.getHagoCountry();
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    MLog.info(SystemUtils.TAG, "countryNewGet:%s,accountCountry:%s", countryNewGet, country);
                }
            }, 5000L);
        }
        sCountry = country;
        sLangAndCountryCode = null;
        SystemUtils.getLangAndCountry();
    }

    public static String getSimCountryIso() {
        if (StringUtils.isNotEmpty(sSimCountryIso)) {
            return sSimCountryIso;
        }
        try {
            sSimCountryIso = SystemServiceUtils.getTelephonyManager(RuntimeContext.sApplicationContext).getSimCountryIso();
            SystemUtils.log("sim country:" + (sSimCountryIso != null ? sSimCountryIso : ""));
        }
        catch (Exception e) {
            SystemUtils.log("sim country:" + (e != null ? e.toString() : ""));
        }
        return sSimCountryIso;
    }

    public static String getHagoCountry() {
        if (StringUtils.isNotEmpty(sCountry)) {
            return sCountry;
        }
        String country = SystemUtils.getDeviceCountry();
        if (StringUtils.isNotEmpty(country)) {
            sCountry = country;
        }
        return sCountry;
    }

    public static String getDeviceCountry() {
        if (StringUtils.isNotEmpty(sDeviceCountry)) {
            return sDeviceCountry;
        }
        String country = SystemUtils.getSimCountryIso();
        if (StringUtils.isEmpty(country)) {
            country = Locale.getDefault().getCountry();
            SystemUtils.log("Locale country:" + country);
        }
        if (StringUtils.isEmpty(country)) {
            try {
                country = SystemServiceUtils.getTelephonyManager(RuntimeContext.sApplicationContext).getNetworkCountryIso();
                SystemUtils.log("net country:" + country);
            }
            catch (Exception e) {
                SystemUtils.log("net country:" + (e != null ? e.toString() : ""));
            }
        }
        if (StringUtils.isNotEmpty(country)) {
            sDeviceCountry = country;
        }
        return sDeviceCountry;
    }

    public static String getTheSystemCountry() {
        if (StringUtils.isNotEmpty(sSystemCountry)) {
            return sSystemCountry;
        }
        sSystemCountry = Locale.getDefault().getCountry();
        if (StringUtils.isEmpty(sSystemCountry)) {
            sSystemCountry = SystemUtils.getHagoCountry();
        }
        return sSystemCountry;
    }

    public static String getLocaleCountry() {
        if (StringUtils.isNotEmpty(sLocaleCountry)) {
            return sLocaleCountry;
        }
        sLocaleCountry = Locale.getDefault().getCountry();
        return sLocaleCountry;
    }

    public static String getNetworkCountry() {
        if (StringUtils.isNotEmpty(sNetworkCountry)) {
            return sNetworkCountry;
        }
        try {
            sNetworkCountry = SystemServiceUtils.getTelephonyManager(RuntimeContext.sApplicationContext).getNetworkCountryIso();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sNetworkCountry;
    }

    public static boolean isCurrUseVpn() {
        try {
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            if (niList != null) {
                for (NetworkInterface intf : Collections.list(niList)) {
                    if (!intf.isUp() || intf.getInterfaceAddresses().size() == 0 || !"tun0".equals(intf.getName()) && !"ppp0".equals(intf.getName())) continue;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void log(final String text) {
        if (!SettingFlags.hasInited() || RuntimeContext.sApplicationContext == null) {
            Log.i((String)"SystemUtils", (String)text);
            return;
        }
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MLog.info("SystemUtils", text, new Object[0]);
            }
        }, 6000L);
    }

    public static boolean isAI(long uid) {
        return uid >= 900000000L && uid <= 900099999L || (uid & 0xFFFFFFFFL) < 65535L;
    }

    public static boolean isShowEnvSetting() {
        if (TargetBuildConstant.showSetting == 0) {
            return true;
        }
        return TargetBuildConstant.showSetting == 1;
    }

    public static boolean isBetaPackage() {
        return SystemUtils.isShowEnvSetting();
    }

    public static boolean isCpPackage() {
        return false;
    }

    public static boolean isAndroidApiAbove21() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static {
        sNaviBarHeight = -1;
        sVerticalNaviBarHeight = -1;
        sEnableTransparentStatusBar = false;
        sHasCheckTransparentStatusBar = false;
        sEnableChangeStatusBarFontColor = false;
        sHasCheckChangeStatusBarFontColor = false;
        sNeedDrawFakeStatusBarBgOnWindow = true;
        sNeedDrawFakeStatusBarBgOnFullScreen = true;
        sHasCheckedIsRomMainVersionAtLeast4 = false;
        sIsRomMainVersionAtLeast4 = true;
        sHasCheckedMeizuMXSeries = false;
        sIsMeizuMXSeries = false;
        sHasCheckedMeizuFlyemeVersion = false;
        sIsMeizuFlyme2 = false;
        sIsMeizuFlyme3 = false;
        sHasCheckedIfMIUISystemV5OrAbove = false;
        sIsMIUISystemV5OrAbove = false;
        sGcRunnable = new GcRunable();
        sLocaleCountry = "";
        sNetworkCountry = "";
        sIsSamSung = -1;
        sIsAndroid9 = -1;
        sCountry = "";
        sSimCountryIso = "";
        sDeviceCountry = "";
        sSystemCountry = "";
    }

    static class GcRunable
    implements Runnable {
        GcRunable() {
        }

        @Override
        public void run() {
            System.gc();
        }
    }

    private static class BuildProperties {
        private final Properties properties = new Properties();

        private BuildProperties() throws IOException {
            this.properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
        }

        public static BuildProperties newInstance() throws IOException {
            return new BuildProperties();
        }

        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.properties.entrySet();
        }

        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public String getProperty(String name, String defaultValue) {
            return this.properties.getProperty(name, defaultValue);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public Enumeration<Object> keys() {
            return this.properties.keys();
        }

        public Set<Object> keySet() {
            return this.properties.keySet();
        }

        public int size() {
            return this.properties.size();
        }

        public Collection<Object> values() {
            return this.properties.values();
        }
    }

    public static enum ButtonOrder {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

