/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.customcache;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;

public class YYLruResourceCache
extends LruResourceCache {
    private static final String TAG = "YYLruResourceCache";
    private static boolean sDebug = ImageLoader.sDebugSwitch && RuntimeContext.sIsDebuggable;

    public YYLruResourceCache(int size) {
        super(size);
    }

    @Override
    public Resource<?> remove(Key key) {
        if (sDebug && key != null && !MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "remove key:" + key, new Object[0]);
        }
        return (Resource)super.remove(key);
    }

    @Override
    public Resource<?> put(Key key, Resource<?> resource) {
        if (sDebug && key != null && resource != null) {
            MLog.debug(TAG, "put key:" + key + " resource:" + resource.toString(), new Object[0]);
        }
        Resource<?> result = null;
        try {
            result = super.put(key, resource);
        }
        catch (IllegalStateException e) {
            MLog.error(TAG, e);
        }
        return result;
    }

    @Override
    public Resource<?> get(Key key) {
        Resource resource = (Resource)super.get(key);
        if (sDebug && key != null) {
            if (resource != null) {
                MLog.debug(TAG, "get key:" + key + " resource:" + resource.toString(), new Object[0]);
            } else {
                MLog.debug(TAG, "get key:" + key + " resource null", new Object[0]);
            }
        }
        return resource;
    }

    @Override
    public void trimMemory(int level) {
        MLog.info(TAG, "trimMemory, level=" + level, new Object[0]);
        if (level >= 40) {
            super.trimMemory(level);
        } else {
            super.trimToSize(this.getCurrentSize() / 2L);
        }
    }
}

