/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import java.io.File;
import java.text.DecimalFormat;

@Deprecated
public final class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String[] mCs = new String[]{"/", "\\", "?", "*", ":", "<", ">", "|", "\""};
    private static final char UNICODE_SURROGATE_START_CHAR = '\ud800';
    private static final char UNICODE_SURROGATE_END_CHAR = '\udfff';

    public static boolean delete(File file) {
        return YYFileUtils.delete(file);
    }

    public static boolean delete(String path) {
        return FileUtils.delete(new File(path));
    }

    public static byte deleteFile(File item) {
        return YYFileUtils.deleteFile(item);
    }

    public static File createNewFile(String path, boolean append) {
        return YYFileUtils.createNewFile(path, append);
    }

    public static File createNewFile(String path) {
        return FileUtils.createNewFile(path, false);
    }

    public static boolean isPathExist(String path) {
        return YYFileUtils.isPathExist(path);
    }

    public static String getFileName(String path) {
        int index = FileUtils.getLastSlashIndex(path);
        if (index < 0 || index >= path.length()) {
            return null;
        }
        return path.substring(index + 1);
    }

    public static String getDirectoryPath(String path) {
        int index = FileUtils.getLastSlashIndex(path);
        if (index < 0 || index >= path.length()) {
            return null;
        }
        return path.substring(0, index + 1);
    }

    public static int getLastSlashIndex(String path) {
        int index = -1;
        if (StringUtils.isEmpty(path)) {
            return index;
        }
        int unixSlash = path.lastIndexOf("/");
        int windowsSlash = path.lastIndexOf("\\");
        index = Math.max(unixSlash, windowsSlash);
        return index;
    }

    public static String getFileSizeDesp(double fileSize) {
        String strReturnVal = "";
        if (fileSize <= 1048576.0) {
            DecimalFormat df = new DecimalFormat("#.##");
            strReturnVal = df.format(fileSize / 1024.0) + "K";
        } else {
            DecimalFormat df = new DecimalFormat("#.##");
            strReturnVal = df.format(fileSize / 1048576.0) + "M";
        }
        return strReturnVal;
    }

    public static String getFileSizeDesp(long fileSize) {
        double tmpFileSize = (double)fileSize * 1.0;
        return FileUtils.getFileSizeDesp(tmpFileSize);
    }

    public static String getFileSizeDesp(long fileSize, String defaultString) {
        try {
            String returnValString = FileUtils.getFileSizeDesp(fileSize);
            if (StringUtils.isEmpty(returnValString)) {
                return defaultString;
            }
            return returnValString;
        }
        catch (Exception e) {
            return defaultString;
        }
    }

    public static long getFileSize(File file) {
        return YYFileUtils.getFileSize(file);
    }

    public static byte makeDirs(String path) {
        return YYFileUtils.makeDirs(path);
    }

    public static boolean isFileNameCorrect(String fileName) {
        if (null == fileName) {
            return false;
        }
        if ((fileName = fileName.trim()).length() == 0) {
            return false;
        }
        for (String c : mCs) {
            if (!fileName.contains(c)) continue;
            return false;
        }
        return !StringUtils.containsSurrogateChar(fileName);
    }

    public static String fixFileName(String fileName) {
        if (null == fileName) {
            return null;
        }
        String result = fileName.toString();
        for (String c : mCs) {
            result = result.replace(c, "");
        }
        if (FileUtils.containsSurrogateChar(result)) {
            result = FileUtils.removeSurrogateChars(result);
        }
        return result;
    }

    public static String removeSurrogateChars(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        int length = string2.length();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if (c >= '\ud800' && c <= '\udfff') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean containsSurrogateChar(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return false;
        }
        int length = string2.length();
        boolean hasSurrogateChar = false;
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if ('\ud800' > c || c > '\udfff') continue;
            hasSurrogateChar = true;
            break;
        }
        return hasSurrogateChar;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }
}

